/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import net.sf.jadretro.OpByteCode;

final class OpCodeSimple
extends OpByteCode {
    private static final int ACONST_NULL = 1;
    private static final int ARETURN = 176;
    private static final int ATHROW = 191;
    private static final int DCONST_0 = 14;
    private static final int DUP = 89;
    private static final int FCONST_0 = 11;
    private static final int ICONST_0 = 3;
    private static final int IRETURN = 172;
    private static final int LCONST_0 = 9;
    private static final int MONITOREXIT = 195;
    private static final int RETURN = 177;
    private int op;

    OpCodeSimple(int n) {
        this.op = n;
    }

    static OpCodeSimple makeAreturn() {
        return new OpCodeSimple(176);
    }

    static OpCodeSimple makeAthrow() {
        return new OpCodeSimple(191);
    }

    static OpCodeSimple makeDup() {
        return new OpCodeSimple(89);
    }

    static OpCodeSimple makeIconstZero() {
        return new OpCodeSimple(3);
    }

    static OpCodeSimple makeMonitorexit() {
        return new OpCodeSimple(195);
    }

    int getLength(int n) {
        return 1;
    }

    void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.op);
    }

    boolean isEqualTo(OpByteCode opByteCode, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Hashtable hashtable) {
        if (!(opByteCode instanceof OpCodeSimple)) {
            return false;
        }
        return ((OpCodeSimple)opByteCode).op == this.op;
    }

    boolean isAthrow() {
        return this.op == 191;
    }

    boolean isMonitorexit() {
        return this.op == 195;
    }

    boolean isXConstZero() {
        return this.op == 1 || this.op == 3 || this.op == 9 || this.op == 11 || this.op == 14;
    }

    boolean isXReturn() {
        return this.op >= 172 && this.op <= 177;
    }

    boolean isUncondBranch() {
        return this.op == 191 || this.op >= 172 && this.op <= 177;
    }
}

