/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadretro;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jadretro.BadClassFileException;
import net.sf.jadretro.CodeAbsLabel;
import net.sf.jadretro.OpByteCode;

final class OpCodeSwitch
extends OpByteCode {
    private static final int LOOKUPSWITCH = 171;
    private static final int TABLESWITCH = 170;
    private CodeAbsLabel defaultLabel;
    private int lowValue;
    private int[] matchValues;
    private Vector gotoLabels;

    private OpCodeSwitch(CodeAbsLabel codeAbsLabel, int n, int[] nArray, Vector vector) {
        this.defaultLabel = codeAbsLabel;
        this.lowValue = n;
        this.matchValues = nArray;
        this.gotoLabels = vector;
    }

    private static int padSize(int n) {
        return ~n & 3;
    }

    static OpCodeSwitch decode(int n, InputStream inputStream, int n2) throws IOException {
        int[] nArray;
        int n3;
        int n4;
        if (n != 171 && n != 170) {
            return null;
        }
        for (int i = OpCodeSwitch.padSize(n2); i > 0; --i) {
            if (inputStream.read() == 0) continue;
            throw new BadClassFileException();
        }
        CodeAbsLabel codeAbsLabel = new CodeAbsLabel(inputStream, true, n2);
        if (n == 171) {
            n4 = OpCodeSwitch.readInt(inputStream);
            if (n4 < 0) {
                throw new BadClassFileException();
            }
            n3 = 0;
            nArray = new int[n4];
        } else {
            n3 = OpCodeSwitch.readInt(inputStream);
            n4 = OpCodeSwitch.readInt(inputStream) - n3 + 1;
            if (n4 < 0) {
                throw new BadClassFileException();
            }
            nArray = null;
        }
        Vector<CodeAbsLabel> vector = new Vector<CodeAbsLabel>(n4);
        for (int i = 0; i < n4; ++i) {
            if (nArray != null) {
                int n5 = OpCodeSwitch.readInt(inputStream);
                if (i > 0 && nArray[i - 1] >= n5) {
                    throw new BadClassFileException();
                }
                nArray[i] = n5;
            }
            vector.addElement(new CodeAbsLabel(inputStream, true, n2));
        }
        return new OpCodeSwitch(codeAbsLabel, n3, nArray, vector);
    }

    void mapLabelsPc(int[] nArray) throws BadClassFileException {
        this.defaultLabel.mapLabelsPc(nArray);
        OpCodeSwitch.mapLabelsPcForArray(this.gotoLabels, nArray);
    }

    void incLabelIndices(int n, int n2) {
        this.defaultLabel.incLabelIndices(n, n2);
        OpCodeSwitch.incLabelIndicesForArray(this.gotoLabels, n, n2);
    }

    void rebuildLabelsPc(int[] nArray) {
        this.defaultLabel.rebuildLabelsPc(nArray);
        OpCodeSwitch.rebuildLabelsPcForArray(this.gotoLabels, nArray);
    }

    int getLength(int n) {
        return OpCodeSwitch.padSize(n) + ((this.matchValues != null ? this.matchValues.length << 1 : this.gotoLabels.size() + 1) << 2) + 9;
    }

    void writeRelTo(OutputStream outputStream, int n) throws IOException {
        int n2;
        outputStream.write(this.matchValues != null ? 171 : 170);
        for (n2 = OpCodeSwitch.padSize(n); n2 > 0; --n2) {
            outputStream.write(0);
        }
        this.defaultLabel.writeRelTo(outputStream, true, n);
        n2 = this.gotoLabels.size();
        if (this.matchValues != null) {
            OpCodeSwitch.writeInt(outputStream, n2);
        } else {
            OpCodeSwitch.writeInt(outputStream, this.lowValue);
            OpCodeSwitch.writeInt(outputStream, this.lowValue + n2 - 1);
        }
        for (int i = 0; i < n2; ++i) {
            if (this.matchValues != null) {
                OpCodeSwitch.writeInt(outputStream, this.matchValues[i]);
            }
            ((CodeAbsLabel)this.gotoLabels.elementAt(i)).writeRelTo(outputStream, true, n);
        }
    }

    boolean isEqualTo(OpByteCode opByteCode, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Hashtable hashtable) {
        int n5;
        if (!(opByteCode instanceof OpCodeSwitch)) {
            return false;
        }
        OpCodeSwitch opCodeSwitch = (OpCodeSwitch)opByteCode;
        int n6 = this.gotoLabels.size();
        if (opCodeSwitch.gotoLabels.size() != n6 || this.lowValue != opCodeSwitch.lowValue || !this.defaultLabel.isEqualTo(opCodeSwitch.defaultLabel, n, n2, n3, nArray)) {
            return false;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            if (((CodeAbsLabel)this.gotoLabels.elementAt(n5)).isEqualTo((CodeAbsLabel)opCodeSwitch.gotoLabels.elementAt(n5), n, n2, n3, nArray)) continue;
            return false;
        }
        if (this.matchValues != null) {
            if (opCodeSwitch.matchValues == null) {
                return false;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                if (this.matchValues[n5] == opCodeSwitch.matchValues[n5]) continue;
                return false;
            }
        } else if (opCodeSwitch.matchValues != null) {
            return false;
        }
        return true;
    }

    boolean isTargetInRange(int n, int n2) {
        if (this.defaultLabel.isInRange(n, n2)) {
            return true;
        }
        int n3 = this.gotoLabels.size();
        for (int i = 0; i < n3; ++i) {
            if (!((CodeAbsLabel)this.gotoLabels.elementAt(i)).isInRange(n, n2)) continue;
            return true;
        }
        return false;
    }

    boolean isUncondBranch() {
        return true;
    }
}

