/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.MemberValueInfo;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberValuePairInfo {
    private int u2memberNameIndex;
    private MemberValueInfo value;

    public static MemberValuePairInfo create(DataInput din) throws IOException, ClassFileException {
        MemberValuePairInfo mvpi = new MemberValuePairInfo();
        mvpi.read(din);
        return mvpi;
    }

    private MemberValuePairInfo() {
    }

    protected int getMemberNameIndex() {
        return this.u2memberNameIndex;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2memberNameIndex);
        this.value.markUtf8Refs(pool);
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u2memberNameIndex = din.readUnsignedShort();
        this.value = MemberValueInfo.create(din);
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2memberNameIndex);
        this.value.write(dout);
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        this.value.remap(cf, nm);
    }
}

