/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassCpInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.CpInfo;
import COM.rl.obf.classfile.NameAndTypeCpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class RefCpInfo
extends CpInfo {
    private int u2classIndex;
    private int u2nameAndTypeIndex;

    protected RefCpInfo(int tag) {
        super(tag);
    }

    protected int getClassIndex() {
        return this.u2classIndex;
    }

    protected int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    protected void setNameAndTypeIndex(int index) {
        this.u2nameAndTypeIndex = index;
    }

    public String getClassName(ClassFile cf) throws ClassFileException {
        ClassCpInfo entry = (ClassCpInfo)cf.getCpEntry(this.u2classIndex);
        return entry.getName(cf);
    }

    public String getName(ClassFile cf) throws ClassFileException {
        NameAndTypeCpInfo ntCpInfo = (NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex);
        return cf.getUtf8(ntCpInfo.getNameIndex());
    }

    public String getDescriptor(ClassFile cf) throws ClassFileException {
        NameAndTypeCpInfo ntCpInfo = (NameAndTypeCpInfo)cf.getCpEntry(this.u2nameAndTypeIndex);
        return cf.getUtf8(ntCpInfo.getDescriptorIndex());
    }

    @Override
    protected void markNTRefs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2nameAndTypeIndex);
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2classIndex = din.readUnsignedShort();
        this.u2nameAndTypeIndex = din.readUnsignedShort();
    }

    @Override
    protected void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2classIndex);
        dout.writeShort(this.u2nameAndTypeIndex);
    }
}

