p586
                model flat
locals @@
CODE            segment para public 'CODE' use32

                public start
start           proc near
                push    0
                call    GetModuleHandleA
                mov     Our_Handle, eax

                push    100h
                push    offset str_buf
                push    eax
                call    GetModuleFileNameA
                mov     ecx, eax
                mov     esi, offset str_buf
                mov     edi, esi
                sub     edi, 4
@@path_loop:
                cmp     byte ptr [esi], '.'
                jnz     @@next_char
                mov     edi, esi
@@next_char:
                inc     esi
                loop    @@path_loop
                mov     dword ptr [edi], 'ini.'
                push    offset str_buf
                push    offset ini_file
                call    lstrcpyA

;                push    offset ini_file
;                push    100h
;                push    offset str_buf
;                push    offset lng_English
;                push    offset ini_Language
;                push    offset ini_General
;                call    GetPrivateProfileStringA

;                push    offset str_buf
;                push    offset lng_english
;                call    lstrcmpA
;                mov     esi, 100
;                cmp     eax, 0
;                jz      @@lng_ok
;
;                push    offset str_buf
;                push    offset lng_russian
;                call    lstrcmpA
;                mov     esi, 200
;                cmp     eax, 0
;                jz      @@lng_ok
;                mov     esi, 100

@@lng_ok:
                push    101
                push    Our_Handle
                call    LoadMenuA
                mov     Menu_Handle, eax

;                call    LoadStrings

                push    0
                push    offset Dlg_Proc
                push    0
                push    101
                push    Our_Handle
                call    DialogBoxParamA

                push    0
                call    ExitProcess
start           endp

Dlg_Proc  proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h
arg_C           = dword ptr  14h

                push    ebp
                mov     ebp, esp
                mov     eax, [ebp+arg_0]
                mov     Dlg_hwnd, eax
                mov     eax, [ebp+arg_4]

                cmp     eax, 112h
                jz      SysCommand   ; Proceed minimaze,restore and close events

                cmp     eax,400h
                jz      Tray_Event

                cmp     eax,402h
                jz      Dev_Notify

                cmp     eax, 110h
                jz      Dlg_Init     ; Initialize

                cmp     eax, 111h
                jz      Dlg_Command  ; Proceed DLG events

                cmp     eax,4Eh
                jz      WM_NOTIFY    ; Proceed mouse or kbd events on window
dlg_default:
                xor     eax, eax
                leave
                retn    10h

dlg_exit:
                mov    eax,1
                leave
                retn    10h

;------------------------------------
;------------------------------------
;------------------------------------
SysCommand: ; Proceed minimaze,restore and close events
                mov    eax, [ebp+arg_8]
                cmp    eax, 0F060h ;SC_Close
                jz     Dlg_close
                cmp    eax, 0F020h ;SC_Minimize
                jz     Minimize
                jmp    dlg_default
Minimize:
                push   0           ; Hide
                push   [ebp+arg_0]
                call   ShowWindow

                push    offset Tray_Struc
                push    0               ; Msg_ID - 0 - add
                call    Shell_NotifyIconA

                jmp    dlg_exit
;------------------------------------
Tray_Event:
                cmp     [ebp+arg_C], 202h ; LButtonUp (205 - RButt)
                jnz     dlg_exit
                push   1                ;Shownormal
                push   [ebp+arg_0]
                call   ShowWindow

                push    offset Tray_Struc
                push    2               ; Msg_ID - 2 - del
                call    Shell_NotifyIconA

                jmp    dlg_exit





;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------

Dlg_Command:   ; Proceed DLG events
                mov     eax, [ebp+arg_8]

                cmp     eax, 1001
                jz      bt_List

                cmp     eax, 1007
                jz      bt_suspend

                cmp     eax, 1003
                jz      bt_restart

                cmp     eax, 1002
                jz      bt_upload

                cmp     eax, 1006
                jz      bt_delete

                cmp     eax, 1102
                jz      bt_delete

                cmp     eax, 1101
                jz      bt_download

                cmp     eax, 1005
                jz      bt_download

                cmp     eax, 1017
                jz      bt_about

                cmp     eax, 1011
                jz      bt_dlseem

                cmp     eax, 1012
                jz      bt_ulseem

                cmp     eax, 1016
                jz      bt_attr

                cmp     eax, 1020
                jz      bt_autoupd

                cmp     eax, 1021
                jz      bt_rings

                cmp     eax, 1022
                jz      bt_debug1

                jmp    dlg_exit

bt_List:
                cmp     DevFound, 1
                jnz     no_dev
                push    [ebp+arg_0]
                call    ListP2K

                jmp    dlg_exit

bt_suspend:
                cmp     DevFound, 1
                jnz     no_dev
                call   P2K_Suspend
; Into flash mode:

;                push    offset Cmd_Recv_Size
;                push    offset Cmd_Recv_Buf
;                push    0 ; in data size - name len+8
;                push    offset Cmd_Send_Buf
;                push    00Dh                   ; FLASH
;                call    P2K_SendCommand

                jmp    dlg_exit

bt_restart:
                cmp     DevFound, 1
                jnz     no_dev
                call   P2K_Restart
                jmp    dlg_exit


bt_upload:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   Upload
                jmp    dlg_exit

bt_about:
                push   0
                push   offset str_about_title
                push   offset str_about
                push   [ebp+arg_0]
                call   MessageBoxA
                jmp    dlg_exit

bt_download:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   Download
                jmp    dlg_exit


bt_delete:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   Delete
                jmp    dlg_exit

bt_dlseem:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   Read_Seem
                jmp    dlg_exit

bt_ulseem:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   Write_Seem
                jmp    dlg_exit

bt_attr:
                cmp     DevFound, 1
                jnz     no_dev
                push   [ebp+arg_0]
                call   ChangeAttrib
                jmp    dlg_exit
no_dev:
                push   offset str_nodev
                call   logstat
                jmp    dlg_exit


bt_autoupd:
                xor    eax, eax
                cmp    AutoUpd, 1
                setnz  al
                mov    AutoUpd, eax
                jmp    dlg_exit

bt_rings:
                cmp     DevFound, 1
                jnz     no_dev
                call   RingTonesUpdate
                jmp    dlg_exit

bt_debug1:
                push    edi
                mov     edi, offset packet_buf
                mov     byte ptr [edi+0], 40h
                mov     byte ptr [edi+1], 01h
                mov     word ptr [edi+2], 00h
                mov     word ptr [edi+4], 06h
                mov     word ptr [edi+6], 00h
                mov     word ptr [edi+8], 00h
                mov     packet_size, 9
                push    offset packet_size
                push    offset packet_buf
                call    USB_WriteData
                pop     edi
                jmp    dlg_exit


;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------


Dlg_Init:
                push    esi
                push    edi
                push    edx
                push    ecx
                mov     eax, [ebp+arg_0]
                mov     Tray_Wnd_Handle, eax

                push    101
                push    Our_Handle
                call    LoadIconA
                mov     Tray_IconHandle, eax

                push    eax
                push    1
                push    80h ; WM_SETICON
                push    [ebp+arg_0]
                call    SendMessageA

; Create List Header(Columns)
                mov     lv_Col_Mask, 0Fh
                mov     esi, offset Tbl_Cols
@@col_loop:
                mov     ecx, [esi+4]
                mov     edx, [esi]
                mov     lv_Col_Size, ecx
                mov     lv_Col_Text, edx
                lea     eax, lv_Col_Mask
                push    eax
                push    edi
                push    101Bh           ; insert_col
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                add     esi, 0Ch
                inc     edi
                cmp     esi, offset col_list_end
                jl      short @@col_loop

; Set Tbl sttyle
                push    21h
                push    21h             ; fullrowselect
                push    1036h           ; set extended style
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
; create imagelist

                push    0
                push    3
                push    0FEh
                push    10h
                push    10h
                call    ImageList_Create

                push    0Fh
                mov     esi, eax
                call    GetSysColor

                push    eax
                push    esi
                call    ImageList_SetBkColor

                push    1000h
                push    10h
                push    10h
                push    1
                push    202
                push    Our_Handle
                call    LoadImageA

                push    eax
                push    0FFFFFFFFh
                push    esi
                call    ImageList_ReplaceIcon

                push    1000h
                push    10h
                push    10h
                push    1
                push    203
                push    Our_Handle
                call    LoadImageA

                push    eax
                push    0FFFFFFFFh
                push    esi
                call    ImageList_ReplaceIcon

                push    1000h
                push    10h
                push    10h
                push    1
                push    204
                push    Our_Handle
                call    LoadImageA

                push    eax
                push    0FFFFFFFFh
                push    esi
                call    ImageList_ReplaceIcon

                push    esi
                push    1
                push    1003h           ; SetImageList
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    0FFFFFFh
                push    esi
                call    ImageList_SetBkColor

                push    0
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1009
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    300h
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1010
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    offset Thread_ID
                push    0
                push    0
                push    offset DevMonitor_Proc
                push    0
                push    0
                call    CreateThread
                mov     Thread_Handle, eax

                push    offset ini_file
                push    0
                push    offset ini_AutoFileList
                push    offset ini_general
                call    GetPrivateProfileIntA
                mov     AutoUpd, eax

                push    0
                push    AutoUpd
                push    0F1h ; BM_SetCheck
                push    1020
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    1019
                push    [ebp+arg_0]
                push    offset str_not_conn
                push    50000000h ; style
                call    CreateStatusWindowA


                push    offset status_parts
                push    4
                push    404h ; SB_SETPARTS
                push    1019
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                pop     ecx
                pop     edx
                pop     edi
                pop     esi
                mov     eax, 1
                leave
                retn    10h


Dev_Notify:
                mov     eax, [ebp+arg_8]
                cmp     eax, 1
                jz      Dev_conn
                cmp     eax, 0
                jnz     dev_done
                push    offset str_not_conn
                push    0
                push    401h
                push    1019
                push    Dlg_hwnd
                call    SendDlgItemMessageA
                jmp     dev_done
Dev_Conn:
                push    offset str_conn
                push    0
                push    401h
                push    1019
                push    Dlg_hwnd
                call    SendDlgItemMessageA

                push    [ebp+arg_0]
                call    GetPhoneInfo

                cmp     AutoUpd, 1
                jnz     dev_done
                push    [ebp+arg_0]
                call    ListP2K
dev_done:
                mov     eax, 1
                leave
                retn    10h


;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------
;-----------------------------------


WM_NOTIFY:      ; Proceed mouse or kbd events on window
                mov    eax, [ebp+arg_C]
                cmp    dword ptr [eax+4], 1008
                jz     @@notify_LV
                cmp    dword ptr [eax+4], 1004
                jz     @@notify_TV
                jmp    dlg_exit

@@notify_TV:
                cmp    Use_Path, 1
                jnz    dlg_exit
                mov    eax,[eax+8]
                cmp    eax, -192h
                jz     @@tv_select
                jmp    dlg_exit

@@tv_select:
                push   [ebp+arg_0]
                call   Tree_Select
                jmp    dlg_exit

;---------------------------------
@@notify_LV:
                mov    eax,[eax+8]
                cmp    eax, -5
                je     @@lv_rclick
                cmp     eax, -6Ch ; LVN_COLUMNCLICK
                je     @@lvn_columnclick      ; default
                jmp    dlg_exit

@@lv_rclick:
                                       ; Find selected item
                push    2               ; flags - search for selected item
                push    -1              ; start from beginning
                push    100Ch           ; LVM_GETNEXTITEM
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     lv_Item, 0
                mov     lv_SubItem, 0
                mov     lv_Text, offset lv_get_text
                mov     lv_TextMax, 105h

                push    offset lv_Mask
                push    eax
                push    102Dh           ; LVM_GETITEMTEXT
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    offset Cursor_X
                call    GetCursorPos
                xor     ecx, ecx
                push    ecx
                push    ds:Menu_Handle
                call    GetSubMenu

                push    eax
                push    [ebp+arg_0]
                call    SetForegroundWindow
                pop     eax
                push    0
                push    [ebp+arg_0]
                push    0
                push    Cursor_Y
                push    Cursor_X
                push    2
                push    eax
                call    TrackPopupMenu
                push    0
                push    0
                push    0
                push    [ebp+arg_0]
                call    PostMessageA
                jmp    dlg_exit


@@lvn_columnclick:
                mov     esi, [ebp+arg_C]
                mov     eax, LV_Sort_id
                mov     ecx, [esi+10h]
                cmp     ecx, eax
                jnz     short @@skip_?
                mov     cl, LV_Sort_dir
                test    cl, cl
                setz    LV_Sort_dir
@@skip_?:

                mov     lv_Col_mask, 1
                mov     lv_col_fmt, 0
                push    offset lv_Col_Mask
                push    eax
                push    101Ah           ; LVM_SETCOLUMN
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     cl, LV_Sort_dir
                and     ecx, 0FFh
                mov     lv_col_extra, ecx
                mov     lv_col_mask, 11h
                mov     lv_col_fmt, 1800h ; image, on_right

                push    offset lv_Col_Mask
                mov     edx, [esi+10h]
                push    edx
                push    101Ah           ; LVM_SETCOLUMN
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     eax, [esi+10h]
                mov     LV_Sort_id, eax

                push    offset LV_Sort_Proc
                push    eax
                push    1030h
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                jmp    dlg_exit
;------------------------------------
Dlg_close:
                push    0
                push    [ebp+arg_0]
                call    EndDialog
                mov     eax, 1
                leave
                retn    10h


Dlg_Proc  endp


DevMonitor_Proc proc near
@@init_fail:
                push    3E8h
                call    Sleep
                call    COM_Find
                cmp     eax, 0
                jnz     @@no_comm
                call    Switch_mode
                push    1388h
                call    Sleep
@@no_comm:
                call    FindUSBClass
                cmp     _DevIF, 0
                jz      @@init_fail
                mov     DevFound, 1

                push    0
                push    1
                push    402h
                push    Dlg_hwnd
                call    SendMessageA

                mov     eax, Dev_Name_Ptr
                add     eax, 4
                push    eax
                push    offset str_devclass_key
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch
                mov     byte ptr [str_buf+56h], '#'
                mov     byte ptr [str_buf+57h], '#'
                mov     byte ptr [str_buf+59h], '#'

                push    offset Key_Class_handle  ; handle
                push    20019h         ; access mask
                push    0              ; res
                push    offset str_buf ; subkey
                push    80000002h      ; key
                call    RegOpenKeyExA

                push    0 ; async flag
                push    0; Key_Event
                push    5 ;notify filter - name+last_set
                push    1 ; flag subkey notify
                push    Key_Class_handle
                call    RegNotifyChangeKeyValue

                push    Key_Class_handle
                call    RegCloseKey

                push    _DevIF
                call    CloseHandle

                push    Dev_Name_Ptr
                call    GlobalFree

                mov     DevFound, 0
                mov     _DevIF, 0

                push    0
                push    0
                push    402h
                push    Dlg_hwnd
                call    SendMessageA

                push    1388h
                call    Sleep
                jmp     @@init_fail
DevMonitor_Proc endp



; Add new line to ListBox with args:
; arg_0  - hwnd
; arg_4  - file entry offset

AddRow          proc near
arg_0           = dword ptr  08h
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                pusha

                mov     lv_Mask, 7
                mov     lv_Item, 0
                mov     lv_SubItem, 0
                mov     lv_State, 0
                mov     lv_StateMask, 0
                mov     lv_TextMax, 0
                mov     lv_Image, 2

                mov     eax, [ebp+arg_4]
                push    esi
                push    ecx
                xor     esi, esi
@@loop:
                mov     cl, [eax+esi]
                mov     [str_buf+esi],cl
                inc     esi
                mov     ecx, FileList_RecSize
                sub     ecx, 8
                cmp     esi, ecx
                jb      @@loop
                mov     byte ptr [str_buf+ecx], 0
                pop     ecx
                pop     esi

                mov     eax, offset str_buf
                mov     lv_Text, eax

                mov     eax, [ebp+arg_4]
                mov     lv_LParam, eax

                push    offset lv_Mask
                push    0
                push    1007h         ; InsertItem
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     lv_Item, eax


                mov     esi, [ebp+arg_4]
                mov     ebx, FileList_RecSize
                mov     eax, [esi+ebx-8]
                push    eax
                push    offset str_hex
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                mov     lv_SubItem,1
                push    offset lv_Mask
                mov     eax, offset str_buf
                mov     lv_Text, eax
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     esi, [ebp+arg_4]
                mov     ebx, FileList_RecSize
                mov     eax, [esi+ebx-4]
                push    eax
                push    offset str_dec
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                mov     eax,offset str_buf
                mov     lv_Text,eax
                mov     lv_SubItem,2
                push    offset lv_Mask
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    [ebp+arg_4]
                call    GetFile_ext
                mov     lv_Text, eax

                mov     lv_SubItem,3
                push    offset lv_Mask
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                popa
                leave
                retn 8
AddRow          endp

LV_Sort_Proc    proc near
arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h

                push    ebp
                mov     ebp, esp
                push    ecx
                push    edx
                mov     eax, [ebp+arg_8]
                cmp     eax, 1
                je      @@attr
                cmp     eax, 2
                je      @@size
                cmp     eax, 3
                je      @@type
                mov     ecx, [ebp+arg_0]
                mov     edx, [ebp+arg_4]
@@next_name:
                mov     al, [ecx]
                cmp     al, [edx]
                ja      @@name_a
                jb      @@name_b
                inc     ecx
                inc     edx
                cmp     al, 0
                jz      @@exit
                mov     eax, [ebp+arg_0]
                add     eax, FileList_RecSize
                sub     eax, 8
                cmp     ecx, eax
                jnz     @@next_name
@@name_b:
                mov     eax,  0
                jmp     @@exit
@@name_a:
                mov     eax,  1
                jmp     @@exit

@@attr:
                mov     eax, [ebp+arg_0]
                mov     edx, FileList_RecSize

                mov     ecx, [eax+edx-8]
                mov     eax, [ebp+arg_4]
                mov     edx, [eax+edx-8]
                xor     eax, eax
                cmp     ecx, edx
                setnb   al
                jmp     @@exit

@@size:
                mov     eax, [ebp+arg_0]
                mov     edx, FileList_RecSize
                mov     ecx, [eax+edx-4]

                mov     eax, [ebp+arg_4]
                mov     edx, [eax+edx-4]
                xor     eax, eax
                cmp     ecx, edx
                setnb   al

                jmp     @@exit
@@type:
                push    [ebp+arg_0]
                call    GetFile_ext
                mov     ecx, eax
                push    [ebp+arg_4]
                call    GetFile_ext
                mov     edx, eax
@@next_type:
                mov     al, [ecx]
                cmp     al, [edx]
                ja      @@type_a
                jb      @@type_b
                inc     ecx
                inc     edx
                cmp     al, 0
                jz      @@exit
                mov     eax, [ebp+arg_0]
                add     eax, FileList_RecSize
                sub     eax, 8
                cmp     ecx, eax
                jnz     @@next_type
@@type_b:
                mov     eax,  0
                jmp     @@exit
@@type_a:
                mov     eax,  1
                jmp     @@exit

@@exit:
                xor     al, LV_Sort_dir
                pop     edx
                pop     ecx
                leave
                retn 0Ch
LV_Sort_Proc    endp



; write str to log window
; arg_0 - hwnd
; arg_4 - str

LogStat         proc near
arg_0           = dword ptr  8
                push    ebp
                mov     ebp, esp
                pusha
                cmp     stay_quiet,1
                jz      @@quiet
                push    [ebp+arg_0]
                push    0               ; reserved
                push    0C2h
                push    1000
                push    Dlg_hwnd
                call    SendDlgItemMessageA
@@quiet:
                popa
                leave
                retn 4
Logstat         endp

HexStr2Int      proc near
arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                push    esi
                push    ecx
                push    edx
                mov     ecx,8
                mov     edx,0
                mov     esi, [ebp+arg_0]
@@loop:
                lodsb
                cmp     al, 0
                jz      @@exit
                cmp     al, 30h
                jb      @@exit
                sub     al,30h
                cmp     al, 9
                jbe     @@num
                sub     al, 7
@@num:
                cmp     al, 10h
                jb      @@ok
                sub     al, 20h
@@ok:
                cmp     al, 0fh
                ja      @@exit

                shl     edx, 4
                or      dl, al
                loop    @@loop
@@exit:
                mov     eax, edx
                pop     edx
                pop     ecx
                pop     esi
                leave
                retn 4
HexStr2Int      endp


LEUnicode_cvt   proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                push    esi
                push    edi
                mov     esi, [ebp+arg_0]
                mov     edi, esi
@@loop:
                lodsw
                xchg    al, ah
                cmp     ax, 0FFFFh
                jz      @@done
                cmp     ax, 0FF00h
                jz      @@done
                cmp     ax, 00FFh
                jz      @@done
                cmp     ax, 0
                jz      @@done
                stosw
                jmp     @@loop
@@done:
                xor     eax, eax
                stosw
                pop     edi
                pop     esi
                leave
                retn 4
LEUnicode_cvt   endp

;####################################################
;
;  P2K IO Procedures
;
;####################################################


; Make Filelist of P2K phone

ListP2K         Proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                pusha

                push    0h
                push    0h
                push    1009h           ; Clear ListBox
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    offset str_Search_req
                call    LogStat

; query filelist from phone
                push    [ebp+arg_0]
                call    FSAC_GetFList
                cmp     eax, 0
                jnz     @@fail

                push    offset str_ok
                call    LogStat


                mov     ecx, Files_found
                mov     esi, SearchBuf_Ptr
@@add_loop:
                cmp     Use_Path, 1
                jz      @@path_app
                push    esi
                push    [ebp+arg_0]
                call    AddRow
                jmp     @@next_add
@@path_app:
                push    esi
                push    [ebp+arg_0]
                call    FileView_Append
@@next_add:
                add     esi, FileList_RecSize
                loop    @@add_loop

                push    Tree_root
                push    2               ; flag - expand
                push    1102h           ; Expand
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

; log result
                push    offset str_Files_Added
                call    LogStat

                push    Files_found; edx
                push    offset str_dec
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                call    LogStat

                push    offset crlf
                call    LogStat
                cmp     Use_path, 1
                jnz     @@exit

                push    Tree_Root
                push    9
                push    110Bh           ; SelectItem
                push    1004
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

@@exit:
                popa
                leave
                retn 4
@@fail:
                push    offset str_fail
                call    LogStat
                jmp     @@exit
ListP2K         endp

FileView_Append proc near
arg_0           = dword ptr  08h
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                pusha

                mov     ebx, FileList_RecSize
                sub     ebx, 8
                mov     ecx, 1
                mov     esi, [ebp+arg_4]
                mov     edi, Tree_Root
                mov     FileView_Slash1, 0
@@str_loop:
                mov     al,[esi+ecx] ; lodsb
                cmp     al, '/'
                jz      @@sl_found
                cmp     al, 0
                jz      @@eol
                inc     ecx
                cmp     ecx, ebx
                jb      @@str_loop
@@eol:
                jmp     @@done
@@sl_found:
                cmp     FileView_Slash1, 0
                jnz     @@not_first
                mov     FileView_Slash1, ecx
                inc     ecx
                jmp     @@str_loop
@@not_first:
                mov     FileView_Slash2, ecx
                push    edi
                mov     edi, offset str_buf
                mov     ecx, FileView_Slash1
                inc     ecx
@@folder_loop:
                mov     al, [esi+ecx]
                stosb
                inc     ecx
                cmp     ecx, FileView_Slash2
                jb      @@folder_loop
                mov     al, 0
                stosb
                pop     edi

                push    edi
                push    offset str_buf
                push    [ebp+arg_0]
                call    Find_Create_TreeItem
                mov     edi, eax

                mov     ecx, FileView_Slash2
                mov     FileView_Slash1, ecx
                inc     ecx
                jmp     @@str_loop
@@done:
                popa
                leave
                retn 8
FileView_Append endp

Find_Create_TreeItem proc near
arg_0           = dword ptr  08h
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h

                push    ebp
                mov     ebp, esp

                push    [ebp+arg_8]
                push    [ebp+arg_4]
                push    [ebp+arg_0]
                call    Find_TreeItem
                cmp     eax, 0
                jnz     @@found

                mov     eax, [ebp+arg_8]
                mov     tv_Parent, eax
                mov     tv_InsertAfter, -0FFFdh ;  TVI_SORT
                mov     tv_mask, 1 ; TEXT and TextMax
                mov     eax, [ebp+arg_4]
                mov     tv_Text, eax
                push    [ebp+arg_4]
                call    lstrlenA
                mov     tv_TextMax, eax

                push    offset tv_Parent
                push    0
                push    1100h           ; InsertItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
@@found:
                leave
                retn 0Ch
Find_Create_TreeItem endp

Find_TreeItem   proc near
arg_0           = dword ptr  08h
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h

                push    ebp
                mov     ebp, esp
                push    edi

                push    [ebp+arg_8]
                push    4               ; First_CHILD
                push    110Ah           ; GetNextItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     edi, eax
                cmp     eax, 0
                jz      @@fail
@@text_next:
                mov     tv_Mask, 1 ; get text
                mov     tv_Item, eax
                mov     tv_Text, offset str_Buf2
                mov     tv_TextMax, 180h

                push    offset tv_Mask
                push    0
                push    110Ch           ; GetItem
                push    1004
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    [ebp+arg_4]
                push    offset str_buf2
                call    lstrcmpA
                cmp     eax, 0
                jz      @@ok

                push    edi
                push    1               ; NextItem
                push    110Ah           ; GetNextItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     edi, eax
                cmp     eax, 0
                jnz     @@text_next
@@ok:
                mov     eax, edi
@@fail:
                pop     edi
                leave
                retn 0Ch
Find_TreeItem   endp

Tree_Select     proc    near
arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                push    ecx
                push    edx
                push    ebx
                push    esi
                push    edi

                push    0h
                push    0h
                push    1009h           ; Clear ListBox
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    0
                push    9               ; Selected
                push    110Ah           ; GetNextItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    eax
                push    [ebp+arg_0]
                call    GetKey_FullPath

                mov     Tree_FileLoop, 0

                mov     esi, SearchBuf_Ptr
                cmp     esi, 0
                jz      @@exit
                mov     ebx, FileList_RecSize
                sub     ebx, 8

@@cmd_loop_nextfile:
                mov     ecx, 0
@@cmp_loop1:
                mov     edi, offset str_buf
                mov     al, [edi+ecx]
                cmp     al, [esi+ecx]
                jnz     @@str_diff
                inc     ecx
                cmp     ecx, ebx
                jb      @@cmp_loop1
                jmp     @@next_file
@@str_diff:
                cmp     al, 0
                jnz     @@next_file
                mov     edi, ecx
@@str_check_loop:
                mov     al, [esi+ecx]
                cmp     al, '/'
                jz      @@next_file
                cmp     al, 0
                jz      @@strcpy_done
                inc     ecx
                cmp     ecx, ebx
                jb      @@str_check_loop
@@strcpy_done:
                mov     lv_Mask, 7
                mov     lv_Item, 0
                mov     lv_SubItem, 0
                mov     lv_State, 0
                mov     lv_StateMask, 0
                mov     lv_TextMax, 0
                mov     lv_Image, 2
                mov     ecx, 0

@@loop:
                mov     al, [esi+edi]
                mov     [str_buf2+ecx],al
                inc     edi
                inc     ecx
                cmp     edi, ebx
                jb      @@loop
                mov     byte ptr [str_buf2+ecx], 0

                mov     eax, offset str_buf2
                mov     lv_Text, eax
                mov     lv_LParam, esi

                push    offset lv_Mask
                push    0
                push    1007h         ; InsertItem
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     lv_Item, eax

                mov     ebx, FileList_RecSize
                mov     eax, [esi+ebx-8]
                push    eax
                push    offset str_hex
                push    offset str_buf2
                call    wsprintfA
                add     esp, 0Ch

                mov     lv_SubItem,1
                push    offset lv_Mask
                mov     eax, offset str_buf2
                mov     lv_Text, eax
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     ebx, FileList_RecSize
                mov     eax, [esi+ebx-4]
                push    eax
                push    offset str_dec
                push    offset str_buf2
                call    wsprintfA
                add     esp, 0Ch

                mov     eax,offset str_buf2
                mov     lv_Text,eax
                mov     lv_SubItem,2
                push    offset lv_Mask
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    esi
                call    GetFile_ext
                mov     lv_Text, eax

                mov     lv_SubItem,3
                push    offset lv_Mask
                push    0
                push    102Eh           ; set item text
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
@@next_file:
                add     esi, FileList_RecSize
                mov     edx, Tree_FileLoop
                inc     edx
                mov     Tree_FileLoop, edx
                cmp     edx, Files_Found
                jb      @@cmd_loop_nextfile
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                pop     edx
                pop     ecx
                leave
                retn 4
Tree_Select     endp

GetKey_FullPath proc near
arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                push    esi

                mov     byte ptr str_buf, 0
                mov     edi, [ebp+arg_4]
                cmp     edi, Tree_Root
                jz      @@is_root

@@name_loop:
                mov     tv_Mask, 1 ; get text
                mov     tv_Item, edi
                mov     tv_Text, offset str_Buf2
                mov     tv_TextMax, 180h

                push    offset tv_Mask
                push    0
                push    110Ch           ; GetItem
                push    1004
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    offset str_slash
                push    offset str_buf2
                call    lstrcatA

                push    offset str_buf
                push    offset str_buf2
                call    lstrcatA

                push    offset str_buf2
                push    offset str_buf
                call    lstrcpyA

                push    edi
                push    3               ; TVGN_PARENT
                push    110Ah           ; GetItem
                push    1004
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     edi, eax
                cmp     eax, 0
                jz      @@name_done
                cmp     eax, Tree_root
                jnz     @@name_loop
@@is_root:
                push    esi
                push    edi
                mov     esi, offset volname
                mov     edi, offset str_buf2
@@root_cpy:
                lodsw
                stosb
                cmp     al, 0
                jnz     @@root_cpy
                pop     edi
                pop     esi

                push    offset str_slash
                push    offset str_buf2
                call    lstrcatA

                push    offset str_buf
                push    offset str_buf2
                call    lstrcatA

                push    offset str_buf2
                push    offset str_buf
                call    lstrcpyA
@@name_done:
                pop     esi
                leave
                retn 8
GetKey_FullPath endp

GetFile_ext       proc near
arg_0             = dword ptr  8

                  push    ebp
                  mov     ebp, esp

                  push    ebx
                  push    edx
                  push    esi

                  mov     eax, 0
                  mov     edx, 0
                  mov     ebx, FileList_RecSize
                  sub     ebx, 8
                  mov     esi, [ebp+arg_0]
@@char_loop:
                  cmp     byte ptr [esi+eax], 0
                  jz      @@extdone
                  cmp     byte ptr [esi+eax], '.'
                  jnz     @@next_char
                  mov     edx, esi
                  add     edx, eax
                  inc     edx
@@next_char:
                  inc     eax
                  cmp     eax, ebx
                  jna     @@char_loop
@@extdone:
                  cmp     edx, 0
                  jnz     @@ok
                  mov     edx, offset str_null
@@ok:
                  mov     eax, edx

                  pop     esi
                  pop     edx
                  pop     ebx
                  leave
                  retn 4
GetFile_ext       endp

Get_List_FileSize proc near

arg_0           = dword ptr  8

                  push    ebp
                  mov     ebp, esp

                  mov     eax, [ebp+arg_0]
                  add     eax, FileList_RecSize
                  mov     eax, [eax-4]

                  leave
                  retn 4
Get_List_FileSize endp

Get_List_FileAttr proc near

arg_0           = dword ptr  8

                  push    ebp
                  mov     ebp, esp

                  mov     eax, [ebp+arg_0]
                  add     eax, FileList_RecSize
                  mov     eax, [eax-8]
                  and     eax, 00FFFFh

                  leave
                  retn 4
Get_List_FileAttr endp

RingTonesUpdate   proc near
                  push    ecx
                  push    esi
                  push    edi

;                  push    offset seem_data
;                  push    0
;                  push    0
;                  push    1
;                  push    4Ch
;                  call    Cmd_RDELEM


;                  push    offset str_profiles_readed
;                  call    logstat

;                  push    ecx
;                  push    1F4h
;                  call    Sleep
;                  pop     ecx

;                  mov     edi, offset seem_data
;                  mov     byte ptr [edi+01h], 2
;                  mov     byte ptr [edi+02h], 2
;                  mov     byte ptr [edi+0Ch], 2
;                  mov     byte ptr [edi+0Dh], 2
;                  mov     byte ptr [edi+17h], 2
;                  mov     byte ptr [edi+18h], 2
;                  mov     byte ptr [edi+22h], 2
;                  mov     byte ptr [edi+23h], 2
;                  mov     byte ptr [edi+2Dh], 2
;                  mov     byte ptr [edi+2Eh], 2

;                  push    ecx
;                  push    0
;                  push    1
;                  push    4Ch
;                  call    Cmd_STELEM

;                  push    1F4h
;                  call    Sleep

;                  push    offset str_profiles_updated
;                  call    logstat

;                  push    offset fn_mytonedb
;                  call    FSAC_delete

;                  push    offset str_tonebase_deleted
;                  call    logstat
;                  push    1F4h
;                  call    Sleep

;                  call   P2K_Restart
;
                  pop     edi
                  pop     esi
                  pop     ecx
                  retn
RingTonesUpdate   endp

;--------------------------------------
; Write file to Phone

Upload          proc    near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp,esp
                pusha

                push    offset str_upload
                call    logstat

                push    offset volname
                call    FSAC_volume_space
                cmp     eax, 0
                jz      @@volinfo_2_ok
                push    offset str_volinfofail
                call    logstat
                jmp     @@exit
@@volinfo_2_ok:
                mov     edi, offset fname_buf
                mov     eax, 0
                mov     ecx, 80h
                rep     stosd

                mov     fname_buf, 0
                mov     fname_t_buf, 0
                mov     OFN_Flags, 80200h
                push    offset OpenFileNameSize
                call    GetOpenFileNameA
                cmp     eax, 0
                jz      @@exit

                mov     esi, offset fname_buf

                push    offset fname_buf
                call    lstrlenA
                inc     eax
                cmp     byte ptr [eax+esi], 0
                jz      @@single_file
@@next_ul:
                add     esi, eax
@@single_file:
                push    -1
                push    0
                push    3 ; open existing
                push    0
                push    0
                push    0C0000000h ; generic RW
                push    esi
                call    CreateFileA
                mov     FHandle, eax
                cmp     eax,-1
                jnz     @@_open_ok
                push    offset str_openfail
                call    logstat
                jmp     @@exit
@@_open_ok:
                push    eax

                push    80h
                push    offset str_buf
                push    1017
                push    [ebp+arg_0]
                call    GetDlgItemTextA

                cmp     byte ptr [fname_t_buf], 0
                mov     eax, offset fname_t_buf
                jnz     @@single_file_t
                mov     eax, esi
@@single_file_t:
                cmp     Use_Path, 1
                jnz     @@no_Paths
                push    eax

                push    0
                push    9               ; Selected
                push    110Ah           ; GetNextItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    eax
                push    [ebp+arg_0]
                call    GetKey_FullPath

                pop     eax

                push    eax
                push    offset str_buf
                call    lstrcatA
                jmp     @@Path_done
@@no_Paths:
                push    eax
                push    offset str_buf
                call    lstrcpyA
@@Path_done:
                push    offset str_buf ; fname_t_buf
                call    logstat

                pop     eax

                push    offset filesize_ex
                push    eax
                call    GetFileSize

                cmp     filesize_ex, 0
                jnz     @@fail_size
                cmp     eax, 0
                jz      @@fail_size
                cmp     eax, VolSpace
                jb      @@_size_ok
@@fail_size:
                push    offset str_sizefail
                call    logstat
                jmp     @@try_next_ul

@@_size_ok:
                sub     VolSpace, eax
                mov     FileSize, eax
                push    eax
                push    40h
                call    GlobalAlloc
                cmp     eax, 0
                jz      @@exit_fclose
                mov     FileBuf_Ptr, eax

                push    0 ; overlapped
                push    offset file_readed ; bytes readen
                push    FileSize  ; bytes to read
                push    FileBuf_Ptr
                push    FHandle
                call    ReadFile
                cmp     eax, 0
                jz      @@exit_fclose
                mov     eax, FileSize
                cmp     file_readed, eax
                jnz     @@exit_fclose
                push    FHandle
                call    CloseHandle

; Begin write
                push    offset str_buf ; fname_t_buf
                call    lstrlenA
                mov     ecx, FileList_RecSize
                cmp     ecx, 0
                jz      @@warn_no_fl
                sub     ecx, 8
                cmp     eax, ecx
                ja      @@exit_fclose
@@warn_no_fl:
                push    0 ; attrib
                push    offset str_buf ; fname_t_buf             ; fname_ptr
                call    FSAC_open
                test    eax, eax
                jnz     short @@exit

                push    FileSize
                push    FileBuf_Ptr
                call    FSAC_write
                test    eax, eax
                jnz     short @@close ; fail
@@close:
                call    FSAC_close
;                test    eax, eax
;                jnz      @@exit   ; fail
                push    offset str_ok
                call    logstat
@@try_next_ul:
                push    esi
                call    lstrlenA
                inc     eax
                cmp     byte ptr [esi+eax], 0
                jnz     @@next_ul
@@upl_done:
                cmp     AutoUpd, 1
                jnz     @@skip_upd
                push    [ebp+arg_0]
                call    ListP2K
@@skip_upd:

@@exit_fclose:
                push    FHandle
                call    CloseHandle

@@exit:
                popa
                leave
                retn 4
Upload          endp

ChangeAttrib    proc near
arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                pusha

                mov     next_sel_item, -1
@@next:                              ; Find selected item
                                        ; Find selected item
                push    2               ; flags - search for selected item
                push    next_sel_item   ; start from beginning
                push    100Ch           ; LVM_GETNEXTITEM
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     eax, -1
                je      @@no_more_sel
                mov     next_sel_item, eax

                push    offset str_attr
                call    logstat

                mov     lv_Mask, 4
                mov     lv_Item, eax
                mov     lv_SubItem, 0
                mov     lv_LParam, 0
                push    offset lv_Mask
                push    0
                push    1005h           ; LVM_GETITEMTEXT
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     lv_LParam, 0
                jz      @@exit

                push    lv_LParam
                call    logstat

                push    0
                push    0
                push    1015
                push    [ebp+arg_0]
                call    GetDlgItemInt
                cmp     eax, 10000h
                jna     @@ok
                mov     eax, 0
@@ok:
                push    eax
                push    lv_LParam
                call    FSAC_Open
                test    eax, eax
                jnz     @@openfail

                push    offset str_ok
                call    logstat

                call    FSAC_Close
@@openfail:
                jmp     @@next
@@no_more_sel:
                cmp     next_sel_item, -1
                jnz     @@exit
                push    offset str_no_files_sel
                call    logstat
@@exit:
                cmp     AutoUpd, 1
                jnz     @@skip_upd
                push    [ebp+arg_0]
                call    ListP2K
@@skip_upd:

                popa
                leave
                retn    4
ChangeAttrib    endp

Download        proc

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                pusha

                mov     files_dl_first, 0
                mov     next_sel_item, -1
@@dl_next:                              ; Find selected item
                push    2               ; flags - search for selected item
                push    next_sel_item   ; start from beginning
                push    100Ch           ; LVM_GETNEXTITEM
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     eax, -1
                je      @@no_more_sel
                mov     next_sel_item, eax

                push    offset str_download
                call    logstat

                mov     lv_Mask, 4
                mov     lv_Item, eax
                mov     lv_SubItem, 0
                mov     lv_LParam, 0
                push    offset lv_Mask
                push    0
                push    1005h           ; LVM_GETITEMTEXT
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     lv_LParam, 0
                jz      @@sizefail

                push    lv_LParam
                call    logstat

                push    lv_LParam
                call    Get_List_FileSize

                cmp     eax, -1
                jz      @@sizefail
                cmp     eax, 0
                jnz     @@size_ok
@@sizefail:
                push    offset str_sizefail
                call    logstat
                push    Download_BufPtr
                call    GlobalFree
                jmp     @@exit

@@size_ok:
                mov     Download_FSize, eax

                push    eax
                push    40h
                call    GlobalAlloc
                cmp     eax, 0
                jnz     @@mem_ok
                push    offset str_memfail
                call    logstat
                jmp     @@exit

@@mem_ok:
                mov     Download_BufPtr, eax
                push    lv_LParam
                call    Get_List_FileAttr
                push    eax
                push    lv_LParam
                call    FSAC_Open
                test    eax, eax
                jz      @@open_ok
                push    offset str_openfail
                call    logstat
                push    Download_BufPtr
                call    GlobalFree
                mov     eax, -1
                jmp     @@exit

@@open_ok:
                push    20h
                call    Sleep
                push    0
                push    0
                call    FSAC_Seek
                test    eax, eax
                jz      @@seek_ok
                push    offset str_seekfail
                call    logstat
                call    FSAC_Close
                push    Download_BufPtr
                call    GlobalFree
                mov     eax, -1
                jmp     @@exit

@@seek_ok:
                push    20h
                call    Sleep

                push    Download_FSize
                push    Download_BufPtr
                call    FSAC_Read
                cmp     eax, 0
                jz      @@read_ok
                push    offset str_readfail
                call    logstat
                call    FSAC_Close
                push    Download_BufPtr
                call    GlobalFree
                mov     eax, -1
                jmp     @@exit
@@read_ok:

                push    20h
                call    Sleep
                call    FSAC_Close
;                cmp     eax, 0
;                jz      @@close

                push    10Dh
                push    offset fname_buf
                push    lv_LParam
                call    GetFileTitleA

                cmp     files_dl_first, 0
                jnz     @@skip_path
                mov     fname_t_buf, 0
                push    offset OpenFileNameSize
                mov     OFN_Flags, 0
                call    GetSaveFileNameA
                cmp     eax, 0
                jnz     @@path_ok
                push    offset str_canceled
                call    logstat
                push    Download_BufPtr
                call    GlobalFree
                jmp     @@exit

@@path_ok:
                mov     files_dl_first, 1
@@skip_path:
                push    -1
                push    0
                push    1 ; Create new
                push    0
                push    0
                push    0C0000000h ; generic RW
                push    offset fname_buf
                call    CreateFileA
                mov     FHandle, eax
                cmp     eax,0
                jnz     @@create_ok
                push    offset str_fcreatefail
                call    logstat
                push    Download_BufPtr
                call    GlobalFree

@@create_ok:
                push    0
                push    offset file_readed
                push    Download_FSize
                push    Download_BufPtr
                push    FHandle
                call    WriteFile
                cmp     eax, 0
                jnz     @@write_ok
                push    offset str_Writefile_fail
                call    logstat
                push    FHandle
                call    CloseHandle
                call    FSAC_Close
                push    Download_BufPtr
                call    GlobalFree
                jmp     @@exit

@@write_ok:
                push    FHandle
                call    CloseHandle

                push    Download_BufPtr
                call    GlobalFree

                push    offset str_ok
                call    logstat
                jmp     @@dl_next
@@no_more_sel:
                cmp     next_sel_item, -1
                jnz     @@exit
                push    offset str_no_files_sel
                call    logstat
@@exit:
                popa
                leave
                retn    4
Download        endp


Delete          Proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                pusha

                mov     next_sel_item, -1
@@next:                              ; Find selected item
                                        ; Find selected item
                push    2               ; flags - search for selected item
                push    next_sel_item   ; start from beginning
                push    100Ch           ; LVM_GETNEXTITEM
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     eax, -1
                je      @@no_more_sel
                mov     next_sel_item, eax

                push    offset str_deleting
                call    logstat

                mov     lv_Mask, 4
                mov     lv_Item, eax
                mov     lv_SubItem, 0
                mov     lv_LParam, 0
                push    offset lv_Mask
                push    0
                push    1005h           ; LVM_GETITEMTEXT
                push    3F0h
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                cmp     lv_LParam, 0
                jz      @@exit

                push    lv_LParam
                call    logstat

                push    lv_LParam
                push    offset str_delete
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    4
                push    0
                push    offset str_buf
                push    [ebp+arg_0]
                call    MessageBoxA
                cmp     eax,6
                jnz     @@cancle

                push    lv_LParam
                call    FSAC_delete
                cmp     eax, 0
                jnz     @@fail
                push    offset str_ok
                call    logstat
                jmp     @@next
@@no_more_sel:
                cmp     next_sel_item, -1
                jnz     @@exit_ok
                push    offset str_no_files_sel
                call    logstat
@@exit_ok:

                cmp     AutoUpd, 1
                jnz     @@skip_upd
                push    [ebp+arg_0]
                call    ListP2K
@@skip_upd:
@@exit:
                popa
                leave
                retn    4
@@cancle:
                push    offset str_canceled
                call    logstat
                jmp     @@exit
@@fail:
                push    offset str_fail
                call    logstat
                jmp     @@exit

Delete          endp

GetPhoneInfo    Proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                pusha

                push    offset volname
                call    FSAC_GetVolName
                test    eax, eax
                jz      @@name_ok
                push    offset str_volname_fail
                call    logstat
                jmp     @@exit
@@name_ok:

                push    offset volname
                call    LEUnicode_cvt
                mov     esi, offset volname
@@path_loop:
                lodsw
                cmp     al, '/'
                jz      @@paths
                cmp     al, 0
                jnz     @@path_loop
                mov     Use_Path, 0
                jmp     @@path_done
@@paths:
                mov     Use_Path, 1
@@path_done:
                push    offset phone_model
                push    0
                push    0
                push    1
                push    117h
                call    Cmd_RDELEM
                cmp     eax, 0
                jnz     @@exit

                push    offset phone_model
                call    LEUnicode_cvt

                push    offset volname
                push    offset phone_model
                push    offset str_root_ctl
                push    offset str_buf
                call    wsprintfA
                add     esp, 10h
                mov     eax, -10000h ; TVI_ROOT
                mov     tv_Parent, eax
                mov     tv_InsertAfter, -0FFFdh ;  TVI_SORT
                mov     tv_mask, 1 ; TEXT and TextMax
                mov     tv_Text, offset str_buf
                push    offset str_buf
                call    lstrlenA
                mov     tv_TextMax, eax

                push    Tree_Root
                push    0h
                push    1101h           ; Clear Tree
                push    1004
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    offset tv_Parent
                push    0
                push    1100h           ; InsertItem
                push    3ECh
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
                mov     Tree_root, eax

                push    offset phone_model
                push    offset str_model_ctl
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    0001h
                push    401h
                push    1019
                push    Dlg_hwnd
                call    SendDlgItemMessageA

                push    offset volname
                call    FSAC_volume_space
                test    eax, eax
                jz      @@size_ok
                push    offset str_volsize_fail
                call    logstat
                jmp     @@exit
@@size_ok:
                mov     eax, VolSpace
                xor     edx, edx
                mov     ecx, 400h
                div     ecx

                push    eax
                push    offset volname
                push    offset str_volume_ctl
                push    offset str_buf
                call    wsprintfA
                add     esp, 10h

                push    offset str_buf
                push    0002h
                push    401h
                push    1019
                push    Dlg_hwnd
                call    SendDlgItemMessageA
@@exit:
                popa
                leave
                retn    4
GetPhoneInfo    endp



; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;             FSAC IO Section - partially unparsed
;
; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

P2K_Suspend       proc near
                  mov     byte ptr Cmd_Send_Buf, 0
                  push    offset Cmd_Recv_Size
                  push    offset Cmd_Recv_Buf
                  push    1
                  push    offset Cmd_Send_Buf
                  push    0036h                   ; SUSPEND
                  call    P2K_SendCommand
                  retn
P2K_Suspend       endp

P2K_Restart       proc near
                  push    offset Cmd_Recv_Size
                  push    offset Cmd_Recv_Buf
                  push    0
                  push    offset Cmd_Send_Buf
                  push    0022h                  ; RESTART
                  call    P2K_SendCommand
                  retn
P2K_Restart       endp


;===================FSAC IO======================
;+--------------------------------+
;  Open File in P2K phone - cmd 0

FSAC_open       proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp

                push    esi
                push    ebx
                push    ecx

                mov     edi, offset Cmd_Send_Buf
                mov     Cmd_Recv_Size, 0

                mov     eax, [ebp+arg_4]
                xchg    ah, al
                rol     eax, 10h
                xchg    ah, al
                mov     dword ptr [edi+04h], eax
                mov     dword ptr [edi+00h], 0 ; Cmd 0 - Open

                push    [ebp+arg_0]
                call    lstrlenA
                cmp     eax, 0
                jz      @@fail
                mov     ecx, FileList_RecSize
                sub     ecx, 8
                cmp     eax, ecx
                ja      @@fail
                push    edi

                add     edi, 8
                mov     esi, [ebp+arg_0] ; fname
                xor     edx, edx
@@name_cpy_loop:
                mov     cl, [esi+edx]
                mov     [edi+edx], cl
                inc     edx
                cmp     edx, eax
                jl      short @@name_cpy_loop
                pop     edi

                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                add     eax, 8
                push    eax ; in data size - name len+8
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     Cmd_Recv_Size, 1
                jnz     short @@exit
                cmp     byte ptr Cmd_Recv_Buf, 0
                jnz     short @@exit
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     ecx
                pop     ebx
                pop     esi
                leave
                retn    8
FSAC_open       endp

;+----------------------------------+
;  Read File from P2K phone - cmd 1

FSAC_read       proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp

                push    ecx
                push    ebx
                push    esi
                push    edi

                mov     edi, [ebp+arg_4] ; size
                cmp     edi, 0
                jz      @@fail

@@loop:
                cmp     edi, 400h
                jbe     @@b_400h
                mov     eax, 400h
                jmp     @@store_size
@@b_400h:
                mov     eax, edi
@@store_size:
                xchg    ah, al
                rol     eax, 10h
                xchg    ah,al

                mov     dword ptr Cmd_Send_Buf, 01000000h
                mov     dword ptr Cmd_Send_Buf+04h, eax

                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    8
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand

                cmp     eax, 0
                jnz     @@fail

                mov     ecx, Cmd_Recv_Size
                test    cx, cx
                jbe     short @@fail

                xor     esi, esi
                mov     eax, [ebp+arg_0]
                add     eax, [ebp+arg_4]
                sub     eax, edi
@@buf_loop:
                mov     cl, byte ptr [Cmd_Recv_Buf+esi]
                mov     [esi+eax], cl

                mov     ecx, Cmd_Recv_Size
                inc     esi
                and     ecx, 0FFFFh
                cmp     esi, ecx
                jl      short @@buf_loop

                cmp     edi, 400h
                jbe     @@exit_ok
                sub     edi, 400h
                jmp     @@loop
@@exit_ok:
                mov     esi, 0
                jmp     @@exit
@@fail:
                mov     esi, -1
@@exit:
                mov     eax, esi 
                pop     edi
                pop     esi
                pop     ebx
                pop     ecx
                leave
                retn    8
FSAC_read       endp

;+-----------------------------+
;  Write file to Phone - cmd 2

FSAC_write      proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                push    edx
                push    ebx
                push    esi
                push    edi
                xor     esi, esi
                mov     dword ptr Cmd_Send_Buf+0, 02000000h ; Cmd
                mov     Cmd_Recv_Size, 0
                mov     byte ptr Cmd_Recv_Buf, 0

                mov     ebx, [ebp+arg_4] ; Size

@@loop1:
                xor     eax, eax
                mov     edi, [ebp+arg_0]

                cmp     ebx, 0
                jz      @@block_wr_ok
                cmp     ebx, 400h ; mstapi uses this buf size...
                jb      short @@last_block

                mov     edx, 400h
                jmp     @@loop_datacopy
@@last_block:
                mov     edx, ebx
@@loop_datacopy:
                push    edx
                xchg    dh, dl
                rol     edx, 10h
                xchg    dh, dl
                mov     dword ptr Cmd_Send_Buf+4, edx
                pop     edx

                mov     cl, [edi+esi]
                mov     byte ptr [Cmd_Send_Buf+8+eax], cl
                inc     eax
                inc     esi
                cmp     eax, edx
                jl      short @@loop_datacopy
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                add     edx, 8
                push    edx
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@block_wr_fail
                cmp     word ptr Cmd_Recv_Size, 1
                jnz     short @@block_wr_ok
                cmp     byte ptr Cmd_Recv_Buf, 6
                jnz     short @@block_wr_fail
@@block_wr_ok:
                mov     eax, 0
                sub     edx, 8
                sub     ebx, edx
                jz      @@exit
                jmp     short @@loop1

@@block_wr_fail:
                mov     eax, -1
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                pop     edx
                leave
                retn    8
FSAC_write      endp

;+----------------------------+
;  Seek file in Phone - cmd 3

FSAC_seek       proc near

arg_0           = dword ptr  8
arg_4           = byte ptr  0Ch

                push    ebp
                mov     ebp, esp

                mov     dword ptr Cmd_Send_Buf, 03000000h ; Cmd

                mov     eax, [ebp+arg_0]
                xchg    ah, al
                rol     eax, 10h
                xchg    ah, al
                mov     dword ptr Cmd_Send_Buf+4, eax
                mov     al, [ebp+arg_4]
                mov     byte ptr Cmd_Send_Buf+8, al
                mov     Cmd_Recv_Size, 0
                mov     byte ptr Cmd_Recv_Buf, 0
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    9
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     word ptr Cmd_Recv_Size, 1
                jz      @@fail
                cmp     byte ptr Cmd_Recv_Buf, 1
                jz      @@fail
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                leave
                retn    8
FSAC_seek       endp

;+---------------------------------+
;  Close file in P2K Phone - cmd 4

FSAC_close      proc near
                mov     Cmd_Recv_Size, 0
                mov     byte ptr Cmd_Recv_Buf, 0
                mov     dword ptr Cmd_Send_Buf, 04000000h ; Cmd
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    4
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     word ptr Cmd_Recv_Size, 1
                jz      @@fail
                cmp     byte ptr Cmd_Recv_Buf, 1
                jz      @@fail
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                retn
FSAC_close      endp

;+--------------------------------+
;  Delete file from phone - cmd 5

FSAC_delete     proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp

                push    esi
                push    edx
                push    ecx

                mov     Cmd_Recv_Size, 0
                mov     byte ptr Cmd_Recv_Buf, 0
                mov     dword ptr Cmd_Send_Buf, 05000000h ; Cmd
                mov     esi, [ebp+arg_0]
                push    esi
                call    lstrlenA
                xor     edx, edx
                cmp     eax, 0
                jz      @@fail
                mov     ecx, FileList_RecSize
                sub     ecx, 8
                cmp     eax, ecx
                ja      @@exit

@@name_cpy_loop:
                mov     cl, [esi+edx]
                mov     byte ptr [Cmd_Send_Buf+4+edx], cl
                inc     edx
                cmp     edx, eax
                jl      short @@name_cpy_loop
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                add     eax, 4
                push    eax
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     Cmd_Recv_Size, 1
                jz      @@fail
                cmp     Cmd_Recv_Buf, 1
                jz      @@fail
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     ecx
                pop     edx
                pop     esi

                leave
                retn    4
FSAC_delete     endp

; ----------------------------------------------------
; Clear - what? :) PST don't use this function - cmd 6

FSAC_clear      proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp

                mov     al, byte ptr [ebp+arg_0]
                mov     byte ptr Cmd_Send_buf+4, al

                mov     Cmd_Recv_Size, 0
                mov     byte ptr Cmd_Recv_Buf, 0
                mov     dword ptr Cmd_Send_Buf, 06000000h ; Cmd

                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    5
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     Cmd_Recv_Size, 1
                jz      @@fail
                cmp     Cmd_Recv_Buf, 1
                jz      @@fail
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                leave
                retn    4
FSAC_clear      endp


;+-------------------------+
;  Get File list - cmd 7,8

FSAC_GetFList   proc near
                push    ebp
                mov     ebp, esp
                push    ecx
                push    edx
                push    ebx
                push    esi
                push    edi
; Request files count
                mov     word ptr Cmd_Recv_Buf, -1
                mov     dword ptr Cmd_Send_Buf, 07000000h ; Cmd
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    4
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     word ptr Cmd_Recv_Size, 2
                jb      @@fail
                cmp     word ptr Cmd_Recv_Buf, 0
                jbe     @@err_files_num                  ; nothing to search
                cmp     word ptr Cmd_Recv_Buf, -1
                jnz     @@files_num_ok
@@err_files_num:
                push    offset str_filesnum
                call    logstat
                jmp     @@fail

@@files_num_ok:
; Motorola Little-Endian convert...
                mov     ax, word ptr Cmd_Recv_Buf
                xchg    ah, al
                mov     Files_found, eax
                mov     esi, eax

; Alloc mem for buffer
                mov     ecx, 10Ch ; - entry size+enties count...
                mul     ecx
                push    eax
                push    40h
                call    GlobalAlloc
                cmp     eax, 0
                jnz     @@malloc_ok

                push    offset str_malloc_fail
                call    logstat
                jmp     @@fail
@@malloc_ok:
                mov     SearchBuf_Ptr, eax
                mov     edi, eax
; progress
                mov     eax, Files_found
                rol     eax, 10h
                push    eax
                push    0
                push    401h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    0
                push    0
                push    402h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA
@@loop:
; request block of records
                mov     word ptr Cmd_Recv_Buf, -1
                mov     dword ptr Cmd_Send_Buf, 08000000h ; Cmd
                push    offset Cmd_Recv_Size
                push    offset Search_Buf
                push    4
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand

                cmp     eax, 0
                jnz     @@fail

                mov     eax, Cmd_Recv_Size
                sub     eax, 4
                cdq
                mov     ecx, 2Ch
                mov     FileList_RecSize, ecx
                idiv    ecx
                cmp     edx, 0
                jz      @@rec_ok

                mov     eax, Cmd_Recv_Size
                sub     eax, 4
                cdq
                mov     ecx, 10Ch
                mov     FileList_RecSize, ecx
                idiv    ecx
                cmp     edx, 0
                jz      @@rec_ok
                mov     edx, 0
                mov     FileList_RecSize, edx
                push    offset msg_fl_rec_size_fail
                call    logstat
                jmp     @@fail

@@rec_ok:
                movzx   eax, word ptr [Search_Buf] ; records readed
                xchg    ah, al
                sub     esi, eax

; progress
                mov     eax, Files_found
                sub     eax, esi
                push    0
                push    eax
                push    402h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    esi
                mov     ecx, Cmd_Recv_Size
                sub     ecx, 4
                mov     esi, offset Search_Buf
                add     esi, 4
                rep movsb
                pop     esi

                cmp     esi, 0
                ja      @@loop

                mov     ecx, Files_found
                mov     esi, SearchBuf_Ptr
                mov     ebx, FileList_RecSize
@@litleendian_fix:
                mov     eax, [esi+ebx-4]
                xchg    ah, al
                rol     eax,10h
                xchg    ah,al
                mov     [esi+ebx-4], eax

                mov     ax, [esi+ebx-6h]
                xchg    ah, al
                mov     [esi+ebx-6], ax

                mov     ax, [esi+ebx-8]
                xchg    ah, al
                mov     [esi+ebx-8], ax

                add     esi, FileList_RecSize
                loop    @@litleendian_fix

                mov     eax, 0
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                pop     edx
                pop     ecx
                leave
                retn    4
FSAC_GetFList   endp

;+-------------------------+
;  Get root name - cmd 0xA

FSAC_GetVolName proc

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp

                push    ecx
                push    esi
                push    edi

                mov     esi, [ebp+arg_0]
                mov     ecx, 80h
                xor     eax, eax
                mov     edi, esi
                repe stosd
                mov     word ptr Cmd_Recv_Buf, 0
                mov     dword ptr Cmd_Send_Buf, 0A000000h ; Cmd

                push    offset Cmd_Recv_Size
                push    esi
                push    4
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     word ptr Cmd_Recv_Size, 1
                jz      @@fail
                cmp     byte ptr [esi], 6
                jz      @@fail
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:

                pop     edi
                pop     esi
                pop     ecx

                leave
                retn    4
FSAC_GetVolName endp

FSAC_volume_space proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp

                push    ecx
                push    edx
                push    ebx
                push    esi
                push    edi
                mov     edi, offset Cmd_Send_Buf
                mov     ecx, 80h
                xor     eax, eax
                rep stosd

                mov     byte ptr Cmd_Recv_Buf, 0
                mov     dword ptr Cmd_Send_Buf, 0B000000h ; Cmd
                mov     edi, offset Cmd_Send_Buf
                add     edi, 4
                mov     esi, [ebp+arg_0]
@@loop:
                lodsw
                xchg    ah, al
                cmp     ax, 0
                jz      @@go_fsac
                stosw
                inc     ecx
                cmp     ecx, 80h
                jl      short @@loop

@@go_fsac:
                mov     VolSpace, 0
                push    offset Cmd_Recv_Size
                push    offset Cmd_Recv_Buf
                push    200h
                push    offset Cmd_Send_Buf
                push    004Ah                   ; FSAC
                call    P2K_SendCommand
                cmp     eax, 0
                jnz     @@fail
                cmp     word ptr Cmd_Recv_Size, 1
                jz      @@fail
                cmp     byte ptr [esi], 6
                jz      @@fail
                mov     edx, dword ptr Cmd_Recv_Buf
                xchg    dh, dl
                rol     edx, 10h
                xchg    dh, dl
                mov     VolSpace, edx
                cmp     edx, 0
                jnz     @@ok
                push    offset msg_volsize_zero
                call    logstat
                jmp     @@fail
@@ok:
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                pop     edx
                pop     ecx
                leave
                retn    4
FSAC_volume_space endp


;------------- SEEM IO ----------------

Write_Seem      proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp


                push    offset str_loadseem
                call    logstat

; Seem no
                push    10h
                push    offset str_buf
                push    1013
                push    [ebp+arg_0]
                call    GetDlgItemTextA

                push    offset str_buf
                call    HexStr2Int
                cmp     eax,0FFFFh
                jb      @@seem_ok
                mov     eax, 0FFFFh
@@seem_ok:
                mov     seem_no, eax
                push    eax
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1013
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    offset  str_buf
                call    logstat
; Rec no
                push    10h
                push    offset str_buf
                push    1014
                push    [ebp+arg_0]
                call    GetDlgItemTextA

                push    offset str_buf
                call    HexStr2Int

                cmp     eax,0FFFFh
                jb      @@rec_ok1
                mov     eax, 1h
@@rec_ok1:
                cmp     eax,0
                ja      @@rec_ok
                mov     eax, 1h
@@rec_ok:
                mov     rec_no, eax
                push    eax
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1014
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    offset  str_rec
                call    logstat

                push    offset  str_buf
                call    logstat
; get seem size
                push    offset Seem_Buf
                push    0
                push    0
                push    rec_no
                push    seem_no
                call    Cmd_RDELEM
                cmp     eax, 0
                jnz     @@fail
                mov     Seem_Size, ecx

                mov     fname_buf, 0
                mov     fname_t_buf, 0
                mov     OFN_Flags, 0
                push    offset OpenFileNameSize
                call    GetOpenFileNameA

                push    -1
                push    0
                push    3 ; open existing
                push    0
                push    0
                push    0C0000000h ; generic RW
                push    offset fname_buf
                call    CreateFileA
                mov     FHandle, eax
                cmp     eax,-1
                jz      @@fail

                push    offset filesize_ex
                push    eax
                call    GetFileSize
                cmp     filesize_ex, 0
                jnz     @@fail
                cmp     eax, Seem_Size
                jnz     @@fail

                push    0 ; overlapped
                push    offset file_readed ; bytes readen
                push    Seem_Size  ; bytes to read
                push    offset Seem_Buf
                push    FHandle
                call    ReadFile
                cmp     eax, 0
                jz      @@fail
                mov     eax, Seem_Size
                cmp     file_readed, eax
                jnz     @@fail

                push    offset Seem_Buf
                push    Seem_Size
                push    0
                push    rec_no
                push    seem_no
                call    Cmd_STELEM
                cmp     eax, 0
                jnz     @@fail

                push    FHandle
                call    CloseHandle

                push    offset  str_ok
                call    logstat

@@fail:
                leave
                retn 4
Write_Seem      endp


Read_Seem       proc near               ; CODE

arg_0           = dword ptr  8
                push    ebp
                mov     ebp, esp

                push    offset str_seem_fn
                push    offset fname_buf
                call    lstrcpyA

                push    offset OpenFileNameSize
                mov     OFN_Flags, 0
                call    GetSaveFileNameA
                cmp     eax, 0
                jz      @@canceled

                push    offset str_saveseem
                call    logstat
; Seem from
                push    10h
                push    offset str_buf
                push    1009
                push    [ebp+arg_0]
                call    GetDlgItemTextA

                push    offset str_buf
                call    HexStr2Int
                cmp     eax,0FFFFh
                jb      @@from_ok
                mov     eax, 0FFFFh
@@from_ok:
                mov     seem_no, eax
                push    eax
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1009
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    offset  str_buf
                call    logstat
; Seem to
                push    10h
                push    offset str_buf
                push    1010
                push    [ebp+arg_0]
                call    GetDlgItemTextA

                push    offset str_buf
                call    HexStr2Int
                cmp     eax,0FFFFh
                jb      @@to_ok
                mov     eax, 0FFFFh
@@to_ok:
                mov     seem_to, eax
                push    eax
                push    offset str_hexdw
                push    offset str_buf
                call    wsprintfA
                add     esp, 0Ch

                push    offset str_buf
                push    1010
                push    [ebp+arg_0]
                call    SetDlgItemTextA

                push    offset  str_to
                call    logstat

                push    offset  str_buf
                call    logstat

                push    offset  crlf
                call    logstat

                push    offset  str_wait
                call    logstat

                mov     eax, seem_to
                rol     eax, 10h
                add     eax, seem_no

                push    eax
                push    0
                push    401h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    0
                push    0
                push    402h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                mov     rec_no, 1
@@loop:
                push    0
                push    Seem_no
                push    402h
                push    1018
                push    [ebp+arg_0]
                call    SendDlgItemMessageA

                push    offset seem_buf
                push    0
                push    0
                push    rec_no
                push    Seem_no
                call    Cmd_RDELEM
                cmp     eax, 0
                jnz     @@next
                cmp     ecx, 0
                jz      @@next
                mov     Seem_Size, ecx
;                cmp     byte ptr seem_buf, 0
;                jnz     @@next

                push rec_no
                push seem_no
                push offset str_ctl
                push offset str_buf
                call wsprintfA
                add  esp, 10h

                push    -1
                push    0
                push    1 ; Create new
                push    0
                push    0
                push    0C0000000h ; generic RW
                push    offset str_buf
                call    CreateFileA
                mov     FHandle, eax
;                cmp     eax,0
;                jz      @@createfail

                push    0
                push    offset file_readed
                mov     eax, Seem_Size
                push    eax
                push    offset seem_buf
                push    FHandle
                call    WriteFile
;                cmp     eax, 0
;                jz      @@writefail

                push    FHandle
                call    CloseHandle
                inc     rec_no
                cmp     rec_no,80h
                jbe     @@loop
@@next:
                inc     Seem_no
                mov     rec_no,1
                mov     eax, seem_to
                cmp     seem_no, eax
                jbe     @@loop

                push    offset str_done
                call    logstat
@@canceled:
                leave
                retn    4
Read_Seem       endp

;------------- /SEEM IO ----------------

Cmd_RDELEM      proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h
arg_C           = dword ptr  14h
arg_10          = dword ptr  18h

                push    ebp
                mov     ebp, esp

                push    ebx
                push    esi
                push    edi

                mov     eax, [ebp+arg_0] ; seem
                xchg    al, ah
                mov     seem_num, ax

                mov     eax, [ebp+arg_4] ; record
                xchg    al, ah
                mov     seem_rec, ax

                mov     eax, [ebp+arg_8] ; ofs
                xchg    al, ah
                mov     seem_ofs, ax

                mov     eax, [ebp+arg_C] ; bytes
                xchg    al, ah
                mov     seem_bytes, ax


                mov     seem_read_bytes, 1

                push    offset seem_read_bytes
                push    offset seem_data
                push    8                     ; DataBuf size
                push    offset seem_num

                push    020h           ; COMMAND - RDELEM
                call    P2K_SendCommand
                test    eax, eax
                jnz     @@fail
                cmp     seem_read_bytes, 0
                jbe     short @@fail
                mov     bl, [seem_data]
                test    bl, bl
                jnz     short @@fail
@@ok:
                dec     seem_read_bytes
                jz      @@done
                mov     esi, offset seem_data+1
                mov     edi, [ebp+arg_10]
                mov     ecx, seem_read_bytes
                rep     movsb
@@done:
                mov     ecx, seem_read_bytes
                xor     eax, eax
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                leave
                retn    14h
Cmd_RDELEM      endp

Cmd_STELEM      proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h
arg_C           = dword ptr  14h
arg_10          = dword ptr  18h

                push    ebp
                mov     ebp, esp

                push    ecx
                push    ebx
                push    esi
                push    edi

                mov     eax, [ebp+arg_0] ; seem
                xchg    al, ah
                mov     seem_num, ax

                mov     eax, [ebp+arg_4] ; record
                xchg    al, ah
                mov     seem_rec, ax

                mov     eax, [ebp+arg_8] ; ofs
                xchg    al, ah
                mov     seem_ofs, ax

                mov     eax, [ebp+arg_C] ; bytes
                cmp     eax,0
                ja      @@size_nz
                mov     eax,1
@@size_nz:
                cmp     eax, 2710h
                jna     @@zize_ok
                mov     eax, 2710h
@@zize_ok:
                mov     [ebp+arg_C], eax
                mov     ecx, eax

                xchg    al, ah
                mov     seem_bytes, ax

                mov     esi, [ebp+arg_10] ; data
                mov     edi, offset seem_data
                rep     movsb

                mov     seem_read_bytes, 1

                push    offset seem_read_bytes
                push    offset stelem_result

                mov     eax, [ebp+arg_C] ; bytes
                add     eax, 8
                push    eax                   ; DataBuf size
                push    offset seem_num

                push    02Fh        ; COMMAND STELEM
                call    P2K_SendCommand
                test    eax, eax
                jnz     @@fail
                mov     eax, 0
                mov     bl, byte ptr stelem_result
                test    bl, bl
                jz      short @@ok
@@fail:
                mov     eax, -1
@@ok:
                pop     edi
                pop     esi
                pop     ebx
                pop     ecx
                leave
                retn    14h
Cmd_STELEM      endp


;------------- Old SENDCOMMAND ----------------
; Send any! command to PST.DLL and then - to phone....
; ⠢  ᮢ⨬  楤ઠ  PST,
;   ⠪  뤨 ਤ :)
;PST_Send_Command proc near
;
;arg_0           = dword ptr  8
;arg_4           = dword ptr  0Ch
;arg_8           = dword ptr  10h
;arg_C           = dword ptr  14h
;arg_10          = dword ptr  18h
;arg_14          = dword ptr  1Ch
;arg_18          = dword ptr  20h
;arg_1C          = dword ptr  24h
;
;                push    ebp
;                mov     ebp, esp
;
;                push    ebx
;                push    esi
;                push    edi
;                mov     esi, [ebp+arg_1C]
;                test    esi, esi
;                jz      short @@arg_1C_nz
;                mov     dword ptr [esi], 1
;@@arg_1C_nz:
;                mov     [ebp+arg_1C], 1
;                mov     eax, [ebp+arg_0]
;                mov     [ebp+arg_4], eax
;
;                lea     eax, [ebp+arg_1C]
;                push    eax                   ; arg_18 - arg_1C forward
;                push    [ebp+arg_18]          ; arg_14 - arg_18 forward
;
;                mov     ebx, [ebp+arg_C] ; In_Buf_Size
;                and     ebx, 0FFFFh
;                push    ebx                   ; arg_10 - arg_C forward - DataBuf size
;
;                push    [ebp+arg_10]          ; arg_C - DataBuf
;                push    [ebp+arg_4]           ; arg_8 - COMMAND str
;                call    P2K_SendCommand
;                mov     ecx, _DevList_4
;                mov     word ptr [ecx], 0
;
;                test    eax, eax
;                jz      short @@exit_ok
;                xor     esi, esi
;                jmp     short @@exit
;@@exit_ok:
;                mov     ecx, [ebp+arg_1C]
;                mov     edx, [ebp+arg_14]
;                mov     esi, 1
;                test    cx, cx
;                mov     [edx], cx
;
;@@exit:
;                mov     eax, esi
;                pop     edi
;                pop     esi
;                pop     ebx
;
;                leave
;                retn    20h
;PST_Send_Command endp

;------------- P2K USB IO Procedures ----------------

P2K_SendCommand proc near
arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h
arg_C           = dword ptr  14h
arg_10          = dword ptr  18h

                push    ebp
                mov     ebp, esp

                push    ecx
                push    edx
                push    ebx
                push    esi
                push    edi
                inc     Packet_ID

                mov     edi, offset packet_buf
                mov     ecx, 400h
                xor     eax, eax
                rep     stosd

                mov     edi, offset packet_buf
                mov     byte ptr [edi+00h], 41h
                mov     byte ptr [edi+01h], 02h
                mov     word ptr [edi+02h], 0000h
                mov     word ptr [edi+04h], 0008h ; Interface
                mov     eax, [ebp+arg_8]
                add     eax, 8
                mov     word ptr [edi+06h], ax    ; size ws command & size
                mov     dx, Packet_ID
                and     dx, 0FFFh
                xchg    dh, dl
                mov     word ptr [edi+08h], dx ; random - Packet ID
                mov     edx, [ebp+arg_0]
                and     dx,0FFFh
                xchg    dh,dl
                mov     word ptr [edi+0Ah], dx ; command
                mov     eax, [ebp+arg_8]
                xchg    ah, al
                mov     word ptr [edi+0Ch], ax    ; size
                mov     word ptr [edi+0Eh], 0000h
                mov     eax, [ebp+arg_8]
                add     eax, 12h
                mov     packet_size, eax
                mov     esi, [ebp+arg_4]
                add     edi, 10h
                mov     ecx, [ebp+arg_8]
                rep     movsb

                push    offset packet_size
                push    offset packet_buf
                call    USB_WriteData
                cmp     eax, 0
                jz      @@Write_ok

                push    offset msg_cmd_write_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit

@@Write_ok:
                call    GetTickCount
                mov     ReadStatus_Ticks, eax
@@status_loop:
                mov     edi, offset status_read_buf
                mov     ecx, 3
                xor     eax, eax
                rep     stosd

                mov     edi, offset status_read_buf
                mov     byte ptr [edi+00h], 0C1h
                mov     byte ptr [edi+01h], 0
                mov     word ptr [edi+02h], 0
                mov     word ptr [edi+04h], 8
                mov     word ptr [edi+06h], 8

                mov     status_read_size, 0Ch

                push    offset status_read_size
                push    offset status_read_buf
                call    USB_ReadData

                cmp     eax, 0
                jnz     @@next_try
                mov     al, status_read_buf+1
                cmp     al, 3
                jae     @@next_try
                cmp     al, 0
                jnz     @@done
@@next_try:
                push    1
                call    Sleep

                call    GetTickCount
                sub     eax, ReadStatus_Ticks
                cmp     eax, 9C40h ; timeout
                jb      @@status_loop

                push    offset msg_cmd_timeout
                mov     eax,-1
                jmp     @@exit

@@done:
                push    1
                call    Sleep

                mov     edi, offset data_read_buf
                mov     ecx, 400h
                xor     eax, eax
                rep     stosd

                mov     edi, offset data_read_buf
                mov     byte ptr [edi+00h], 0C1h
                mov     byte ptr [edi+01h], 1
                movzx   ax, byte ptr status_read_buf+1
                mov     word ptr [edi+02h], ax ; packets #
                mov     word ptr [edi+04h], 8 ; IF

                shl     ax, 1
                mov     cx, word ptr status_read_buf+2
                xchg    ch, cl
                add     ax, cx
;                add     ax, word ptr status_read_buf+4
;                add     ax, word ptr status_read_buf+6
                add     ax, 4
                mov     word ptr [edi+06h], ax ; Size

                mov     data_read_size, 0FA4h
                push    offset data_read_size
                push    offset data_read_buf
                call    USB_ReadData
                cmp     eax, 0
                jz      @@Read_ok

                push    offset msg_cmd_read_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@Read_ok:
                mov     esi, offset data_read_buf
                cmp     byte ptr [esi+00h], 1
                jnz     @@fail
                mov     cx, [esi+04h]
                xchg    ch,cl
                mov     dl, [esi+06h]
                and     dl, 80h
                cmp     dl, 80h
                jnz     @@fail
                mov     dx, [esi+06h]
                xchg    dh, dl
                and     dx, 0FFFh ; Packet ID
                cmp     Packet_ID, dx
                jnz     @@fail
                mov     dl, [esi+08h]
                shr     dl, 4

                cmp     dl, 6        ; Answ 6 - result ok, no data returned
                mov     eax, 0
                jz      @@exit

                cmp     dl, 8        ; Answ 8 - result ok
                jz      @@op_ok
                and     edx, 0Fh
                mov     eax, [IO_Err+edx*4]
                push    eax
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@op_ok:
                mov     dx, [esi+0Ah]
                xchg    dh, dl
                sub     cx, 8
                cmp     cx, dx
                jnz     @@fail ; bad packet - size mismatch
                jmp     @@ok

@@fail:
                push    offset msg_cmd_answer_fail
                call    logstat
                mov     eax, 1
                jmp     @@exit

@@ok:
                add     esi, 0Eh
                mov     edi, [ebp+arg_C]
                mov     eax, [ebp+arg_10]
                and     ecx, 0FFFFh
                mov     [eax], ecx
                rep     movsb
                mov     eax, 0
@@exit:
                pop     edi
                pop     esi
                pop     ebx
                pop     edx
                pop     ecx
                leave
                retn    14h
P2K_SendCommand endp

USB_WriteData   proc    near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp

                push    0
                push    0
                push    1
                push    0
                call    CreateEventA
                cmp     eax, 0
                jnz     @@event_ok

                push    offset msg_usb_event_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@event_ok:
                mov     DevIO_Event, eax

                push    DevIO_Event
                call    ResetEvent
                cmp     eax, 0
                jnz     @@reset_ok

                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_reset_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@reset_ok:

                push    offset DevIO_Overlapped
                push    0
                push    5
                push    offset DevIO_Result
                mov     eax,[ebp+arg_4] ; InBuf_Size
                mov     eax, [eax]
                push    eax
                push    [ebp+arg_0]     ; InBuf
                push    80002014h
                push    _DevIF
                call    DeviceIOControl

                push    3E8h
                push    DevIO_Event
                call    WaitForSingleObject
                cmp     eax, 0
                jz      @@wait_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_wait_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@wait_ok:
                push    0
                push    [ebp+arg_4] ; InBuf_Size - recvd
                push    offset DevIO_Overlapped
                push    _DevIF
                call    GetOverlappedResult
                cmp     eax, 0
                jnz     @@devio_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_result_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit

@@devio_ok:
                push    DevIO_Event
                call    CloseHandle
;                push    offset msg_usb_write_ok
;                call    logstat
                mov     eax, 0
@@exit:
                leave
                retn    8
USB_WriteData   endp

USB_ReadData    proc    near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp

                push    0
                push    0
                push    1
                push    0
                call    CreateEventA
                cmp     eax, 0
                jnz     @@event_ok

                push    offset msg_usb_event_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@event_ok:
                mov     DevIO_Event, eax

                push    DevIO_Event
                call    ResetEvent
                cmp     eax, 0
                jnz     @@reset_ok

                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_reset_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@reset_ok:

                push    offset DevIO_Overlapped
                push    0
                push    1005h
                push    offset DevIO_Result
                mov     eax,[ebp+arg_4] ; InBuf_Size
                push    9
                push    [ebp+arg_0]     ; InBuf
                push    80002014h
                push    _DevIF
                call    DeviceIOControl

                push    9C40h
                push    DevIO_Event
                call    WaitForSingleObject
                cmp     eax, 0
                jz      @@wait_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_wait_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@wait_ok:

                push    0
                push    [ebp+arg_4] ; InBuf_Size - recvd
                push    offset DevIO_Overlapped
                push    _DevIF
                call    GetOverlappedResult
                cmp     eax, 0
                jnz     @@devio_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_result_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@devio_ok:
                mov     esi, [ebp+arg_4]
                mov     ecx, [esi]
                cmp     ecx, 4
                jnb     @@size_ok
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_size_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@size_ok:
                sub     ecx, 4
                mov     [esi], ecx
                mov     esi, offset DevIO_Result
                add     esi, 4
                mov     edi, [ebp+arg_0]
                rep     movsb
                push    DevIO_Event
                call    CloseHandle
;                push    offset msg_usb_read_ok
;                call    logstat
                mov     eax, 0
@@exit:
                leave
                retn    8
USB_ReadData    endp

USB_GetIFInfo   proc    near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp

                push    ecx
                push    esi
                push    edi

                push    0
                push    0
                push    1
                push    0
                call    CreateEventA
                cmp     eax, 0
                jnz     @@event_ok

                push    offset msg_usb_event_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@event_ok:
                mov     DevIO_Event, eax

                push    DevIO_Event
                call    ResetEvent
                cmp     eax, 0
                jnz     @@reset_ok

                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_reset_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@reset_ok:
                mov     eax, [ebp+arg_0]
                mov     IF_Info_cmd, eax

                push    offset DevIO_Overlapped
                push    offset IF_Info_recvd
                push    105h
                push    [ebp+arg_4]
                push    2
                push    offset IF_Info_cmd ; InBuf
                push    80002010h
                push    _DevIF
                call    DeviceIOControl

                push    1388h
                push    DevIO_Event
                call    WaitForSingleObject
                cmp     eax, 0
                jz      @@wait_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_wait_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@wait_ok:

                push    0
                push    offset IF_Info_recvd ; InBuf_Size - recvd
                push    offset DevIO_Overlapped
                push    _DevIF
                call    GetOverlappedResult
                cmp     eax, 0
                jnz     @@devio_ok

                push    _DevIF
                call    CancelIo
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_result_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@devio_ok:
                cmp     IF_Info_recvd, 4
                jnb     @@size_ok
                push    DevIO_Event
                call    CloseHandle
                push    offset msg_usb_size_fail
                call    logstat
                mov     eax, -1
                jmp     @@exit
@@size_ok:
                push    DevIO_Event
                call    CloseHandle
;                push    offset msg_usb_read_ok
;                call    logstat
                mov     ecx, dword ptr str_buf
                mov     esi, offset str_buf+4
                mov     edi, offset str_buf
@@str_loop:
                lodsw
                stosb
                loop    @@str_loop

                mov     eax, 0
@@exit:
                pop     edi
                pop     esi
                pop     ecx
                leave
                retn    8
USB_GetIFInfo   endp


;------------- Phone initialize procs ----------------
COM_Find        proc near
                push    ebp
                mov     ebp, esp
                push    edi
                push    ecx

                mov     edi, offset keyval_buf
                mov     ecx, 40h
                xor     eax, eax
                rep     stosd

                push    offset Key_handle
                push    20019h
                push    0
                push    offset str_serialcom_key
                push    80000002h
                call    RegOpenKeyExA

                mov     keyval_size, 100h

                push    offset keyval_size
                push    offset keyval_buf
                push    offset keyval_type
                push    0
                push    offset str_usbser
                push    Key_handle
                call    RegQueryValueExA

                push    Key_handle
                call    RegCloseKey
                mov     eax, dword ptr keyval_buf
                and     eax, 00FFFFFFh
                cmp     eax, 'MOC'
                jnz     @@fail
                mov     eax, 0
                jmp     @@exit
@@fail:
                mov     eax, -1
@@exit:
                pop     ecx
                pop     edi
                leave
                retn
COM_Find        endp

Switch_mode     proc near
                push    ebp
                mov     ebp, esp

                push    -1
                push    0
                push    1 ; Create new
                push    0
                push    0
                push    0C0000000h ; generic RW
                push    offset keyval_buf
                call    CreateFileA
                mov     ComHandle, eax
                cmp     eax,0
                jnz     @@create_ok
                mov     eax, -1
                jmp     @@exit
@@create_ok:
                push    0
                push    offset at_readed
                push    0Bh
                push    offset at_mode
                push    ComHandle
                call    WriteFile
                cmp     eax, 0
                jnz     @@write_ok
                push    ComHandle
                call    CloseHandle
                mov     eax, -1
                jmp     @@exit
@@write_ok:
                push    ComHandle
                call    CloseHandle
                mov     eax, 0
@@exit:
                leave
                retn
Switch_mode     endp

FindUSBClass    proc near
                push    ebp
                mov     ebp, esp
                pusha

                push    12h             ; flags
                push    0               ; parent_hwnd
                push    0               ; enum
                push    offset DevClass ; class GUID
                call    SetupDiGetClassDevsA
                cmp     eax, -1
                jz      @@getclass_fail
                mov     ClassInfoSet, eax

                mov     DevIF_Index, 0

@@loop:
                mov     _DevIF, 0
                push    offset DevIF_Data   ; DevIFData
                push    DevIF_Index         ; dev index
                push    offset DevClass     ; IF class GUID
                push    0                   ; dev info data
                push    ClassInfoSet
                mov     DevIF_Data, 1Ch     ; size
                call    SetupDiEnumDeviceInterfaces
                test    eax, eax
                jz      @@exit ; @@dev_enum_failed ; +

                push    0                    ; DevInfoData
                push    offset DevIF_ReqSize ; ReqSize
                push    0                    ; DevIFDetailSize
                push    0                    ; DevIFDetail
                push    offset DevIF_Data    ; DevIFData
                push    ClassInfoSet
                call    SetupDiGetDeviceInterfaceDetailA
                test    eax, eax
                jnz     @@dev_info_noerr

                call    GetLastError
                cmp     eax, 7Ah        ; err_insuff_buffer
                jnz     @@exit ; _Destroy_list

@@dev_info_noerr:
                push    DevIF_ReqSize ; 5Ah?
                push    40h
                call    GlobalAlloc
                mov     esi, eax
                test    esi, esi
                jz      @@exit ; _Destroy_list

                mov     dword ptr [esi], 5
                push    0               ; DevInfoData
                push    0               ; DevIF_Req_Size
                push    DevIF_ReqSize   ; DevIFDetailSize
                push    esi             ; DevIFDetail - dd size and str - path
                push    offset DevIF_Data ; DevIFData
                push    ClassInfoSet    ; devinfoset
                call    SetupDiGetDeviceInterfaceDetailA
                test    eax, eax
;                jz      @@Dev_GetDetail_failed
                jz      @@fail_gonext

                push    0
                push    0
                push    3
                push    0
                push    3
                push    0C0000000h
                lea     edi, [esi+4]    ; DevIF path
                push    edi
                call    CreateFileA
                mov     ebx, eax
                cmp     ebx, 0FFFFFFFFh
                jz      short @@fail_gonext
                mov     _DevIF, ebx

                push    offset str_buf
                push    0002h
                call    USB_GetIFInfo

                push    offset str_Motorola_TCI
                push    offset  str_buf
                call    lstrcmpA
                cmp     eax, 0
                jnz     @@not_tci
;                push    edi
;                mov     eax, DevIF_Index
;                mov     [NamesArr_Buf+eax*4], esi
                mov     Dev_Name_Ptr, esi
                jmp     @@exit
@@not_tci:
                push    ebx
                call    CloseHandle
                inc     DevIF_Index
                jmp     @@loop

@@fail_gonext:
                push    esi
                call    GlobalFree
                inc     DevIF_Index
                jmp     @@loop

;@@dev_enum_failed:
;                call    GetLastError
;                jmp     @@exit_Destroy_list

;@@Dev_GetDetail_failed:
;                push    esi
;                call    GlobalFree

@@exit:
                push    ClassInfoSet
                call    SetupDiDestroyDeviceInfoList
@@getclass_fail:
                popa
                leave
                retn
FindUSBClass    endp


CODE            ends

DATA            segment para public 'DATA' use32
Our_Handle      dd 0
Dlg_hwnd        dd 0
stay_quiet      dd 0

Tray_Struc      dd 58h
Tray_Wnd_Handle dd 0
Tray_ID         db 'P2K '
Tray_Flags      dd 7
Tray_CallBack   dd 400h
Tray_IconHandle dd 0
Tray_Hint       db 'Left click to open service window.', 0, 1Ch dup(0)

lv_Col_Mask      dd 0
lv_Col_Fmt       dd 0
lv_Col_Size      dd 0
lv_Col_Text      dd 0
lv_Col_TextMax   dd 0
lv_Col_SubItem   dd 0
lv_col_Extra     dd 0


LV_Sort_id       dd 0
LV_Sort_dir      db 0
align 4

; ListBox columns struc

Tbl_Cols        dd offset Row_FileName
                dd 0E0h
                dd 0
                dd offset Row_FileFlags
                dd 50h
                dd 0
                dd offset Row_FileSize
                dd 40h
                dd 0
                dd offset Row_FileType
                dd 40h
                dd 0
col_list_end    dd 0


; item structure for manipulating lines
lv_Mask         dd 1 ; mask
lv_Item         dd 0 ; iItem
lv_SubItem      dd 0 ; iSubItem
lv_State        dd 0 ; state
lv_StateMask    dd 0 ; stateMask
lv_Text         dd 0 ; pszText
lv_TextMax      dd 0 ; cchTextMax
lv_Image        dd 0 ; iImage
lv_LParam       dd 1 ; lParam

next_sel_item   dd 0


tv_Parent       dd 0
tv_InsertAfter  dd 0
; TV_ITEM
tv_Mask         dd 0
tv_Item         dd 0
tv_State        dd 0
tv_StateMask    dd 0
tv_Text         dd 0
tv_TextMax      dd 0
tv_Image        dd 0
tv_SelImage     dd 0
tv_Chield       dd 0
tv_LParam       dd 0

Tree_root       dd 0





; Popup menu data
Cursor_X        dd 0
Cursor_Y        dd 0
Menu_Handle     dd 0

Thread_Handle    dd 0
Thread_Id        dd 0
Key_Class_handle dd 0
DevFound         dd 0

AutoUpd          dd 0

status_parts    dd 50h, 0D0h, 1E0h, -1

Use_Path        dd 1

; PSTGetDeviceInterface data
_DevIF          dd 0


;------------------------------

OpenFileNameSize  dd 4Ch ;    DWORD         lStructSize;
                  dd 0   ;    HWND          hwndOwner;
                  dd 0   ;    HINSTANCE     hInstance;
ofn_filter        dd offset str_ofn_filter   ;    LPCTSTR       lpstrFilter;
                  dd 0   ;    LPTSTR        lpstrCustomFilter;
                  dd 0   ;    DWORD         nMaxCustFilter;
                  dd 0   ;    DWORD         nFilterIndex;
                  dd offset fname_buf       ;    LPTSTR        lpstrFile;
                  dd 1FFh                   ;    DWORD         nMaxFile;
                  dd offset fname_t_buf     ;    LPTSTR        lpstrFileTitle;
                  dd 1FFh                   ;    DWORD         nMaxFileTitle;
                  dd 0   ;    LPCTSTR       lpstrInitialDir;
                  dd 0   ;    LPCTSTR       lpstrTitle;
OFN_Flags         dd 0   ;    DWORD         Flags;
                  dd 0
                         ;    WORD          nFileOffset;
                         ;    WORD          nFileExtension;
                  dd 0   ;    LPCTSTR       lpstrDefExt;
                  dd 0   ;    DWORD         lCustData;
                  dd 0   ;    LPOFNHOOKPROC lpfnHook;
                  dd 0   ;    LPCTSTR       lpTemplateName;

FHandle         dd 0
filesize_ex     dd 0  ; GetFileSize hi dword
FileSize        dd 0
file_readed     dd 0
FileBuf_Ptr     dd 0  ; upload buffer
files_dl_first  dd 0


IO_Err          dd offset msg_inv_data_len
                dd offset msg_inv_seq
                dd offset msg_cmd_par_inv
                dd offset msg_cmd_not_supp
                dd offset msg_inv_opcode
                dd offset msg_inv_param
                dd offset msg_err_code_unk_6 ; resp_ack
                dd offset msg_generic_fail
                dd offset msg_err_code_unk_8
                dd offset msg_err_code_unk_9
                dd offset msg_mem_fail
                dd offset msg_task_error
                dd offset msg_task_timeout
                dd offset msg_cdma_err
                dd offset msg_len_error
                dd offset msg_crit_error

str_ofn_filter  db 'All files', 0
                db '*.*', 0, 0

crlf            db 0Dh,0Ah,0
fn_mytonedb     db 'MyToneDB.db', 0
str_ctl         db '%.4x_%.4x.seem', 0
str_hex         db '%x', 0
str_hexdw       db '%.4x', 0
str_dec         db '%d', 0
str_slash       db '/', 0

str_motorola_tci db 'Motorola Test Command',0
str_seem_fn     db 'xxxx_yyyy.seem', 0
str_serialcom_key db 'HARDWARE\DEVICEMAP\SERIALCOMM',0
str_devclass_key  db 'SYSTEM\CurrentControlSet\Control\DeviceClasses\{4e1e1e15-52d7-11d4-852d-00105aa6f80b}\%s\#\Control',0
str_usbser        db '\Device\USBSER000', 0
at_mode           db 'at+mode=8', 0Dh, 0Ah, 0

                align 4

lng_english      db 'english', 0
lng_russian      db 'russian', 0
ini_language     db 'Language' ,0
ini_general      db 'General', 0
ini_AutoFileList db 'AutoFileList', 0


str_root_ctl     db '%S (%S)', 0
str_model_ctl    db 'Phone model: %S', 0
str_volume_ctl   db 'Volume name: %S, Free space %d KBytes', 0

; string data
msg_inv_data_len db 'INVALID DATA LENGTH FOR COMMAND', 0Dh, 0Ah, 0
msg_inv_seq      db 'INADEQUATE SEQURITY LEVEL FOR COMMAND/PARAMETER', 0Dh, 0Ah, 0
msg_cmd_par_inv  db 'COMMAND/PARAMETER NOT SUPPORTED FOR CURRENT PROTOCOL', 0Dh, 0Ah, 0
msg_cmd_not_supp db 'COMMAND NOT SUPPORTED FOR CURRENT MODE', 0Dh, 0Ah, 0
msg_inv_opcode   db 'UNSUPPORTED/INVALID OPCODE', 0Dh, 0Ah, 0
msg_inv_param    db 'UNSUPPORTED/INVALID PARAMETER FOR OPCODE', 0Dh, 0Ah, 0
msg_err_code_unk_6 db 'CRITICAL ERROR - ERROR CODE NOT FOUND (6)', 0Dh, 0Ah, 0
msg_generic_fail db 'GENERIC FAILURE', 0Dh, 0Ah, 0
msg_err_code_unk_8 db 'CRITICAL ERROR - ERROR CODE NOT FOUND (8)', 0Dh, 0Ah, 0
msg_err_code_unk_9 db 'CRITICAL ERROR - ERROR CODE NOT FOUND (9)', 0Dh, 0Ah, 0
msg_mem_fail     db 'COULDN''T ALLOCATE MEMORY', 0Dh, 0Ah, 0
msg_task_error   db 'INTERNAL TASK ERROR', 0Dh, 0Ah, 0
msg_task_timeout db 'TEST COMMAND TASK TIMED OUT WAITING FOR RESPONSE', 0Dh, 0Ah, 0
msg_cdma_err     db 'CDMA PARSE ERROR', 0Dh, 0Ah, 0
msg_len_error    db 'LENGTH SPECIFIED IN COMMAND HEADER GREATER THAN RECEIVED BY TRANSPORT', 0Dh, 0Ah, 0
msg_crit_error   db 'IRRECOVERABLE ERROR; PHONE STATE HAS BEEN LOST. PHONE BEING POWERED DOWN', 0Dh, 0Ah, 0

; Listbox column names
Row_FileName     db 'File', 0
Row_FileFlags    db 'Attributes', 0
Row_FileSize     db 'Size', 0

; log strings

str_FSAC_Info    db 'Volume information:', 0Dh, 0Ah, 0
str_volname_fail db 'Volume name fail', 0Dh, 0Ah, 0
str_volsize_fail db 'Volume size fail', 0Dh, 0Ah, 0
msg_volsize_zero db 'Zero free space recv''d!', 0Dh, 0Ah, 0
str_volname      db 'Name: ', 0
str_delete       db 'A you sure you want to delete file %s ?', 0
str_init_fail    db 'Failed to find P2K device...', 0Dh, 0Ah
                 db 'Please connect Phone and try again.', 0
str_Files_Added  db 'Files found: ', 0
str_Search_req   db 'Receiving file list...', 0
str_selitem      db 'Selected item: ', 0
str_saveseem     db 'downloading seem data from ', 0
str_loadseem     db 'uploading seem N ', 0
str_rec          db 'record N ', 0
str_to           db ' to ', 0
str_wait         db 'Please wait, it can take few minutes...', 0Dh, 0Ah, 0
str_done         db 'Done.', 0Dh, 0Ah, 0


msg_cmd_write_fail  db 'CMD: Data write fail!', 0Dh, 0Ah, 0
msg_cmd_timeout     db 'CMD: Answer wait timeout!', 0Dh, 0Ah, 0
msg_cmd_read_fail   db 'CMD: Data read fail!', 0Dh, 0Ah, 0
msg_cmd_answer_fail db 'CMD: Answer packet invalid!', 0Dh, 0Ah, 0

msg_usb_write_ok    db 'USB: Write data ok', 0Dh, 0Ah, 0
msg_usb_read_ok     db 'USB: Read data ok', 0Dh, 0Ah, 0
msg_usb_event_fail  db 'USB: Event create failed!', 0Dh, 0Ah, 0
msg_usb_reset_fail  db 'USB: Event reset failed!', 0Dh, 0Ah, 0
msg_usb_wait_fail   db 'USB: IO Time-out!', 0Dh, 0Ah, 0
msg_usb_result_fail db 'USB: IO Failed!', 0Dh, 0Ah, 0
msg_usb_size_fail   db 'USB: Answer size invlid!', 0Dh, 0Ah, 0


str_nodev            db 'phone not connected', 0Dh, 0Ah, 0
str_profiles_readed  db 'Profiles info read ok', 0Dh, 0Ah, 0
str_profiles_updated db 'Profiles info update ok', 0Dh, 0Ah, 0
str_tonebase_deleted db 'Ringtone base file deleted', 0Dh, 0Ah, 0
str_not_conn    db 'Not connected', 0
str_conn        db 'Connected', 0
str_upload      db 'File upload... ', 0
str_deleting    db 'Deleting file ', 0
str_download    db 'File download...', 0
str_attr        db ' Changing attrib for file ', 0
str_ok          db ' ok', 0Dh, 0Ah, 0
str_fail        db ' Fail!', 0Dh, 0Ah, 0
str_filesnum    db 'Invalid files count!', 0Dh, 0Ah, 0
str_malloc_fail db ' Memory allocation fail', 0Dh, 0Ah, 0
msg_fl_rec_size_fail db 'FileList entry size invalid!', 0Dh, 0Ah, 0
str_canceled    db ' Canceled.', 0Dh, 0Ah, 0
str_sizefail    db ' Fail: file size invalid', 0Dh, 0Ah, 0
str_openfail    db ' Fail: cannot open file', 0Dh, 0Ah, 0
str_memfail     db ' Fail: cannot allocate mem', 0Dh, 0Ah, 0
str_seekfail    db ' Fail: cannot seek to zero', 0Dh, 0Ah, 0
str_readfail    db ' Fail: cannot read file', 0Dh, 0Ah, 0
str_fcreatefail db ' Fail: cannot create file', 0Dh, 0Ah, 0
str_no_files_sel db 'No files selected.', 0Dh, 0Ah, 0
str_writefile_fail db ' Fail: cannot write', 0Dh, 0Ah, 0
str_volinfofail db ' Fail: cannot get vol info', 0Dh, 0Ah, 0
str_about_title db 'About', 0
str_about       db 'P2KMAN phone file manager', 0Dh, 0Ah
                db 'designed for Motorola P2K phones', 0Dh, 0Ah
                db 'Author Vilko. Interface by M.org', 0Dh, 0Ah
                db 'build 27.07.2004', 0
Row_FileType    db 'Type', 0

str_null        dd 0
align 4
; SetupUI data structures

Dev_Name_Ptr    dd 0

ClassInfoSet    dd 0
DevIF_Index     dd 0

DevIF_Data      dd 0 ; size
DevIF_GUID      dd 0
DevIF_Flags     dd 0
DevIF_res       dd 0
                dd 0
                dd 0
                dd 0


DevIF_ReqSize   dd 0

DevClass        dd 4E1E1E15h, 11D452D7h, 10002D85h, 0BF8A65Ah

DevIO_Overlapped  dd 0
                  dd 0
                  dd 0
                  dd 0
DevIO_Event       dd 0
DevIO_Result      db 1010h dup (?) ; 1008h
;-----------------------------
CommTimeouts       dd ?
CommTimeouts_Multi dd ?
CommTimeouts_Const dd ?
CommTimeouts_W_Multi dd ?
CommTimeouts_W_Const dd ?

ComHandle       dd ?
at_readed       dd ?
Key_handle      dd ?
keyval_type     dd ?
keyval_size     dd ?
keyval_buf      db 100h dup (?)


; Filelist data
Files_found      dd ?
FileList_RecSize dd ?
SearchBuf_Ptr    dd ?
VolSpace         dd ?


; FSAC_Read data
Download_BufPtr dd ?
Download_FSize  dd ?

stelem_result   dd ?
seem_read_bytes dd ?

seem_num        dw ?
seem_rec        dw ?
seem_ofs        dw ?
seem_bytes      dw ?
seem_data       db 2710h dup (?)

rec_no          dd ?
seem_no         dd ?
seem_to         dd ?


Cmd_Send_Size    dd ?
Cmd_Recv_Size    dd ?
Cmd_Send_Buf     db 1000h dup (?)
Cmd_Recv_Buf     db 1000h dup (?)

Packet_ID        dw ?
                 dw ?
packet_size      dd ?
packet_buf       db 1000h dup (?)
status_read_size dd ?
status_read_buf  db 0Ch dup (?) ; 0Ch bytes
data_read_size   dd ?
data_read_buf    dd 1000h dup (?)
ReadStatus_Ticks dd ?

IF_Info_cmd      dd ?
IF_Info_recvd    dd ?

str_buf         db 1000h dup (?)
str_buf2        db 1000h dup (?)
volname         db 100h dup (?)
phone_model     db 100h dup (?)
lv_get_text     db 200h dup (?)
fname_buf       db 200h dup (?) ; buffer for open/save full filename
fname_t_buf     db 200h dup (?) ; buffer for open/save short filename (w/o path)


FileView_Slash1 dd ?
FileView_Slash2 dd ?
Tree_FileLoop   dd ?

ini_file        db 100h dup (?)
Seem_Size       dd ?
Seem_Buf        db 1000h dup (?)
Search_Buf      db 1000h dup (?)
DATA            ends

include externs.inc
                end start
