/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.lcdui;

import com.ibm.weme.examples.golftracker.Golf;
import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.lcdui.IView;
import com.ibm.weme.examples.golftracker.lcdui.IViewManager;
import com.ibm.weme.examples.golftracker.model.IGolfScoreTrackerConstants;
import java.util.Date;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;

public final class StartView
implements IView,
CommandListener,
ItemStateListener {
    private Form form;
    private IViewManager viewManager;
    private Command start;
    private Command exit;
    private DateField dateField;
    private ChoiceGroup coursesGroup;
    private ChoiceGroup locationsGroup;

    public StartView(IViewManager viewManager) {
        this.viewManager = viewManager;
        this.buildForm();
    }

    public final Form getForm() {
        return this.form;
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == this.start) {
            this.start();
        } else if (command == this.exit) {
            this.exit();
        }
    }

    public final void itemStateChanged(Item item) {
        if (item == this.locationsGroup) {
            this.locationSelected();
        }
    }

    private final void buildForm() {
        this.form = new Form(IGolfScoreTrackerConstants.NEW_GAME_COMMAND);
        this.dateField = new DateField(String.valueOf(IGolfScoreTrackerConstants.DATE_LABEL) + ':', 1);
        this.dateField.setDate(new Date());
        this.form.append((Item)this.dateField);
        this.locationsGroup = new ChoiceGroup(String.valueOf(IGolfScoreTrackerConstants.LOCATION_LABEL) + ':', 4);
        String[] locations = Golf.listLocationNames();
        int i = 0;
        while (i < locations.length) {
            this.locationsGroup.append(locations[i], null);
            ++i;
        }
        this.form.append((Item)this.locationsGroup);
        this.coursesGroup = new ChoiceGroup(String.valueOf(IGolfScoreTrackerConstants.COURSE_LABEL) + ':', 4);
        this.locationSelected();
        this.form.append((Item)this.coursesGroup);
        this.start = new Command(IGolfScoreTrackerConstants.START_COMMAND, 1, 1);
        this.form.addCommand(this.start);
        this.exit = new Command(IGolfScoreTrackerConstants.EXIT_LABEL, 7, 1);
        this.form.addCommand(this.exit);
        this.form.setCommandListener((CommandListener)this);
        this.form.setItemStateListener((ItemStateListener)this);
    }

    private final void locationSelected() {
        String[] courses = Golf.listCourseNamesForLocationName(this.getLocation());
        this.coursesGroup.deleteAll();
        int i = 0;
        while (i < courses.length) {
            this.coursesGroup.append(courses[i], null);
            ++i;
        }
    }

    private final Date getDate() {
        return this.dateField.getDate();
    }

    private final String getLocation() {
        ChoiceGroup choiceGroup = this.locationsGroup;
        return choiceGroup.getString(choiceGroup.getSelectedIndex());
    }

    private final String getCourse() {
        ChoiceGroup choiceGroup = this.coursesGroup;
        return choiceGroup.getString(choiceGroup.getSelectedIndex());
    }

    private final void start() {
        IGolfGame game = Golf.newGame(this.getLocation(), this.getCourse(), this.getDate());
        this.viewManager.setGame(game);
        this.viewManager.saveGame();
        this.viewManager.showView(1);
    }

    private final void exit() {
        this.viewManager.exitGame();
    }

    public final void cleanup() {
        this.form = null;
        this.viewManager = null;
        this.start = null;
        this.exit = null;
        this.dateField = null;
        this.coursesGroup = null;
        this.locationsGroup = null;
    }
}

