/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker;

import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.model.GolfCourse;
import com.ibm.weme.examples.golftracker.model.GolfGame;
import java.io.IOException;
import java.util.Date;

public abstract class Golf {
    private static final String[] CLUB_NAMES = new String[]{"Spoon North", "Fork South"};
    private static final String[][] COURSE_NAMES = new String[][]{{"Full 18", "Front 9", "Back 9"}, {"Executive 9"}};

    public static String[] listLocationNames() {
        return CLUB_NAMES;
    }

    public static String[] listCourseNamesForLocationName(String locationName) {
        int i = 0;
        while (i < CLUB_NAMES.length) {
            if (CLUB_NAMES[i].equals(locationName)) {
                return COURSE_NAMES[i];
            }
            ++i;
        }
        return null;
    }

    public static IGolfGame newGame(String locationName, String courseName, Date date) {
        return new GolfGame(locationName, courseName, date);
    }

    public static IGolfGame newGame(byte[] record) throws IOException {
        return new GolfGame(record);
    }

    public static GolfCourse getCourse(String locationName, String courseName) {
        if ("Spoon North".equals(locationName)) {
            if ("Full 18".equals(courseName)) {
                return Golf.createA1();
            }
            if ("Front 9".equals(courseName)) {
                return Golf.createA2();
            }
            if ("Back 9".equals(courseName)) {
                return Golf.createA3();
            }
        } else if ("Fork South".equals(locationName) && "Executive 9".equals(courseName)) {
            return Golf.createB1();
        }
        return null;
    }

    private static GolfCourse createB1() {
        GolfCourse course = new GolfCourse("Fork South", "Executive 9");
        course.addHole(1, 120, 3, "4SS.png");
        course.addHole(2, 155, 3, "4L.png");
        course.addHole(3, 175, 3, "4SW.png");
        course.addHole(4, 115, 3, "4R.png");
        course.addHole(5, 125, 3, "4LS.png");
        course.addHole(6, 180, 3, "4S.png");
        course.addHole(7, 140, 3, "4RW.png");
        course.addHole(8, 120, 3, "4L.png");
        course.addHole(9, 165, 3, "4S.png");
        return course;
    }

    private static GolfCourse createA3() {
        GolfCourse course = new GolfCourse("Spoon North", "Back 9");
        course.addHole(10, 340, 4, "4S.png");
        course.addHole(11, 155, 3, "4LW.png");
        course.addHole(12, 505, 5, "4R.png");
        course.addHole(13, 355, 4, "4SS.png");
        course.addHole(14, 325, 4, "4LW.png");
        course.addHole(15, 610, 5, "4S.png");
        course.addHole(16, 140, 3, "4RS.png");
        course.addHole(17, 320, 4, "4L.png");
        course.addHole(18, 365, 4, "4RW.png");
        return course;
    }

    private static GolfCourse createA2() {
        GolfCourse course = new GolfCourse("Spoon North", "Front 9");
        course.addHole(1, 350, 4, "4LS.png");
        course.addHole(2, 390, 4, "4R.png");
        course.addHole(3, 210, 3, "4LW.png");
        course.addHole(4, 345, 4, "4R.png");
        course.addHole(5, 550, 5, "4SS.png");
        course.addHole(6, 170, 3, "4L.png");
        course.addHole(7, 330, 4, "4RW.png");
        course.addHole(8, 410, 4, "4S.png");
        course.addHole(9, 575, 5, "4LS.png");
        return course;
    }

    private static GolfCourse createA1() {
        GolfCourse course = new GolfCourse("Spoon North", "Full 18");
        course.addHole(1, 350, 4, "4LS.png");
        course.addHole(2, 390, 4, "4R.png");
        course.addHole(3, 210, 3, "4LW.png");
        course.addHole(4, 345, 4, "4R.png");
        course.addHole(5, 550, 5, "4SS.png");
        course.addHole(6, 170, 3, "4L.png");
        course.addHole(7, 330, 4, "4RW.png");
        course.addHole(8, 410, 4, "4S.png");
        course.addHole(9, 575, 5, "4LS.png");
        course.addHole(10, 340, 4, "4S.png");
        course.addHole(11, 155, 3, "4LW.png");
        course.addHole(12, 505, 5, "4R.png");
        course.addHole(13, 355, 4, "4SS.png");
        course.addHole(14, 325, 4, "4LW.png");
        course.addHole(15, 610, 5, "4S.png");
        course.addHole(16, 140, 3, "4RS.png");
        course.addHole(17, 320, 4, "4L.png");
        course.addHole(18, 365, 4, "4RW.png");
        return course;
    }
}

