/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.lcdui;

import com.ibm.weme.examples.golftracker.Golf;
import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.lcdui.HoleView;
import com.ibm.weme.examples.golftracker.lcdui.IView;
import com.ibm.weme.examples.golftracker.lcdui.IViewManager;
import com.ibm.weme.examples.golftracker.lcdui.MapView;
import com.ibm.weme.examples.golftracker.lcdui.StartView;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public final class GolfScoreTracker
extends MIDlet
implements IViewManager {
    private IGolfGame game;
    private IView[] views = new IView[3];

    protected final void destroyApp(boolean flag) throws MIDletStateChangeException {
        this.cleanup();
    }

    protected final void pauseApp() {
    }

    protected final void startApp() throws MIDletStateChangeException {
        this.buildViews();
        if (this.loadExistingGame()) {
            this.showView(1);
        } else {
            this.showView(0);
        }
    }

    public final void showView(int viewIndex) {
        Display display = Display.getDisplay((MIDlet)this);
        IView view = this.views[viewIndex];
        display.setCurrent((Displayable)view.getForm());
    }

    public final IGolfGame getGame() {
        return this.game;
    }

    public final void setGame(IGolfGame game) {
        this.game = game;
    }

    public final void saveGame() {
        try {
            RecordStore.deleteRecordStore((String)"Golf Tracker Game");
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            RecordStore storage = RecordStore.openRecordStore((String)"Golf Tracker Game", (boolean)true);
            byte[] record = this.game.getStorage();
            storage.addRecord(record, 0, record.length);
            storage.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void exitGame() {
        this.cleanup();
        this.notifyDestroyed();
    }

    private final void buildViews() {
        this.views[0] = new StartView(this);
        this.views[1] = new HoleView(this);
        this.views[2] = new MapView(this);
    }

    private final boolean loadExistingGame() {
        try {
            RecordStore storage = RecordStore.openRecordStore((String)"Golf Tracker Game", (boolean)false);
            byte[] record = storage.getRecord(1);
            this.game = Golf.newGame(record);
            storage.closeRecordStore();
            return true;
        }
        catch (RecordStoreFullException recordStoreFullException) {
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private final void cleanup() {
        this.game = null;
        if (this.views != null) {
            int i = 0;
            while (i < this.views.length) {
                if (this.views[i] != null) {
                    this.views[i].cleanup();
                    this.views[i] = null;
                }
                ++i;
            }
        }
    }
}

