/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.weme.examples.golftracker.model;

import com.ibm.weme.examples.golftracker.Golf;
import com.ibm.weme.examples.golftracker.IGolfGame;
import com.ibm.weme.examples.golftracker.IGolfHole;
import com.ibm.weme.examples.golftracker.model.GolfCourse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public final class GolfGame
implements IGolfGame {
    private int currentHoleIndex;
    private Date date;
    private GolfCourse course;

    public GolfGame(String locationName, String courseName, Date date) {
        this.course = Golf.getCourse(locationName, courseName);
        this.date = date;
        this.currentHoleIndex = 0;
    }

    public GolfGame(byte[] record) throws IOException {
        this.readStorage(record);
    }

    public final IGolfHole getCurrentHole() {
        return this.course.getHole(this.currentHoleIndex);
    }

    public final IGolfHole nextHole() {
        IGolfHole current = this.getCurrentHole();
        if (current.hasNext()) {
            ++this.currentHoleIndex;
            return this.getCurrentHole();
        }
        return current;
    }

    public final IGolfHole previousHole() {
        IGolfHole current = this.getCurrentHole();
        if (current.hasPrevious()) {
            --this.currentHoleIndex;
            return this.getCurrentHole();
        }
        return current;
    }

    public final int getHolesPlayed() {
        int total = 0;
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            if (hole.hasScore()) {
                ++total;
            }
            ++i;
        }
        return total;
    }

    public final int getProjectedRelativeScore() {
        int soFar = this.getTotalRelativeScore();
        int played = this.getHolesPlayed();
        int total = this.course.getHoleCount();
        return (soFar * total + played / 2) / played;
    }

    public final int getProjectedTotalScore() {
        return this.getProjectedRelativeScore() + this.getTotalPar();
    }

    public final int getTotalPar() {
        int total = 0;
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            total += hole.getPar();
            ++i;
        }
        return total;
    }

    public final int getTotalScore() {
        int total = 0;
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            total += hole.getScore();
            ++i;
        }
        return total;
    }

    public final int getTotalRelativeScore() {
        int total = 0;
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            if (hole.hasScore()) {
                total += hole.getRelativeScore();
            }
            ++i;
        }
        return total;
    }

    public final byte[] getStorage() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        out.writeLong(this.date.getTime());
        out.writeUTF(this.course.getLocationName());
        out.writeUTF(this.course.getCourseName());
        out.writeInt(this.currentHoleIndex);
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            out.writeInt(hole.getScore());
            ++i;
        }
        return stream.toByteArray();
    }

    private final void readStorage(byte[] storage) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(storage);
        DataInputStream in = new DataInputStream(stream);
        this.date = new Date(in.readLong());
        String locationName = in.readUTF();
        String courseName = in.readUTF();
        this.course = Golf.getCourse(locationName, courseName);
        this.currentHoleIndex = in.readInt();
        int i = 0;
        while (i < this.course.getHoleCount()) {
            IGolfHole hole = this.course.getHole(i);
            hole.setScore(in.readInt());
            ++i;
        }
    }
}

