/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is PlainOldFavorites Mozilla Extension and Engine.
 * The Initial Developer of the Original Code is Alex Sirota <alex@elbrus.com>. 
 * Portions created by Alex Sirota are Copyright (C) 2005 Alex Sirota. 
 * All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const POF_FAVORITE        = Components.interfaces.IPlainOldFavoritesItem.POF_FAVORITE;
const POF_FOLDER          = Components.interfaces.IPlainOldFavoritesItem.POF_FOLDER;
const POF_GENERIC_FILE    = Components.interfaces.IPlainOldFavoritesItem.POF_GENERIC_FILE;
const POF_FOLDER_SHORTCUT = Components.interfaces.IPlainOldFavoritesItem.POF_FOLDER_SHORTCUT;

const POF_MAIN_MENU_POPUP_IDS =  ['pof-main-menupopup', 'pof-toolbar-menupopup', 'pof-navbar-menupopup', 'pof-appmenu-menupopup'];

function PofUI() {
}

PofUI.prototype = {
  addElementFromTemplate : function(parentElem, elementId) {
    var elem = document.getElementById(elementId).cloneNode(false);
    elem.removeAttribute('id');
    elem.setAttribute('hidden', 'false');
    parentElem.appendChild(elem);
  }, 

  addElementsFromTemplate : function(parentElem, elementIds) {
    for (var i=0; i < elementIds.length; i++) {
        this.addElementFromTemplate(parentElem, elementIds[i]);
    }
  }, 


  populateMenu : function (event) {
    var menupopup = event.target;

    // remove all children
    while (menupopup.firstChild) {
        menupopup.removeChild(menupopup.firstChild);
    }

    var bIsMainMenu = false;

    for (var i=0; i < POF_MAIN_MENU_POPUP_IDS.length; i++) {
        var id = POF_MAIN_MENU_POPUP_IDS[i];
        if (menupopup.id == id) {
              bIsMainMenu = true;
              break;
        }
    }
    // add two menu items to the main menupopup    
    if (bIsMainMenu) {
        const mainControlElements = ['pof-add-to-favorites-menuitem-template',
                                     'pof-organize-favorites-menuitem-template',
                                     'pof-menuseparator-template'];
        this.addElementsFromTemplate(menupopup, mainControlElements);
    }

    var nFavoritesAdded = 0;
    var nItemsAdded = 0;
    var contents = this.pofService.getFavoritesFolderEntries(menupopup.value);
    for (var i=0; i < contents.length; i++) {
        var item = contents.queryElementAt(i, Components.interfaces.IPlainOldFavoritesItem);

        switch (item.type) {
            case POF_FAVORITE: 
                var menuitemElem = document.createElement('menuitem');
                menuitemElem.setAttribute('class', 'menuitem-iconic bookmark-item');
                menuitemElem.setAttribute('statustext', item.url);
                menuitemElem.setAttribute('label', item.name);
                menuitemElem.setAttribute('oncommand', 'gPofUI.openOneFavorite(event)');
                menuitemElem.setAttribute('onclick', 'gPofUI.onFavoriteMiddleClick(event)');
                menuitemElem.setAttribute('ondraggesture', 
                						"nsDragAndDrop.startDrag(event, pofDragStartObserver)");
                menuitemElem.setAttribute('context', 'pof-favorite-context-menu');
                menuitemElem.setAttribute('favorite', 'yes');
                menuitemElem.value = item.url;
                menuitemElem.file = item.file;
                if (item.iconUrl) {
                    menuitemElem.setAttribute('image', item.iconUrl);
                }
                menupopup.appendChild(menuitemElem);
                nFavoritesAdded++;
                nItemsAdded++;
                break;

            case POF_FOLDER_SHORTCUT:
            case POF_FOLDER:
                // regular favorites folder 
                var menuElem = document.createElement('menu');
                menuElem.setAttribute('container', 'true');
                menuElem.setAttribute('class', 'menu-iconic bookmark-item');
                menuElem.setAttribute('type', 'http://home.netscape.com/NC-rdf#Folder');
                menuElem.setAttribute('label', item.name);
                menuElem.setAttribute('context', 'pof-folder-context-menu');
                menuElem.setAttribute('statustext', item.file.path);
                if (item.type == POF_FOLDER_SHORTCUT) {
                    menuElem.setAttribute('image', item.iconUrl);
                }
                menuElem.file = item.file;

                var menupopupElem = document.createElement('menupopup');
                menupopupElem.setAttribute('onpopupshowing', 'return gPofUI.populateMenu(event)');
                menupopupElem.value = item.file;
                menuElem.appendChild(menupopupElem);
            
                menupopup.appendChild(menuElem);
                nItemsAdded++;
                break;

            case POF_GENERIC_FILE:
                item.file = item.file.QueryInterface(Components.interfaces.nsILocalFile);
                var name = item.file.isSymlink() ? item.name.substring(0, item.name.length - 4) : item.name;
                var menuitemElem = document.createElement('menuitem');
                menuitemElem.setAttribute('label', name);
                if (item.file.isSymlink()) {
                    item.file.followLinks = true;
                    menuitemElem.setAttribute('statustext', item.file.target);
                } else {
                    menuitemElem.setAttribute('statustext', item.file.path);
                }
                menuitemElem.setAttribute('class', 'menuitem-iconic bookmark-item');
                menuitemElem.setAttribute('container', 'true');
                menuitemElem.setAttribute('oncommand', 'gPofUI.shellOpenFile(event)');
                menuitemElem.setAttribute('context', 'pof-file-context-menu');
                if (item.iconUrl) {
                    menuitemElem.setAttribute('image', item.iconUrl);
                }
                menuitemElem.value = item.file;
                menuitemElem.file = item.file;
                menupopup.appendChild(menuitemElem);
                nItemsAdded++;
                break;

            default:
                dump("POF Warning: unknown icon type: " + item.type + "\n");
        }
    }

    if (nItemsAdded == 0) {
        const emptyElement = ['pof-empty-menuitem-template'];
        this.addElementsFromTemplate(menupopup, emptyElement); 
    }

    if ((nFavoritesAdded > 1) && !bIsMainMenu) {
        const openInTabsElements = ['pof-menuseparator-template',
                                    'pof-open-in-tabs-menuitem-template'];
        this.addElementsFromTemplate(menupopup, openInTabsElements); 
    }

    event.stopPropagation();
    return true;
  },

  openAddToFavoritesDialog: function() {
    var currentBrowser = (gBrowser.browsers.length > 1) ? 
                                gBrowser.selectedBrowser : 
                                gBrowser;

    var webNavigation = currentBrowser.webNavigation;
    var url = webNavigation.currentURI.spec;
    var name = '';
    try {
      var doc = webNavigation.document;
      name = doc.title || url;
    } catch (e) {
      name = url;
    }

    // make the name legal
    name = name.replace(/[\/]/g, "-");	
    name = name.replace(/[\\:*?\"<>|]/g, " ");	

    var iconUrl = gBrowser.selectedBrowser.mFavIconURL ? gBrowser.selectedBrowser.mFavIconURL : gBrowser.selectedBrowser.mIconURL;
    this.pofEngine.openAddToFavoritesDialog(this.getTopLevelWindow(), name, url, iconUrl);
  },

  openOrganizeFavoritesDialog : function() {
    this.pofEngine.openOrganizeFavoritesDialog(this.getTopLevelWindow());
  },

  getTopLevelWindow : function() {
    var topLevelWindow = null;
    try {
        topLevelWindow = window.QueryInterface(Components.interfaces.nsIInterfaceRequestor).
                 getInterface(Components.interfaces.nsIWebNavigation).
                 QueryInterface(Components.interfaces.nsIDocShellTreeItem).
                 treeOwner.
                 QueryInterface(Components.interfaces.nsIInterfaceRequestor).
                 getInterface(Components.interfaces.nsIXULWindow).
                 docShell.
                 QueryInterface(Components.interfaces.nsIDocShell).
                 QueryInterface(Components.interfaces.nsIBaseWindow);
    } catch (e) {
    }
    return topLevelWindow;
  },

  onFavoriteMiddleClick : function(event) {
      if (event.button != 1) return;
      this.hidePopupMenus(event);
      this.openOneFavorite(event);
  },

  hidePopupMenus : function(event) {
     try {
       event.target.parentNode.hidePopup();
     } catch(e) {}
     try {
       var popupElem = document.popupNode;
       popupElem.parentNode.hidePopup();
     } catch(e) {}
     for (var i=0; i < POF_MAIN_MENU_POPUP_IDS.length; i++) {
        var id = POF_MAIN_MENU_POPUP_IDS[i];
        try {
            // make sure the main popup is also down:
            document.getElementById(id).hidePopup();
        } catch(e) {}
     }
  },

  getURLAndHandlePopupMenu : function(event) {
     var url;
     url = event.target.value; 
     if (!url) {
        // we came here from the context menu
        var popupElem = document.popupNode;
        this.hidePopupMenus(event);
        url = popupElem.value;
     }
     return url;
  },

  openCotnainingFolder : function(event) {
     var popupElem = document.popupNode;
     this.hidePopupMenus(event);
     var file = popupElem.file;
     file.parent.QueryInterface(Components.interfaces.nsILocalFile).launch();
  },

  deleteFavorite : function(event) {
    // assume that we were called from the context menu
     var popupElem = document.popupNode;
     this.hidePopupMenus(event);
     var file = popupElem.file;
     file.remove(false);
  },

  openFavoriteProperties : function(event) {
    // assume that we were called from the context menu
     var popupElem = document.popupNode;
     this.hidePopupMenus(event);
     var file = popupElem.file;
     this.pofEngine.openPropertiesDialog(file.path);
  },

  openOneFavoriteIn : function(event, where) {
     var url = this.getURLAndHandlePopupMenu(event);
     openUILinkIn(url, where);
  },

  shellOpenFileFromContextMenu : function(event) {
     var popupElem = document.popupNode;
     this.hidePopupMenus(event);
     var file = popupElem.file.QueryInterface(Components.interfaces.nsILocalFile);
     file.launch(); 
  },

  shellOpenFile : function(event) {
     var file = event.target.value.QueryInterface(Components.interfaces.nsILocalFile);
     file.launch(); 
  },

  openOneFavorite : function(event) {
     var url = this.getURLAndHandlePopupMenu(event);
     openUILink(url, event);
  },

  openGroupOfFavorites : function(event) {
     var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefBranch);
     var globalPrefs = typeof PREF != 'undefined' ? PREF : prefService;

     // based partially on openGroupBookmark (bookmarks.js)
     var w        = getTopWin();
     var browser  = w.document.getElementById("content");
     var tabPanels = browser.browsers;
     var tabCount  = tabPanels.length;
     //var doReplace = globalPrefs.getBoolPref("browser.tabs.loadFolderAndReplace");
     // in order to follow firefox 3 behavior more closely, don't ever replace
     var doReplace = false;
     var loadInBackground = globalPrefs.getBoolPref("browser.tabs.loadBookmarksInBackground");

     var index0;
     if (doReplace) {
        index0 = 0;
     } else {
        for (index0=tabCount-1; index0>=0; --index0) {
          if (browser.browsers[index0].webNavigation.currentURI.spec != "about:blank") {
            break;
          }
        }
        ++index0;
     }

     var index  = index0;
     var parentMenuPopupElem = event.target.parentNode;
     var favorites = parentMenuPopupElem.childNodes;
     for (var i=0; i < favorites.length - 2; i++) {
          if (!favorites[i].hasAttribute('favorite')) {
                continue;
          }
          var uri = favorites[i].value;
          if (!uri) {
               continue;
          }
          if (index < tabCount) {
            tabPanels[index].loadURI(uri);
          } else {
            browser.addTab(uri);
          }

          ++index;
     }

     if (index == index0) {
        return;
     }

    if (!loadInBackground || doReplace) {
        var tabs = browser.mTabContainer.childNodes;
        browser.selectedTab = tabs[index0];
    }

    for (var i = tabCount-1; i >= index; --i) {
        browser.removeTab(tabs[i]);
    }

    browser.focus();
  },

  moveMainMenuIntoBookmarks : function() {
    var pofMainMenu = document.getElementById('pof-menu');
    var bookmarksPopup = document.getElementById('menu_BookmarksPopup');
    pofMainMenu.parentNode.removeChild(pofMainMenu);
    bookmarksPopup.insertBefore(pofMainMenu, bookmarksPopup.firstChild.nextSibling.nextSibling.nextSibling);
    var separator = document.createElement('menuseparator');
    bookmarksPopup.insertBefore(separator, pofMainMenu.nextSibling);
  },

  addBookmarksObserver : function () {
    var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"]
							.getService(Components.interfaces.nsIRDFService);
    var dataSource = rdfService.GetDataSource( "rdf:bookmarks" ).
                        QueryInterface(Components.interfaces.nsIRDFDataSource);
    dataSource.AddObserver(pofBookmarksObserver);
  }, 

  toggleSortByName : function(event) {
        this.hidePopupMenus(event);
        this.bSortByName = !this.bSortByName;
        this.prefBranch.setBoolPref("sort_by_name", this.bSortByName);
  },

  getSortByName : function() {
        this.bSortByName = false;
        try {
          this.bSortByName = this.prefBranch.getBoolPref("sort_by_name");
        } catch(e) { } 
        document.getElementById('pof-sort-by-name-enabled').setAttribute('checked', this.bSortByName);
        return this.bSortByName;
  },

  hideBookmarksMenuIfNeeded : function() {
        var bHide = false;
        try {
          bHide = this.prefBranch.getBoolPref("hide_bookmarks_menu");
        } catch(e) { } 

        var ids = ['bookmarks-menu', 'bookmarksMenu', 'bookmarks-menu-button'];
        for (var i=0; i < ids.length; i++) {
            var elem = document.getElementById(ids[i]);
            if (elem) {
                if (!bHide) {
                    elem.className = elem.className.replace(/hidden-by-pof/, '');
                } else {
                    if (!elem.className.match(/hidden-by-pof/)) {
                        elem.className += ' hidden-by-pof';
                    }
                }
            }
        }
  },

  hideToolbarMenubuttonfromNavBarIfNeeded : function() {
        var personalToolbarElem = document.getElementById('PersonalToolbar');
        var pofNavBarButton = document.getElementById('pof-toolbar-menu-navbar');
        if (!personalToolbarElem || !pofNavBarButton) return;

        pofNavBarButton.collapsed = !personalToolbarElem.collapsed;
  },

  observe : function(aSubject, aTopic, aData) {
        if (aTopic == "nsPref:changed") {
             this.getSortByName();
             this.hideBookmarksMenuIfNeeded();
        }
  },

  init : function() {
    // 'this' is ChromeWindow
    var me = gPofUI;
    me.pofService = Components.classes["@iosart.com/favorites/PlainOldFavoritesService;1"].
                                        getService(Components.interfaces.IPlainOldFavoritesService);
    me.pofEngine = me.pofService.getEngine();

    var favoritesFolder = me.pofService.getFavoritesFolder();
    for (var i=0; i < POF_MAIN_MENU_POPUP_IDS.length; i++) {
        var id = POF_MAIN_MENU_POPUP_IDS[i];
        var pofMainMenuPopupElem = document.getElementById(id);
        if (pofMainMenuPopupElem) {
            pofMainMenuPopupElem.value = favoritesFolder;
        }
    }

    me.prefService = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefService);
    me.prefBranch = me.prefService.getBranch("plainoldfavorites."); 

    me.prefBranchInternal = me.prefBranch.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
    me.prefBranchInternal.addObserver("", me, false); 

    var bPlaceInBookmarks = false;
    try {
         bPlaceInBookmarks = me.prefBranch.getBoolPref("place_in_bookmarks");
    } catch (err) {
         me.prefBranch.setBoolPref("place_in_bookmarks", false);
    }

    if (bPlaceInBookmarks) {
        me.moveMainMenuIntoBookmarks();
    }

    me.bSortByName = me.getSortByName();
    me.hideBookmarksMenuIfNeeded();

    me.hideToolbarMenubuttonfromNavBarIfNeeded();
    var personalToolbarElem = document.getElementById('PersonalToolbar');
    if (personalToolbarElem) {
         personalToolbarElem.addEventListener("DOMAttrModified", function(event) { if (event.attrName == 'collapsed') me.hideToolbarMenubuttonfromNavBarIfNeeded() }, false); 
    }

  }
    
}

var pofBookmarksObserver = {
    onAssert : function(dataSource, source, property, target) {},
    onUnassert : function(dataSource, source, property, target) { },
    onChange : function (dataSource, source, property, oldTarget, newTarget) { },
    onMove 	:function (dataSource , oldSource , newSource , property , target ) {},
    onBeginUpdateBatch 	:function (dataSource) {},
    onEndUpdateBatch 	:function ( dataSource) {},
}

var pofDragStartObserver =
{
  onDragStart: function (event, transferData, action) {
    if (navigator.platform != "Win32") {
      return;
    }

    var favoriteItem = event.target;
    var url = favoriteItem.value;
    var name = favoriteItem.getAttribute('label');

	transferData.data = new TransferData();
    transferData.data.addDataForFlavour("text/x-moz-url", url + "\n" + name);
    transferData.data.addDataForFlavour("text/html", "<A HREF='" + url + "'>" + name + "</A>");
	transferData.data.addDataForFlavour("text/unicode", event.target.value);
  }
}


var gPofUI = new PofUI();
addEventListener("load", gPofUI.init, false);
