/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.CropCard;
import ic2.api.TECrop;
import ic2.common.IC2Crops;
import ic2.common.Ic2Items;
import ic2.common.TileEntityCrop;

public class CropTerraWart
extends CropCard {
    @Override
    public String name() {
        return "Terra Wart";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Blue", "Aether", "Consumable", "Snow"};
    }

    @Override
    public int getSpriteIndex(TECrop crop) {
        if (crop.size == 1) {
            return 37;
        }
        return crop.size + 38;
    }

    @Override
    public boolean canGrow(TECrop crop) {
        return crop.size < 3;
    }

    @Override
    public boolean canBeHarvested(TECrop crop) {
        return crop.size == 3;
    }

    @Override
    public float dropGainChance() {
        return 0.8f;
    }

    @Override
    public aan getGain(TECrop crop) {
        return new aan(Ic2Items.terraWart.a(), 1);
    }

    @Override
    public void tick(TECrop crop) {
        TileEntityCrop te = (TileEntityCrop)crop;
        if (te.isBlockBelow(pb.aU)) {
            if (this.canGrow(te)) {
                te.growthPoints = (int)((double)te.growthPoints + (double)te.calcGrowthRate() * 0.5);
            }
        } else if (te.isBlockBelow(pb.bc) && crop.i.r.nextInt(300) == 0) {
            te.id = (short)IC2Crops.cropNetherWart.getId();
        }
    }
}

