/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ISidedInventory;
import ic2.api.Direction;
import ic2.common.ContainerIC2;
import ic2.common.ContainerInduction;
import ic2.common.IHasGui;
import ic2.common.TileEntityElecMachine;
import ic2.platform.Platform;

public class TileEntityInduction
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int soundTicker = mod_IC2.random.nextInt(64);
    public static short maxHeat = (short)10000;
    public short heat = 0;
    public short progress = 0;
    private static final int inputSlot = 0;
    private static final int fuelSlot = 2;
    private static final int outputSlot = 3;

    public TileEntityInduction() {
        super(5, 2, maxHeat, 128, 2);
    }

    @Override
    public String c() {
        if (Platform.isRendering()) {
            return "Induction Furnace";
        }
        return "InductionFurnace";
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.heat = nbttagcompound.e("heat");
        this.progress = nbttagcompound.e("progress");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("progress", this.progress);
    }

    public String getHeat() {
        return "" + this.heat * 100 / maxHeat + "%";
    }

    public int gaugeProgressScaled(int i) {
        return i * this.progress / 4000;
    }

    public int gaugeFuelScaled(int i) {
        return i * this.energy / this.maxEnergy;
    }

    @Override
    public void n_() {
        super.n_();
        boolean needsInvUpdate = false;
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.heat == 0) {
            newActive = false;
        }
        if (this.progress >= 4000) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
        }
        boolean canOperate = this.canOperate();
        if (this.energy > 0 && (canOperate || this.isRedstonePowered())) {
            --this.energy;
            if (this.heat < maxHeat) {
                this.heat = (short)(this.heat + 1);
            }
            newActive = true;
        } else {
            this.heat = (short)(this.heat - Math.min(this.heat, 4));
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= 15) {
                    newActive = true;
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < 15) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive && canOperate) {
            this.progress = (short)(this.progress + this.heat / 30);
            this.energy -= 15;
        }
        if (needsInvUpdate) {
            this.j();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate() {
        this.operate(0, 3);
        this.operate(1, 4);
    }

    public void operate(int input, int output) {
        if (!this.canOperate(input, output)) {
            return;
        }
        aan itemstack = this.getResultFor(this.inventory[input]);
        if (this.inventory[output] == null) {
            this.inventory[output] = itemstack.k();
        } else {
            this.inventory[output].a += itemstack.a;
        }
        if (this.inventory[input].a().m()) {
            this.inventory[input] = new aan(this.inventory[input].a().l());
        } else {
            --this.inventory[input].a;
        }
        if (this.inventory[input].a <= 0) {
            this.inventory[input] = null;
        }
    }

    public boolean canOperate() {
        return this.canOperate(0, 3) || this.canOperate(1, 4);
    }

    public boolean canOperate(int input, int output) {
        if (this.inventory[input] == null) {
            return false;
        }
        aan itemstack = this.getResultFor(this.inventory[input]);
        if (itemstack == null) {
            return false;
        }
        return this.inventory[output] == null || this.inventory[output].a(itemstack) && this.inventory[output].a + itemstack.a <= itemstack.c();
    }

    public aan getResultFor(aan itemstack) {
        return dy.a().getSmeltingResult(itemstack);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > 128) {
            mod_IC2.explodeMachineAt(this.i, this.j, this.k, this.l);
            return 0;
        }
        this.energy += amount;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerInduction(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiInduction";
    }

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return 3;
    }

    public int getSizeInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }
}

