/*
 * Decompiled with CFR 0.152.
 */
public class SettingFloat
extends Setting {
    public float maximumValue;
    public float minimumValue;
    public float stepValue;

    public SettingFloat(String title) {
        this(title, 0.0f, 0.0f, 0.1f, 1.0f);
    }

    public SettingFloat(String title, float defValue) {
        this(title, defValue, 0.0f, 0.1f, 1.0f);
    }

    public SettingFloat(String title, float defValue, float minValue, float maxValue) {
        this(title, defValue, minValue, 0.1f, maxValue);
    }

    public SettingFloat(String title, float defValue, float minValue, float stepValue, float maxValue) {
        this.values.put("", Float.valueOf(defValue));
        this.defaultValue = Float.valueOf(defValue);
        this.minimumValue = minValue;
        this.stepValue = stepValue;
        this.maximumValue = maxValue;
        this.backendName = title;
        if (this.minimumValue > this.maximumValue) {
            float t = this.minimumValue;
            this.minimumValue = this.maximumValue;
            this.maximumValue = t;
        }
    }

    @Override
    public void fromString(String s, String context) {
        this.values.put(context, new Float(s));
        if (this.displayWidget != null) {
            this.displayWidget.update();
        }
    }

    @Override
    public Float get(String context) {
        if (this.values.get(context) != null) {
            return (Float)this.values.get(context);
        }
        if (this.values.get("") != null) {
            return (Float)this.values.get("");
        }
        return (Float)this.defaultValue;
    }

    public void set(Float v, String context) {
        if (this.stepValue > 0.0f) {
            this.values.put(context, Float.valueOf((float)Math.round(v.floatValue() / this.stepValue) * this.stepValue));
        } else {
            this.values.put(context, v);
        }
        if (this.parent != null) {
            this.parent.save(context);
        }
        if (this.displayWidget != null) {
            this.displayWidget.update();
        }
    }

    @Override
    public String toString(String context) {
        return "" + this.get(context);
    }
}

