/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SettingList
extends Setting {
    public SettingList(String title) {
        this(title, new ArrayList());
    }

    public SettingList(String title, ArrayList defaultvalue) {
        this.backendName = title;
        this.defaultValue = defaultvalue;
        this.values.put("", defaultvalue);
    }

    @Override
    public void fromString(String s, String context) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            DocumentBuilderFactory builderFact = DocumentBuilderFactory.newInstance();
            builderFact.setIgnoringElementContentWhitespace(true);
            builderFact.setValidating(true);
            builderFact.setCoalescing(true);
            builderFact.setIgnoringComments(true);
            DocumentBuilder docBuilder = builderFact.newDocumentBuilder();
            Document doc = docBuilder.parse(s);
            Element localElement = (Element)doc.getChildNodes().item(1);
            NodeList localNodeList = localElement.getChildNodes();
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                String val = localNodeList.item(i).getNodeValue();
                list.add(val);
            }
            this.values.put(context, list);
            if (this.displayWidget != null) {
                this.displayWidget.update();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    public ArrayList get(String context) {
        if (this.values.get(context) != null) {
            return (ArrayList)this.values.get(context);
        }
        if (this.values.get("") != null) {
            return (ArrayList)this.values.get("");
        }
        return (ArrayList)this.defaultValue;
    }

    public void set(ArrayList v, String context) {
        this.values.put(context, v);
        if (this.parent != null) {
            this.parent.save(context);
        }
        if (this.displayWidget != null) {
            this.displayWidget.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(String context) {
        try {
            ArrayList prop;
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element baseElement = (Element)doc.appendChild(doc.createElement("list"));
            ArrayList arrayList = prop = this.get(context);
            synchronized (arrayList) {
                for (String str : prop) {
                    baseElement.appendChild(doc.createTextNode(str));
                }
            }
            TransformerFactory localTransformerFactory = TransformerFactory.newInstance();
            Transformer localTransformer = null;
            localTransformer = localTransformerFactory.newTransformer();
            localTransformer.setOutputProperty("method", "xml");
            localTransformer.setOutputProperty("encoding", "UTF8");
            DOMSource localDOMSource = new DOMSource(doc);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult localStreamResult = new StreamResult(output);
            localTransformer.transform(localDOMSource, localStreamResult);
            return output.toString("UTF-8");
        }
        catch (Throwable e) {
            ModSettings.dbgout("Error writing SettingList from context '" + context + "': " + e);
            return "";
        }
    }
}

