/*
 * Decompiled with CFR 0.152.
 */
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WidgetTick
extends Widget
implements IWidgetAlwaysDraw {
    protected ArrayList ticks = new ArrayList();

    public WidgetTick() {
        this.setMaxSize(0, 0);
    }

    public FrameTick addCallback(Runnable callback) {
        FrameTick tick = new FrameTick(callback);
        this.ticks.add(tick);
        return tick;
    }

    public DelayTick addCallback(Runnable callback, int timepertick) {
        DelayTick tick = new DelayTick(callback, timepertick);
        this.ticks.add(tick);
        return tick;
    }

    public boolean addCustomTick(iTick tick) {
        return this.ticks.add(tick);
    }

    public SingleTick addTimedCallback(Runnable callback, int delay) {
        SingleTick tick = new SingleTick(callback, delay);
        this.ticks.add(tick);
        return tick;
    }

    public List getTickArrayCopy() {
        return Collections.unmodifiableList(this.ticks);
    }

    @Override
    protected void paintWidget(GUI gui) {
        iTick tick;
        int i;
        iTick[] removedTicks = new iTick[this.ticks.size()];
        for (i = 0; i < this.ticks.size(); ++i) {
            tick = (iTick)this.ticks.get(i);
            try {
                tick.checkTick();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error when calling tick " + tick + " at position " + i + " in WidgetTick.", e);
            }
            if (!tick.shouldRemove()) continue;
            removedTicks[i] = tick;
        }
        for (i = 0; i < removedTicks.length; ++i) {
            tick = removedTicks[i];
            if (tick == null) continue;
            this.ticks.remove(tick);
        }
    }

    public class SingleTick
    implements iTick {
        int delayBeforeRemove;
        Runnable tickCallback;
        long timeToTick;

        public SingleTick(Runnable callback, int delay) {
            if (callback == null) {
                throw new IllegalArgumentException("Callback cannot be null.");
            }
            if (delay < 0) {
                throw new IllegalArgumentException("Delay must be 0 or higher.");
            }
            this.timeToTick = -1L;
            this.delayBeforeRemove = delay;
            this.tickCallback = callback;
        }

        @Override
        public void checkTick() {
            if (this.delayBeforeRemove == 0) {
                this.tickCallback.run();
            }
            if (this.timeToTick == -1L) {
                this.timeToTick = System.currentTimeMillis() + (long)this.delayBeforeRemove;
            } else if (this.timeToTick < System.currentTimeMillis()) {
                this.tickCallback.run();
            }
        }

        @Override
        public boolean shouldRemove() {
            if (this.delayBeforeRemove == 0) {
                return true;
            }
            return this.timeToTick < System.currentTimeMillis();
        }

        public String toString() {
            return "SingleTick [tickCallback=" + this.tickCallback + "]";
        }
    }

    public static interface iTick {
        public void checkTick();

        public boolean shouldRemove();
    }

    public class FrameTick
    implements iTick {
        boolean removeSelf = false;
        Runnable tickCallback;

        public FrameTick(Runnable callback) {
            if (callback == null) {
                throw new IllegalArgumentException("Callback cannot be null.");
            }
            this.tickCallback = callback;
        }

        @Override
        public void checkTick() {
            this.tickCallback.run();
        }

        public void removeSelf() {
            this.removeSelf = true;
        }

        @Override
        public boolean shouldRemove() {
            return this.removeSelf;
        }

        public String toString() {
            return "FrameTick [tickCallback=" + this.tickCallback + "]";
        }
    }

    public class DelayTick
    implements iTick {
        long lastTick;
        boolean removeSelf = false;
        Runnable tickCallback;
        long timeToTick;

        public DelayTick(Runnable callback, int delay) {
            if (callback == null) {
                throw new IllegalArgumentException("Callback cannot be null.");
            }
            if (delay < 0) {
                throw new IllegalArgumentException("Delay must be 0 or higher.");
            }
            this.lastTick = 0L;
            this.timeToTick = delay;
            this.tickCallback = callback;
        }

        @Override
        public void checkTick() {
            long millis = System.currentTimeMillis();
            if (this.lastTick + this.timeToTick < millis) {
                this.lastTick = millis;
                this.tickCallback.run();
            }
        }

        public void removeSelf() {
            this.removeSelf = true;
        }

        @Override
        public boolean shouldRemove() {
            return this.removeSelf;
        }
    }
}

