/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Container;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ValueAdjusterFloat;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractFloatModel;
import de.matthiasmann.twl.model.AbstractIntegerModel;
import de.matthiasmann.twl.model.ColorModel;
import de.matthiasmann.twl.model.ColorSpace;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.TintAnimator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class ColorSelector
extends DialogLayout {
    private static final String[] RGBA_NAMES = new String[]{"Red", "Green", "Blue", "Alpha"};
    private static final String[] RGBA_PREFIX = new String[]{"R: ", "G: ", "B: ", "A: "};
    final ByteBuffer imgData = ByteBuffer.allocateDirect(16384);
    final IntBuffer imgDataInt;
    ColorSpace colorSpace;
    float[] colorValues;
    ColorValueModel[] colorValueModels;
    private boolean useColorArea2D = true;
    private boolean showPreview = false;
    private boolean useLabels = true;
    private boolean showHexEditField = false;
    private boolean showNativeAdjuster = true;
    private boolean showRGBAdjuster = true;
    private boolean showAlphaAdjuster = true;
    private Runnable[] callbacks;
    private ColorModel model;
    private Runnable modelCallback;
    private boolean inModelSetValue;
    int currentColor;
    private ARGBModel[] argbModels;
    EditField hexColorEditField;
    private TintAnimator previewTintAnimator;
    private boolean recreateLayout;
    private static final int IMAGE_SIZE = 64;

    public ColorSelector(ColorSpace colorSpace) {
        this.imgData.order(ByteOrder.BIG_ENDIAN);
        this.imgDataInt = this.imgData.asIntBuffer();
        this.currentColor = Color.WHITE.toARGB();
        this.setColorSpace(colorSpace);
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace colorModel) {
        if (colorModel == null) {
            throw new NullPointerException("colorModel");
        }
        if (this.colorSpace != colorModel) {
            boolean hasColor = this.colorSpace != null;
            this.colorSpace = colorModel;
            this.colorValues = new float[colorModel.getNumComponents()];
            if (hasColor) {
                this.setColor(this.currentColor);
            } else {
                this.setDefaultColor();
            }
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public ColorModel getModel() {
        return this.model;
    }

    public void setModel(ColorModel model) {
        if (this.model != model) {
            this.removeModelCallback();
            this.model = model;
            if (model != null) {
                this.addModelCallback();
                this.modelValueChanged();
            }
        }
    }

    public Color getColor() {
        return new Color(this.currentColor);
    }

    public void setColor(Color color) {
        this.setColor(color.toARGB());
        this.updateModel();
    }

    public void setDefaultColor() {
        this.currentColor = Color.WHITE.toARGB();
        for (int i = 0; i < this.colorSpace.getNumComponents(); ++i) {
            this.colorValues[i] = this.colorSpace.getDefaultValue(i);
        }
        this.updateAllColorAreas();
        this.colorChanged();
    }

    public boolean isUseColorArea2D() {
        return this.useColorArea2D;
    }

    public void setUseColorArea2D(boolean useColorArea2D) {
        if (this.useColorArea2D != useColorArea2D) {
            this.useColorArea2D = useColorArea2D;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public void setShowPreview(boolean showPreview) {
        if (this.showPreview != showPreview) {
            this.showPreview = showPreview;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isShowHexEditField() {
        return this.showHexEditField;
    }

    public void setShowHexEditField(boolean showHexEditField) {
        if (this.showHexEditField != showHexEditField) {
            this.showHexEditField = showHexEditField;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isShowAlphaAdjuster() {
        return this.showAlphaAdjuster;
    }

    public void setShowAlphaAdjuster(boolean showAlphaAdjuster) {
        if (this.showAlphaAdjuster != showAlphaAdjuster) {
            this.showAlphaAdjuster = showAlphaAdjuster;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isShowNativeAdjuster() {
        return this.showNativeAdjuster;
    }

    public void setShowNativeAdjuster(boolean showNativeAdjuster) {
        if (this.showNativeAdjuster != showNativeAdjuster) {
            this.showNativeAdjuster = showNativeAdjuster;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isShowRGBAdjuster() {
        return this.showRGBAdjuster;
    }

    public void setShowRGBAdjuster(boolean showRGBAdjuster) {
        if (this.showRGBAdjuster != showRGBAdjuster) {
            this.showRGBAdjuster = showRGBAdjuster;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public boolean isUseLabels() {
        return this.useLabels;
    }

    public void setUseLabels(boolean useLabels) {
        if (this.useLabels != useLabels) {
            this.useLabels = useLabels;
            this.recreateLayout = true;
            this.invalidateLayout();
        }
    }

    public void addCallback(Runnable cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, Runnable.class);
    }

    public void removeCallback(Runnable cb) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModel() {
        if (this.model != null) {
            this.inModelSetValue = true;
            try {
                this.model.setValue(this.getColor());
            }
            finally {
                this.inModelSetValue = false;
            }
        }
    }

    protected void colorChanged() {
        this.currentColor = this.currentColor & 0xFF000000 | this.colorSpace.toRGB(this.colorValues);
        CallbackSupport.fireCallbacks(this.callbacks);
        this.updateModel();
        if (this.argbModels != null) {
            for (ARGBModel m : this.argbModels) {
                m.fireCallback();
            }
        }
        if (this.previewTintAnimator != null) {
            this.previewTintAnimator.setColor(this.getColor());
        }
        this.updateHexEditField();
    }

    protected void setColor(int argb) {
        this.currentColor = argb;
        this.colorValues = this.colorSpace.fromRGB(argb & 0xFFFFFF);
        this.updateAllColorAreas();
    }

    protected int getNumComponents() {
        return this.colorSpace.getNumComponents();
    }

    @Override
    public void layout() {
        if (this.recreateLayout) {
            this.createColorAreas();
        }
        super.layout();
    }

    @Override
    public int getMinWidth() {
        if (this.recreateLayout) {
            this.createColorAreas();
        }
        return super.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        if (this.recreateLayout) {
            this.createColorAreas();
        }
        return super.getMinHeight();
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.recreateLayout) {
            this.createColorAreas();
        }
        return super.getPreferredInnerWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.recreateLayout) {
            this.createColorAreas();
        }
        return super.getPreferredInnerHeight();
    }

    protected void createColorAreas() {
        ColorArea area;
        Label label;
        int component;
        int i;
        this.recreateLayout = false;
        this.setVerticalGroup(null);
        this.removeAllChildren();
        this.argbModels = new ARGBModel[4];
        this.argbModels[0] = new ARGBModel(16);
        this.argbModels[1] = new ARGBModel(8);
        this.argbModels[2] = new ARGBModel(0);
        this.argbModels[3] = new ARGBModel(24);
        int numComponents = this.getNumComponents();
        DialogLayout.Group horzAreas = this.createSequentialGroup().addGap();
        DialogLayout.Group vertAreas = this.createParallelGroup();
        DialogLayout.Group horzLabels = null;
        DialogLayout.Group horzAdjuster = this.createParallelGroup();
        DialogLayout.Group horzControlls = this.createSequentialGroup();
        if (this.useLabels) {
            horzLabels = this.createParallelGroup();
            horzControlls.addGroup(horzLabels);
        }
        horzControlls.addGroup(horzAdjuster);
        DialogLayout.Group[] vertAdjuster = new DialogLayout.Group[4 + numComponents];
        int numAdjuters = 0;
        for (i = 0; i < vertAdjuster.length; ++i) {
            vertAdjuster[i] = this.createParallelGroup();
        }
        this.colorValueModels = new ColorValueModel[numComponents];
        for (component = 0; component < numComponents; ++component) {
            this.colorValueModels[component] = new ColorValueModel(component);
            if (!this.showNativeAdjuster) continue;
            ValueAdjusterFloat vaf = new ValueAdjusterFloat(this.colorValueModels[component]);
            if (this.useLabels) {
                label = new Label(this.colorSpace.getComponentName(component));
                label.setLabelFor(vaf);
                horzLabels.addWidget(label);
                vertAdjuster[numAdjuters].addWidget(label);
            } else {
                vaf.setDisplayPrefix(this.colorSpace.getComponentShortName(component).concat(": "));
                vaf.setTooltipContent(this.colorSpace.getComponentName(component));
            }
            horzAdjuster.addWidget(vaf);
            vertAdjuster[numAdjuters].addWidget(vaf);
            ++numAdjuters;
        }
        for (i = 0; i < this.argbModels.length; ++i) {
            if ((i != 3 || !this.showAlphaAdjuster) && (i >= 3 || !this.showRGBAdjuster)) continue;
            ValueAdjusterInt vai = new ValueAdjusterInt(this.argbModels[i]);
            if (this.useLabels) {
                label = new Label(RGBA_NAMES[i]);
                label.setLabelFor(vai);
                horzLabels.addWidget(label);
                vertAdjuster[numAdjuters].addWidget(label);
            } else {
                vai.setDisplayPrefix(RGBA_PREFIX[i]);
                vai.setTooltipContent(RGBA_NAMES[i]);
            }
            horzAdjuster.addWidget(vai);
            vertAdjuster[numAdjuters].addWidget(vai);
            ++numAdjuters;
        }
        component = 0;
        if (this.useColorArea2D) {
            while (component + 1 < numComponents) {
                area = new ColorArea2D(component, component + 1);
                area.setTooltipContent(this.colorSpace.getComponentName(component) + " / " + this.colorSpace.getComponentName(component + 1));
                horzAreas.addWidget(area);
                vertAreas.addWidget(area);
                component += 2;
            }
        }
        while (component < numComponents) {
            area = new ColorArea1D(component);
            area.setTooltipContent(this.colorSpace.getComponentName(component));
            horzAreas.addWidget(area);
            vertAreas.addWidget(area);
            ++component;
        }
        if (this.showHexEditField && this.hexColorEditField == null) {
            this.createHexColorEditField();
        }
        if (this.showPreview) {
            if (this.previewTintAnimator == null) {
                this.previewTintAnimator = new TintAnimator(new TintAnimator.GUITimeSource(this), this.getColor());
            }
            Widget previewArea = new Widget();
            previewArea.setTheme("colorarea");
            previewArea.setTintAnimator(this.previewTintAnimator);
            Container preview = new Container();
            preview.setTheme("preview");
            preview.add(previewArea);
            Label label2 = new Label();
            label2.setTheme("previewLabel");
            label2.setLabelFor(preview);
            DialogLayout.Group horz = this.createParallelGroup();
            DialogLayout.Group vert = this.createSequentialGroup();
            horzAreas.addGroup(horz.addWidget(label2).addWidget(preview));
            vertAreas.addGroup(vert.addGap().addWidget(label2).addWidget(preview));
            if (this.showHexEditField) {
                horz.addWidget(this.hexColorEditField);
                vert.addGap().addWidget(this.hexColorEditField);
            }
        }
        DialogLayout.Group horzMainGroup = this.createParallelGroup().addGroup(horzAreas.addGap()).addGroup(horzControlls);
        DialogLayout.Group vertMainGroup = this.createSequentialGroup().addGroup(vertAreas);
        for (int i2 = 0; i2 < numAdjuters; ++i2) {
            vertMainGroup.addGroup(vertAdjuster[i2]);
        }
        if (this.showHexEditField) {
            if (this.hexColorEditField == null) {
                this.createHexColorEditField();
            }
            if (!this.showPreview) {
                horzMainGroup.addWidget(this.hexColorEditField);
                vertMainGroup.addWidget(this.hexColorEditField);
            }
            this.updateHexEditField();
        }
        this.setHorizontalGroup(horzMainGroup);
        this.setVerticalGroup(vertMainGroup.addGap());
    }

    protected void updateAllColorAreas() {
        if (this.colorValueModels != null) {
            for (ColorValueModel cvm : this.colorValueModels) {
                cvm.fireCallback();
            }
            this.colorChanged();
        }
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.addModelCallback();
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        this.removeModelCallback();
        super.beforeRemoveFromGUI(gui);
    }

    private void removeModelCallback() {
        if (this.model != null) {
            this.model.removeCallback(this.modelCallback);
        }
    }

    private void addModelCallback() {
        if (this.model != null && this.getGUI() != null) {
            if (this.modelCallback == null) {
                this.modelCallback = new Runnable(){

                    @Override
                    public void run() {
                        ColorSelector.this.modelValueChanged();
                    }
                };
            }
            this.model.addCallback(this.modelCallback);
        }
    }

    private void createHexColorEditField() {
        this.hexColorEditField = new EditField(){

            @Override
            protected void insertChar(char ch) {
                if (this.isValid(ch)) {
                    super.insertChar(ch);
                }
            }

            @Override
            public void insertText(String str) {
                int n = str.length();
                for (int i = 0; i < n; ++i) {
                    if (this.isValid(str.charAt(i))) continue;
                    StringBuilder sb = new StringBuilder(str);
                    int j = n;
                    while (j-- >= i) {
                        if (this.isValid(sb.charAt(j))) continue;
                        sb.deleteCharAt(j);
                    }
                    str = sb.toString();
                    break;
                }
                super.insertText(str);
            }

            private boolean isValid(char ch) {
                int digit = Character.digit(ch, 16);
                return digit >= 0 && digit < 16;
            }
        };
        this.hexColorEditField.setTheme("hexColorEditField");
        this.hexColorEditField.setColumns(8);
        this.hexColorEditField.addCallback(new EditField.Callback(){

            @Override
            public void callback(int key) {
                if (key == 1) {
                    ColorSelector.this.updateHexEditField();
                    return;
                }
                Color color = null;
                try {
                    color = Color.parserColor("#".concat(ColorSelector.this.hexColorEditField.getText()));
                    ColorSelector.this.hexColorEditField.setErrorMessage(null);
                }
                catch (Exception ex) {
                    ColorSelector.this.hexColorEditField.setErrorMessage("Invalid color format");
                }
                if (key == 28 && color != null) {
                    ColorSelector.this.setColor(color);
                }
            }
        });
    }

    void updateHexEditField() {
        if (this.hexColorEditField != null) {
            this.hexColorEditField.setText(String.format("%08X", this.currentColor));
        }
    }

    void modelValueChanged() {
        if (!this.inModelSetValue && this.model != null) {
            this.setColor(this.model.getValue().toARGB());
        }
    }

    class ColorArea2D
    extends ColorArea {
        private final int componentX;
        private final int componentY;

        ColorArea2D(int componentX, int componentY) {
            this.componentX = componentX;
            this.componentY = componentY;
            int n = ColorSelector.this.getNumComponents();
            for (int i = 0; i < n; ++i) {
                if (i == componentX || i == componentY) continue;
                ColorSelector.this.colorValueModels[i].addCallback(this);
            }
        }

        @Override
        protected void paintWidget(GUI gui) {
            super.paintWidget(gui);
            if (this.cursorImage != null) {
                float minValueX = ColorSelector.this.colorSpace.getMinValue(this.componentX);
                float maxValueX = ColorSelector.this.colorSpace.getMaxValue(this.componentX);
                float minValueY = ColorSelector.this.colorSpace.getMinValue(this.componentY);
                float maxValueY = ColorSelector.this.colorSpace.getMaxValue(this.componentY);
                int posX = (int)((ColorSelector.this.colorValues[this.componentX] - maxValueX) * (float)(this.getInnerWidth() - 1) / (minValueX - maxValueX) + 0.5f);
                int posY = (int)((ColorSelector.this.colorValues[this.componentY] - maxValueY) * (float)(this.getInnerHeight() - 1) / (minValueY - maxValueY) + 0.5f);
                this.cursorImage.draw(this.getAnimationState(), this.getInnerX() + posX, this.getInnerY() + posY, 1, 1);
            }
        }

        @Override
        protected void createImage(GUI gui) {
            this.img = gui.getRenderer().createDynamicImage(64, 64);
        }

        @Override
        protected void updateImage() {
            float[] temp = (float[])ColorSelector.this.colorValues.clone();
            IntBuffer buf = ColorSelector.this.imgDataInt;
            ColorSpace cs = ColorSelector.this.colorSpace;
            float x0 = cs.getMaxValue(this.componentX);
            float dx = (cs.getMinValue(this.componentX) - x0) / 63.0f;
            float y = cs.getMaxValue(this.componentY);
            float dy = (cs.getMinValue(this.componentY) - y) / 63.0f;
            int idx = 0;
            for (int i = 0; i < 64; ++i) {
                temp[this.componentY] = y;
                float x = x0;
                for (int j = 0; j < 64; ++j) {
                    temp[this.componentX] = x;
                    buf.put(idx++, cs.toRGB(temp) << 8 | 0xFF);
                    x += dx;
                }
                y += dy;
            }
            this.img.update(ColorSelector.this.imgData, DynamicImage.Format.RGBA);
            this.needsUpdate = false;
        }

        @Override
        void handleMouse(int x, int y) {
            float minValueX = ColorSelector.this.colorSpace.getMinValue(this.componentX);
            float maxValueX = ColorSelector.this.colorSpace.getMaxValue(this.componentX);
            float minValueY = ColorSelector.this.colorSpace.getMinValue(this.componentY);
            float maxValueY = ColorSelector.this.colorSpace.getMaxValue(this.componentY);
            int innerWidtht = this.getInnerWidth();
            int innerHeight = this.getInnerHeight();
            int posX = Math.max(0, Math.min(innerWidtht, x));
            int posY = Math.max(0, Math.min(innerHeight, y));
            float valueX = maxValueX + (minValueX - maxValueX) * (float)posX / (float)innerWidtht;
            float valueY = maxValueY + (minValueY - maxValueY) * (float)posY / (float)innerHeight;
            ColorSelector.this.colorValueModels[this.componentX].setValue(valueX);
            ColorSelector.this.colorValueModels[this.componentY].setValue(valueY);
        }
    }

    class ColorArea1D
    extends ColorArea {
        final int component;

        ColorArea1D(int component) {
            this.component = component;
            int n = ColorSelector.this.getNumComponents();
            for (int i = 0; i < n; ++i) {
                if (i == component) continue;
                ColorSelector.this.colorValueModels[i].addCallback(this);
            }
        }

        @Override
        protected void paintWidget(GUI gui) {
            super.paintWidget(gui);
            if (this.cursorImage != null) {
                float minValue = ColorSelector.this.colorSpace.getMinValue(this.component);
                float maxValue = ColorSelector.this.colorSpace.getMaxValue(this.component);
                int pos = (int)((ColorSelector.this.colorValues[this.component] - maxValue) * (float)(this.getInnerHeight() - 1) / (minValue - maxValue) + 0.5f);
                this.cursorImage.draw(this.getAnimationState(), this.getInnerX(), this.getInnerY() + pos, this.getInnerWidth(), 1);
            }
        }

        @Override
        protected void createImage(GUI gui) {
            this.img = gui.getRenderer().createDynamicImage(1, 64);
        }

        @Override
        protected void updateImage() {
            float[] temp = (float[])ColorSelector.this.colorValues.clone();
            IntBuffer buf = ColorSelector.this.imgDataInt;
            ColorSpace cs = ColorSelector.this.colorSpace;
            float x = cs.getMaxValue(this.component);
            float dx = (cs.getMinValue(this.component) - x) / 63.0f;
            for (int i = 0; i < 64; ++i) {
                temp[this.component] = x;
                buf.put(i, cs.toRGB(temp) << 8 | 0xFF);
                x += dx;
            }
            this.img.update(ColorSelector.this.imgData, DynamicImage.Format.RGBA);
            this.needsUpdate = false;
        }

        @Override
        void handleMouse(int x, int y) {
            float minValue = ColorSelector.this.colorSpace.getMinValue(this.component);
            float maxValue = ColorSelector.this.colorSpace.getMaxValue(this.component);
            int innerHeight = this.getInnerHeight();
            int pos = Math.max(0, Math.min(innerHeight, y));
            float value = maxValue + (minValue - maxValue) * (float)pos / (float)innerHeight;
            ColorSelector.this.colorValueModels[this.component].setValue(value);
        }
    }

    abstract class ColorArea
    extends Widget
    implements Runnable {
        DynamicImage img;
        Image cursorImage;
        boolean needsUpdate;

        ColorArea() {
        }

        @Override
        protected void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
            this.cursorImage = themeInfo.getImage("cursor");
        }

        abstract void createImage(GUI var1);

        abstract void updateImage();

        abstract void handleMouse(int var1, int var2);

        @Override
        protected void paintWidget(GUI gui) {
            if (this.img == null) {
                this.createImage(gui);
                this.needsUpdate = true;
            }
            if (this.img != null) {
                if (this.needsUpdate) {
                    this.updateImage();
                }
                this.img.draw(this.getAnimationState(), this.getInnerX(), this.getInnerY(), this.getInnerWidth(), this.getInnerHeight());
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.img != null) {
                this.img.destroy();
                this.img = null;
            }
        }

        @Override
        protected boolean handleEvent(Event evt) {
            switch (evt.getType()) {
                case MOUSE_BTNDOWN: 
                case MOUSE_DRAGGED: {
                    this.handleMouse(evt.getMouseX() - this.getInnerX(), evt.getMouseY() - this.getInnerY());
                    return true;
                }
                case MOUSE_WHEEL: {
                    return false;
                }
            }
            if (evt.isMouseEvent()) {
                return true;
            }
            return super.handleEvent(evt);
        }

        @Override
        public void run() {
            this.needsUpdate = true;
        }
    }

    class ARGBModel
    extends AbstractIntegerModel {
        private final int startBit;

        ARGBModel(int startBit) {
            this.startBit = startBit;
        }

        @Override
        public int getMaxValue() {
            return 255;
        }

        @Override
        public int getMinValue() {
            return 0;
        }

        @Override
        public int getValue() {
            return ColorSelector.this.currentColor >> this.startBit & 0xFF;
        }

        @Override
        public void setValue(int value) {
            ColorSelector.this.setColor(ColorSelector.this.currentColor & ~(255 << this.startBit) | value << this.startBit);
        }

        void fireCallback() {
            this.doCallback();
        }
    }

    class ColorValueModel
    extends AbstractFloatModel {
        private final int component;

        ColorValueModel(int component) {
            this.component = component;
        }

        @Override
        public float getMaxValue() {
            return ColorSelector.this.colorSpace.getMaxValue(this.component);
        }

        @Override
        public float getMinValue() {
            return ColorSelector.this.colorSpace.getMinValue(this.component);
        }

        @Override
        public float getValue() {
            return ColorSelector.this.colorValues[this.component];
        }

        @Override
        public void setValue(float value) {
            ColorSelector.this.colorValues[this.component] = value;
            this.doCallback();
            ColorSelector.this.colorChanged();
        }

        void fireCallback() {
            this.doCallback();
        }
    }
}

