/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.TreeTable;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractListModel;
import de.matthiasmann.twl.model.AbstractTreeTableModel;
import de.matthiasmann.twl.model.AbstractTreeTableNode;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.PropertyList;
import de.matthiasmann.twl.model.SimplePropertyList;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.TypeMapping;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertySheet
extends TreeTable {
    private final SimplePropertyList rootList = new SimplePropertyList("<root>");
    private final PropertyListCellRenderer subListRenderer = new PropertyListCellRenderer();
    private final TableBase.CellRenderer editorRenderer = new EditorRenderer();
    private final TypeMapping<PropertyEditorFactory<?>> factories = new TypeMapping();

    public PropertySheet() {
        this(new Model());
    }

    private PropertySheet(Model model) {
        super(model);
        this.rootList.addValueChangedCallback(new TreeGenerator(this.rootList, model));
        this.registerPropertyEditorFactory(String.class, new StringEditorFactory());
    }

    public SimplePropertyList getPropertyList() {
        return this.rootList;
    }

    public <T> void registerPropertyEditorFactory(Class<T> clazz, PropertyEditorFactory<T> factory) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factories.put(clazz, factory);
    }

    @Override
    public void setModel(TreeTableModel model) {
        if (!(model instanceof Model)) {
            throw new UnsupportedOperationException("Do not call this method");
        }
        super.setModel(model);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemePropertiesSheet(themeInfo);
    }

    protected void applyThemePropertiesSheet(ThemeInfo themeInfo) {
        this.applyCellRendererTheme(this.subListRenderer);
        this.applyCellRendererTheme(this.editorRenderer);
    }

    @Override
    protected TableBase.CellRenderer getCellRenderer(int row, int col, TreeTableNode node) {
        if (node == null) {
            node = this.getNodeFromRow(row);
        }
        if (node instanceof ListNode) {
            if (col == 0) {
                PropertyListCellRenderer cr = this.subListRenderer;
                TreeTable.NodeState nodeState = this.getOrCreateNodeState(node);
                cr.setCellData(row, col, node.getData(col), nodeState);
                return cr;
            }
            return null;
        }
        if (col == 0) {
            return super.getCellRenderer(row, col, node);
        }
        TableBase.CellRenderer cr = this.editorRenderer;
        cr.setCellData(row, col, node.getData(col));
        return cr;
    }

    TreeTableNode createNode(TreeTableNode parent, Property<?> property) {
        if (property.getType() == PropertyList.class) {
            return new ListNode(parent, property);
        }
        Class<?> type = property.getType();
        PropertyEditorFactory<?> factory = this.factories.get(type);
        if (factory != null) {
            PropertyEditor editor = factory.createEditor(property);
            if (editor != null) {
                return new LeafNode(parent, property, editor);
            }
        } else {
            Logger.getLogger(PropertySheet.class.getName()).log(Level.WARNING, "No property editor factory for type {0}", type);
        }
        return null;
    }

    public static class ComboBoxEditorFactory<T>
    implements PropertyEditorFactory<T> {
        private final ModelForwarder modelForwarder;

        public ComboBoxEditorFactory(ListModel<T> model) {
            this.modelForwarder = new ModelForwarder(model);
        }

        public ListModel<T> getModel() {
            return this.modelForwarder.getModel();
        }

        public void setModel(ListModel<T> model) {
            this.modelForwarder.setModel(model);
        }

        @Override
        public PropertyEditor createEditor(Property<T> property) {
            return new ComboBoxEditor<T>(property, this.modelForwarder);
        }

        class ModelForwarder
        extends AbstractListModel<T>
        implements ListModel.ChangeListener {
            private ListModel<T> model;

            public ModelForwarder(ListModel<T> model) {
                this.setModel(model);
            }

            @Override
            public int getNumEntries() {
                return this.model.getNumEntries();
            }

            @Override
            public T getEntry(int index) {
                return this.model.getEntry(index);
            }

            @Override
            public Object getEntryTooltip(int index) {
                return this.model.getEntryTooltip(index);
            }

            @Override
            public boolean matchPrefix(int index, String prefix) {
                return this.model.matchPrefix(index, prefix);
            }

            public ListModel<T> getModel() {
                return this.model;
            }

            public void setModel(ListModel<T> model) {
                if (this.model != null) {
                    this.model.removeChangeListener(this);
                }
                this.model = model;
                this.model.addChangeListener(this);
                this.fireAllChanged();
            }

            @Override
            public void entriesInserted(int first, int last) {
                this.fireEntriesInserted(first, last);
            }

            @Override
            public void entriesDeleted(int first, int last) {
                this.fireEntriesDeleted(first, last);
            }

            @Override
            public void entriesChanged(int first, int last) {
                this.fireEntriesChanged(first, last);
            }

            @Override
            public void allChanged() {
                this.fireAllChanged();
            }
        }
    }

    public static class ComboBoxEditor<T>
    implements PropertyEditor,
    Runnable {
        protected final ComboBox<T> comboBox;
        protected final Property<T> property;
        protected final ListModel<T> model;

        public ComboBoxEditor(Property<T> property, ListModel<T> model) {
            this.property = property;
            this.comboBox = new ComboBox<T>(model);
            this.model = model;
            this.comboBox.addCallback(this);
            this.resetValue();
        }

        @Override
        public Widget getWidget() {
            return this.comboBox;
        }

        @Override
        public void valueChanged() {
            this.resetValue();
        }

        @Override
        public void preDestroy() {
            this.comboBox.removeCallback(this);
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public void run() {
            if (this.property.isReadOnly()) {
                this.resetValue();
            } else {
                int idx = this.comboBox.getSelected();
                if (idx >= 0) {
                    this.property.setPropertyValue(this.model.getEntry(idx));
                }
            }
        }

        protected void resetValue() {
            this.comboBox.setSelected(this.findEntry(this.property.getPropertyValue()));
        }

        protected int findEntry(T value) {
            int n = this.model.getNumEntries();
            for (int i = 0; i < n; ++i) {
                if (!this.model.getEntry(i).equals(value)) continue;
                return i;
            }
            return -1;
        }
    }

    static class StringEditorFactory
    implements PropertyEditorFactory<String> {
        StringEditorFactory() {
        }

        @Override
        public PropertyEditor createEditor(Property<String> property) {
            return new StringEditor(property);
        }
    }

    static class StringEditor
    implements PropertyEditor,
    EditField.Callback {
        private final EditField editField;
        private final Property<String> property;

        public StringEditor(Property<String> property) {
            this.property = property;
            this.editField = new EditField();
            this.editField.addCallback(this);
            this.resetValue();
        }

        @Override
        public Widget getWidget() {
            return this.editField;
        }

        @Override
        public void valueChanged() {
            this.resetValue();
        }

        @Override
        public void preDestroy() {
            this.editField.removeCallback(this);
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public void callback(int key) {
            if (key == 1) {
                this.resetValue();
            } else if (!this.property.isReadOnly()) {
                try {
                    this.property.setPropertyValue(this.editField.getText());
                    this.editField.setErrorMessage(null);
                }
                catch (IllegalArgumentException ex) {
                    this.editField.setErrorMessage(ex.getMessage());
                }
            }
        }

        private void resetValue() {
            this.editField.setText(this.property.getPropertyValue());
            this.editField.setErrorMessage(null);
            this.editField.setReadOnly(this.property.isReadOnly());
        }
    }

    static class Model
    extends AbstractTreeTableModel
    implements PSTreeTableNode {
        Model() {
        }

        @Override
        public String getColumnHeaderText(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return "???";
        }

        @Override
        public int getNumColumns() {
            return 2;
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
        }

        @Override
        public void addChild(TreeTableNode parent) {
            this.insertChild(parent, this.getNumChildren());
        }
    }

    static class EditorRenderer
    implements TableBase.CellRenderer,
    TableBase.CellWidgetCreator {
        private PropertyEditor editor;

        EditorRenderer() {
        }

        @Override
        public void applyTheme(ThemeInfo themeInfo) {
        }

        @Override
        public Widget getCellRenderWidget(int x, int y, int width, int height, boolean isSelected) {
            this.editor.setSelected(isSelected);
            return null;
        }

        @Override
        public int getColumnSpan() {
            return 1;
        }

        @Override
        public int getPreferredHeight() {
            return this.editor.getWidget().getPreferredHeight();
        }

        @Override
        public String getTheme() {
            return "PropertyEditorCellRender";
        }

        @Override
        public void setCellData(int row, int column, Object data) {
            this.editor = (PropertyEditor)data;
        }

        @Override
        public Widget updateWidget(Widget existingWidget) {
            return this.editor.getWidget();
        }

        @Override
        public void positionWidget(Widget widget, int x, int y, int w, int h) {
            widget.setPosition(x, y);
            widget.setSize(w, h);
        }
    }

    class PropertyListCellRenderer
    extends TreeTable.TreeNodeCellRenderer {
        private final Widget bgRenderer;
        private final Label textRenderer;

        public PropertyListCellRenderer() {
            super(PropertySheet.this);
            this.bgRenderer = new Widget();
            this.textRenderer = new Label(this.bgRenderer.getAnimationState());
            this.bgRenderer.add(this.textRenderer);
            this.bgRenderer.setTheme(this.getTheme());
        }

        @Override
        public int getColumnSpan() {
            return 2;
        }

        @Override
        public Widget getCellRenderWidget(int x, int y, int width, int height, boolean isSelected) {
            this.bgRenderer.setPosition(x, y);
            this.bgRenderer.setSize(width, height);
            int indent = this.getIndentation();
            this.textRenderer.setPosition(x + indent, y);
            this.textRenderer.setSize(Math.max(0, width - indent), height);
            this.bgRenderer.getAnimationState().setAnimationState(TableBase.STATE_SELECTED, isSelected);
            return this.bgRenderer;
        }

        @Override
        public void setCellData(int row, int column, Object data, TreeTable.NodeState nodeState) {
            super.setCellData(row, column, data, nodeState);
            this.textRenderer.setText((String)data);
        }

        @Override
        protected void setSubRenderer(Object colData) {
        }
    }

    class ListNode
    extends PropertyNode {
        protected final TreeGenerator treeGenerator;

        public ListNode(TreeTableNode parent, Property<?> property) {
            super(parent, property);
            this.treeGenerator = new TreeGenerator((PropertyList)property.getPropertyValue(), this);
            this.treeGenerator.run();
        }

        @Override
        public Object getData(int column) {
            return this.property.getName();
        }

        @Override
        public void run() {
            this.treeGenerator.run();
        }

        @Override
        protected void removeCallback() {
            super.removeCallback();
            this.treeGenerator.removeChildCallbacks(this);
        }
    }

    static class LeafNode
    extends PropertyNode {
        private final PropertyEditor editor;

        public LeafNode(TreeTableNode parent, Property<?> property, PropertyEditor editor) {
            super(parent, property);
            this.editor = editor;
            this.setLeaf(true);
        }

        @Override
        public Object getData(int column) {
            switch (column) {
                case 0: {
                    return this.property.getName();
                }
                case 1: {
                    return this.editor;
                }
            }
            return "???";
        }

        @Override
        public void run() {
            this.editor.valueChanged();
            this.fireNodeChanged();
        }
    }

    class TreeGenerator
    implements Runnable {
        private final PropertyList list;
        private final PSTreeTableNode parent;

        public TreeGenerator(PropertyList list, PSTreeTableNode parent) {
            this.list = list;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.removeAllChildren();
            this.addSubProperties();
        }

        void removeChildCallbacks(PSTreeTableNode parent) {
            int n = parent.getNumChildren();
            for (int i = 0; i < n; ++i) {
                ((PropertyNode)parent.getChild(i)).removeCallback();
            }
        }

        void addSubProperties() {
            for (int i = 0; i < this.list.getNumProperties(); ++i) {
                TreeTableNode node = PropertySheet.this.createNode(this.parent, this.list.getProperty(i));
                if (node == null) continue;
                this.parent.addChild(node);
            }
        }
    }

    static abstract class PropertyNode
    extends AbstractTreeTableNode
    implements Runnable,
    PSTreeTableNode {
        protected final Property<?> property;

        public PropertyNode(TreeTableNode parent, Property<?> property) {
            super(parent);
            this.property = property;
            property.addValueChangedCallback(this);
        }

        protected void removeCallback() {
            this.property.removeValueChangedCallback(this);
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
        }

        @Override
        public void addChild(TreeTableNode parent) {
            this.insertChild(parent, this.getNumChildren());
        }
    }

    static interface PSTreeTableNode
    extends TreeTableNode {
        public void addChild(TreeTableNode var1);

        public void removeAllChildren();
    }

    public static interface PropertyEditorFactory<T> {
        public PropertyEditor createEditor(Property<T> var1);
    }

    public static interface PropertyEditor {
        public Widget getWidget();

        public void valueChanged();

        public void preDestroy();

        public void setSelected(boolean var1);
    }
}

