/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.CacheContext;
import de.matthiasmann.twl.renderer.DynamicImage;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.FontParameter;
import de.matthiasmann.twl.renderer.LineRenderer;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.OffscreenRenderer;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twl.renderer.lwjgl.BitmapFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLCacheContext;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLCursor;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLDynamicImage;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.renderer.lwjgl.RenderScale;
import de.matthiasmann.twl.renderer.lwjgl.SWCursor;
import de.matthiasmann.twl.renderer.lwjgl.TextureArea;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaRotated;
import de.matthiasmann.twl.renderer.lwjgl.TexturePostProcessing;
import de.matthiasmann.twl.renderer.lwjgl.TintStack;
import de.matthiasmann.twl.utils.ClipStack;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class LWJGLRenderer
implements Renderer,
LineRenderer {
    public static final AnimationState.StateKey STATE_LEFT_MOUSE_BUTTON = AnimationState.StateKey.get("leftMouseButton");
    public static final AnimationState.StateKey STATE_MIDDLE_MOUSE_BUTTON = AnimationState.StateKey.get("middleMouseButton");
    public static final AnimationState.StateKey STATE_RIGHT_MOUSE_BUTTON = AnimationState.StateKey.get("rightMouseButton");
    private final IntBuffer ib16 = BufferUtils.createIntBuffer((int)16);
    final int maxTextureSize;
    private int viewportX;
    private int viewportBottom;
    private int width;
    private int height;
    private boolean hasScissor;
    private final TintStack tintStateRoot;
    private final Cursor emptyCursor;
    private boolean useQuadsForLines;
    private boolean useSWMouseCursors;
    private SWCursor swCursor;
    private int mouseX;
    private int mouseY;
    private LWJGLCacheContext cacheContext;
    final SWCursorAnimState swCursorAnimState;
    final ArrayList<TextureArea> textureAreas = new ArrayList();
    final ArrayList<TextureAreaRotated> rotatedTextureAreas = new ArrayList();
    final ArrayList<LWJGLDynamicImage> dynamicImages = new ArrayList();
    TintStack tintStack = this.tintStateRoot = new TintStack();
    protected final ClipStack clipStack = new ClipStack();
    protected final Rect clipRectTemp = new Rect();

    public LWJGLRenderer() throws LWJGLException {
        this.syncViewportSize();
        GL11.glGetInteger((int)3379, (IntBuffer)this.ib16);
        this.maxTextureSize = this.ib16.get(0);
        if (Mouse.isCreated()) {
            int minCursorSize = Cursor.getMinCursorSize();
            IntBuffer tmp = BufferUtils.createIntBuffer((int)(minCursorSize * minCursorSize));
            this.emptyCursor = new Cursor(minCursorSize, minCursorSize, minCursorSize / 2, minCursorSize / 2, 1, tmp, null);
        } else {
            this.emptyCursor = null;
        }
        this.swCursorAnimState = new SWCursorAnimState();
    }

    public boolean isUseQuadsForLines() {
        return this.useQuadsForLines;
    }

    public void setUseQuadsForLines(boolean useQuadsForLines) {
        this.useQuadsForLines = useQuadsForLines;
    }

    public boolean isUseSWMouseCursors() {
        return this.useSWMouseCursors;
    }

    public void setUseSWMouseCursors(boolean useSWMouseCursors) {
        this.useSWMouseCursors = useSWMouseCursors;
    }

    @Override
    public CacheContext createNewCacheContext() {
        return new LWJGLCacheContext(this);
    }

    private LWJGLCacheContext activeCacheContext() {
        if (this.cacheContext == null) {
            this.setActiveCacheContext(this.createNewCacheContext());
        }
        return this.cacheContext;
    }

    @Override
    public CacheContext getActiveCacheContext() {
        return this.activeCacheContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveCacheContext(CacheContext cc) throws IllegalStateException {
        if (cc == null) {
            throw new NullPointerException();
        }
        if (!cc.isValid()) {
            throw new IllegalStateException("CacheContext is invalid");
        }
        if (!(cc instanceof LWJGLCacheContext)) {
            throw new IllegalArgumentException("CacheContext object not from this renderer");
        }
        LWJGLCacheContext lwjglCC = (LWJGLCacheContext)cc;
        if (lwjglCC.renderer != this) {
            throw new IllegalArgumentException("CacheContext object not from this renderer");
        }
        this.cacheContext = lwjglCC;
        try {
            for (TextureArea ta : this.textureAreas) {
                ta.destroyRepeatCache();
            }
            for (TextureAreaRotated tar : this.rotatedTextureAreas) {
                tar.destroyRepeatCache();
            }
        }
        finally {
            this.textureAreas.clear();
            this.rotatedTextureAreas.clear();
        }
    }

    public void syncViewportSize() {
        this.ib16.clear();
        GL11.glGetInteger((int)2978, (IntBuffer)this.ib16);
        this.viewportX = this.ib16.get(0);
        this.width = this.ib16.get(2);
        this.height = this.ib16.get(3);
        this.viewportBottom = this.ib16.get(1) + this.height;
    }

    public void setViewport(int x, int y, int width, int height) {
        this.viewportX = x;
        this.viewportBottom = y + height;
        this.width = width;
        this.height = height;
    }

    @Override
    public long getTimeMillis() {
        long res = Sys.getTimerResolution();
        long time = Sys.getTime();
        if (res != 1000L) {
            time = time * 1000L / res;
        }
        return time;
    }

    protected void setupGLState() {
        GL11.glPushAttrib((int)847876);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3089);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3154, (int)4354);
    }

    protected void revertGLState() {
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    @Override
    public boolean startRendering() {
        if (this.width <= 0 || this.height <= 0) {
            return false;
        }
        this.prepareForRendering();
        this.setupGLState();
        RenderScale.doscale();
        return true;
    }

    @Override
    public void endRendering() {
        this.renderSWCursor();
        RenderScale.descale();
        this.revertGLState();
    }

    public void pauseRendering() {
        RenderScale.descale();
        this.revertGLState();
    }

    public void resumeRendering() {
        this.hasScissor = false;
        this.setupGLState();
        RenderScale.doscale();
        this.setClipRect();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportBottom - this.height;
    }

    @Override
    public Font loadFont(URL url, Map<String, String> parameter, Collection<FontParameter> conditionalParameter) throws IOException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        if (conditionalParameter == null) {
            throw new NullPointerException("conditionalParameter");
        }
        String fileName = parameter.get("filename");
        if (fileName != null) {
            url = new URL(url, fileName);
        }
        BitmapFont bmFont = this.activeCacheContext().loadBitmapFont(url);
        return new LWJGLFont(this, bmFont, parameter, conditionalParameter);
    }

    @Override
    public Texture loadTexture(URL url, String formatStr, String filterStr) throws IOException {
        LWJGLTexture.Format format = LWJGLTexture.Format.COLOR;
        LWJGLTexture.Filter filter = LWJGLTexture.Filter.NEAREST;
        if (formatStr != null) {
            try {
                format = LWJGLTexture.Format.valueOf(formatStr.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.WARNING, "Unknown texture format: {0}", formatStr);
            }
        }
        if (filterStr != null) {
            try {
                filter = LWJGLTexture.Filter.valueOf(filterStr.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.WARNING, "Unknown texture filter: {0}", filterStr);
            }
        }
        return this.load(url, format, filter);
    }

    @Override
    public LineRenderer getLineRenderer() {
        return this;
    }

    @Override
    public OffscreenRenderer getOffscreenRenderer() {
        return null;
    }

    @Override
    public DynamicImage createDynamicImage(int width, int height) {
        boolean useTextureRectangle;
        if (width <= 0) {
            throw new IllegalArgumentException("width");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height");
        }
        if (width > this.maxTextureSize || height > this.maxTextureSize) {
            return null;
        }
        ContextCapabilities caps = GLContext.getCapabilities();
        boolean bl = useTextureRectangle = caps.GL_EXT_texture_rectangle || caps.GL_ARB_texture_rectangle;
        if (!(useTextureRectangle || caps.GL_ARB_texture_non_power_of_two || (width & width - 1) == 0 && (height & height - 1) == 0)) {
            return null;
        }
        int proxyTarget = useTextureRectangle ? 34039 : 32868;
        GL11.glTexImage2D((int)proxyTarget, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        this.ib16.clear();
        GL11.glGetTexLevelParameter((int)proxyTarget, (int)0, (int)4096, (IntBuffer)this.ib16);
        if (this.ib16.get(0) != width) {
            return null;
        }
        int target = useTextureRectangle ? 34037 : 3553;
        int id = this.glGenTexture();
        GL11.glBindTexture((int)target, (int)id);
        GL11.glTexImage2D((int)target, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        GL11.glTexParameteri((int)target, (int)10240, (int)9728);
        GL11.glTexParameteri((int)target, (int)10241, (int)9728);
        LWJGLDynamicImage image = new LWJGLDynamicImage(this, target, id, width, height, Color.WHITE);
        this.dynamicImages.add(image);
        return image;
    }

    @Override
    public void clipEnter(int x, int y, int w, int h) {
        this.clipStack.push(x, y, w, h);
        this.setClipRect();
    }

    @Override
    public void clipEnter(Rect rect) {
        this.clipStack.push(rect);
        this.setClipRect();
    }

    @Override
    public void clipLeave() {
        this.clipStack.pop();
        this.setClipRect();
    }

    @Override
    public boolean clipIsEmpty() {
        return this.clipStack.isClipEmpty();
    }

    @Override
    public void setCursor(MouseCursor cursor) {
        try {
            this.swCursor = null;
            if (this.isMouseInsideWindow()) {
                if (cursor instanceof LWJGLCursor) {
                    this.setNativeCursor(((LWJGLCursor)cursor).cursor);
                } else if (cursor instanceof SWCursor) {
                    this.setNativeCursor(this.emptyCursor);
                    this.swCursor = (SWCursor)cursor;
                } else {
                    this.setNativeCursor(null);
                }
            }
        }
        catch (LWJGLException ex) {
            Logger.getLogger(LWJGLRenderer.class.getName()).log(Level.WARNING, "Could not set native cursor", ex);
        }
    }

    @Override
    public void setMousePosition(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void setMouseButton(int button, boolean state) {
        this.swCursorAnimState.setAnimationState(button, state);
    }

    public LWJGLTexture load(URL textureUrl, LWJGLTexture.Format fmt, LWJGLTexture.Filter filter) throws IOException {
        return this.load(textureUrl, fmt, filter, null);
    }

    public LWJGLTexture load(URL textureUrl, LWJGLTexture.Format fmt, LWJGLTexture.Filter filter, TexturePostProcessing tpp) throws IOException {
        if (textureUrl == null) {
            throw new NullPointerException("textureUrl");
        }
        LWJGLCacheContext cc = this.activeCacheContext();
        if (tpp != null) {
            return cc.createTexture(textureUrl, fmt, filter, tpp);
        }
        return cc.loadTexture(textureUrl, fmt, filter);
    }

    @Override
    public void pushGlobalTintColor(float r, float g, float b, float a) {
        this.tintStack = this.tintStack.push(r, g, b, a);
    }

    @Override
    public void popGlobalTintColor() {
        this.tintStack = this.tintStack.pop();
    }

    public void pushGlobalTintColorReset() {
        this.tintStack = this.tintStack.pushReset();
    }

    public void setColor(Color color) {
        this.tintStack.setColor(color);
    }

    @Override
    public void drawLine(float[] pts, int numPts, float width, Color color, boolean drawAsLoop) {
        if (numPts * 2 > pts.length) {
            throw new ArrayIndexOutOfBoundsException(numPts * 2);
        }
        if (numPts >= 2) {
            this.tintStack.setColor(color);
            GL11.glDisable((int)3553);
            if (this.useQuadsForLines) {
                this.drawLinesAsQuads(numPts, pts, width, drawAsLoop);
            } else {
                this.drawLinesAsLines(numPts, pts, width, drawAsLoop);
            }
            GL11.glEnable((int)3553);
        }
    }

    private void drawLinesAsLines(int numPts, float[] pts, float width, boolean drawAsLoop) {
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)(drawAsLoop ? 2 : 3));
        for (int i = 0; i < numPts; ++i) {
            GL11.glVertex2f((float)pts[i * 2 + 0], (float)pts[i * 2 + 1]);
        }
        GL11.glEnd();
    }

    private void drawLinesAsQuads(int numPts, float[] pts, float width, boolean drawAsLoop) {
        width *= 0.5f;
        GL11.glBegin((int)7);
        for (int i = 1; i < numPts; ++i) {
            LWJGLRenderer.drawLineAsQuad(pts[i * 2 - 2], pts[i * 2 - 1], pts[i * 2 + 0], pts[i * 2 + 1], width);
        }
        if (drawAsLoop) {
            int idx = numPts * 2;
            LWJGLRenderer.drawLineAsQuad(pts[idx], pts[idx + 1], pts[0], pts[1], width);
        }
        GL11.glEnd();
    }

    private static void drawLineAsQuad(float x0, float y0, float x1, float y1, float w) {
        float dx = x1 - x0;
        float dy = y1 - y0;
        float l = (float)Math.sqrt(dx * dx + dy * dy) / w;
        GL11.glVertex2f((float)(x0 - (dx /= l) + (dy /= l)), (float)(y0 - dy - dx));
        GL11.glVertex2f((float)(x0 - dx - dy), (float)(y0 - dy + dx));
        GL11.glVertex2f((float)(x1 + dx - dy), (float)(y1 + dy + dx));
        GL11.glVertex2f((float)(x1 + dx + dy), (float)(y1 + dy - dx));
    }

    protected void prepareForRendering() {
        this.hasScissor = false;
        this.tintStack = this.tintStateRoot;
        this.clipStack.clearStack();
    }

    protected void renderSWCursor() {
        if (this.swCursor != null) {
            this.tintStack = this.tintStateRoot;
            this.swCursor.render(this.mouseX, this.mouseY);
        }
    }

    protected void setNativeCursor(Cursor cursor) throws LWJGLException {
        Mouse.setNativeCursor((Cursor)cursor);
    }

    protected boolean isMouseInsideWindow() {
        return Mouse.isInsideWindow();
    }

    protected void getTintedColor(Color color, float[] result) {
        result[0] = this.tintStack.r * (float)(color.getR() & 0xFF);
        result[1] = this.tintStack.g * (float)(color.getG() & 0xFF);
        result[2] = this.tintStack.b * (float)(color.getB() & 0xFF);
        result[3] = this.tintStack.a * (float)(color.getA() & 0xFF);
    }

    protected void getTintedColor(float[] color, float[] result) {
        result[0] = this.tintStack.r * color[0];
        result[1] = this.tintStack.g * color[1];
        result[2] = this.tintStack.b * color[2];
        result[3] = this.tintStack.a * color[3];
    }

    public void setClipRect() {
        Rect rect = this.clipRectTemp;
        if (this.clipStack.getClipRect(rect)) {
            GL11.glScissor((int)(this.viewportX + rect.getX() * RenderScale.scale), (int)(this.viewportBottom - rect.getBottom() * RenderScale.scale), (int)(rect.getWidth() * RenderScale.scale), (int)(rect.getHeight() * RenderScale.scale));
            if (!this.hasScissor) {
                GL11.glEnable((int)3089);
                this.hasScissor = true;
            }
        } else if (this.hasScissor) {
            GL11.glDisable((int)3089);
            this.hasScissor = false;
        }
    }

    Logger getLogger() {
        return Logger.getLogger(LWJGLRenderer.class.getName());
    }

    int glGenTexture() {
        this.ib16.clear().limit(1);
        GL11.glGenTextures((IntBuffer)this.ib16);
        return this.ib16.get(0);
    }

    void glDeleteTexture(int id) {
        this.ib16.clear();
        this.ib16.put(id).flip();
        GL11.glDeleteTextures((IntBuffer)this.ib16);
    }

    private static class SWCursorAnimState
    implements AnimationState {
        private final long[] lastTime = new long[3];
        private final boolean[] active = new boolean[3];

        void setAnimationState(int idx, boolean isActive) {
            if (idx >= 0 && idx < 3 && this.active[idx] != isActive) {
                this.lastTime[idx] = Sys.getTime();
                this.active[idx] = isActive;
            }
        }

        @Override
        public int getAnimationTime(AnimationState.StateKey state) {
            long curTime = Sys.getTime();
            int idx = this.getMouseButton(state);
            if (idx >= 0) {
                curTime -= this.lastTime[idx];
            }
            return (int)curTime & Integer.MAX_VALUE;
        }

        @Override
        public boolean getAnimationState(AnimationState.StateKey state) {
            int idx = this.getMouseButton(state);
            if (idx >= 0) {
                return this.active[idx];
            }
            return false;
        }

        @Override
        public boolean getShouldAnimateState(AnimationState.StateKey state) {
            return true;
        }

        private int getMouseButton(AnimationState.StateKey key) {
            if (key == STATE_LEFT_MOUSE_BUTTON) {
                return 0;
            }
            if (key == STATE_MIDDLE_MOUSE_BUTTON) {
                return 2;
            }
            if (key == STATE_RIGHT_MOUSE_BUTTON) {
                return 1;
            }
            return -1;
        }
    }
}

