/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.textarea.BoxAttribute;
import de.matthiasmann.twl.textarea.OrderedListType;
import de.matthiasmann.twl.textarea.TextAreaModel;
import de.matthiasmann.twl.textarea.Value;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public final class StyleAttribute<T> {
    private static final ArrayList<StyleAttribute<?>> attributes = new ArrayList();
    public static final StyleAttribute<TextAreaModel.HAlignment> HORIZONTAL_ALIGNMENT = new StyleAttribute<TextAreaModel.HAlignment>(true, TextAreaModel.HAlignment.class, TextAreaModel.HAlignment.LEFT);
    public static final StyleAttribute<TextAreaModel.VAlignment> VERTICAL_ALIGNMENT = new StyleAttribute<TextAreaModel.VAlignment>(true, TextAreaModel.VAlignment.class, TextAreaModel.VAlignment.BOTTOM);
    public static final StyleAttribute<Value> TEXT_INDENT = new StyleAttribute<Value>(true, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<String> FONT_NAME = new StyleAttribute<String>(true, String.class, "default");
    public static final StyleAttribute<String> LIST_STYLE_IMAGE = new StyleAttribute<String>(true, String.class, "ul-bullet");
    public static final StyleAttribute<OrderedListType> LIST_STYLE_TYPE = new StyleAttribute<OrderedListType>(true, OrderedListType.class, OrderedListType.DECIMAL);
    public static final StyleAttribute<Boolean> PREFORMATTED = new StyleAttribute<Boolean>(true, Boolean.class, Boolean.FALSE);
    public static final StyleAttribute<Boolean> BREAKWORD = new StyleAttribute<Boolean>(true, Boolean.class, Boolean.FALSE);
    public static final StyleAttribute<Color> COLOR = new StyleAttribute<Color>(true, Color.class, Color.WHITE);
    public static final StyleAttribute<TextAreaModel.Clear> CLEAR = new StyleAttribute<TextAreaModel.Clear>(false, TextAreaModel.Clear.class, TextAreaModel.Clear.NONE);
    public static final StyleAttribute<TextAreaModel.Display> DISPLAY = new StyleAttribute<TextAreaModel.Display>(false, TextAreaModel.Display.class, TextAreaModel.Display.INLINE);
    public static final StyleAttribute<TextAreaModel.FloatPosition> FLOAT_POSITION = new StyleAttribute<TextAreaModel.FloatPosition>(false, TextAreaModel.FloatPosition.class, TextAreaModel.FloatPosition.NONE);
    public static final StyleAttribute<Value> WIDTH = new StyleAttribute<Value>(false, Value.class, Value.AUTO);
    public static final StyleAttribute<Value> HEIGHT = new StyleAttribute<Value>(false, Value.class, Value.AUTO);
    public static final StyleAttribute<String> BACKGROUND_IMAGE = new StyleAttribute<Object>(false, String.class, null);
    public static final StyleAttribute<Color> BACKGROUND_COLOR = new StyleAttribute<Color>(false, Color.class, Color.TRANSPARENT);
    public static final StyleAttribute<Value> MARGIN_TOP = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> MARGIN_LEFT = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> MARGIN_RIGHT = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> MARGIN_BOTTOM = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> PADDING_TOP = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> PADDING_LEFT = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> PADDING_RIGHT = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final StyleAttribute<Value> PADDING_BOTTOM = new StyleAttribute<Value>(false, Value.class, Value.ZERO_PX);
    public static final BoxAttribute MARGIN = new BoxAttribute(MARGIN_TOP, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_BOTTOM);
    public static final BoxAttribute PADDING = new BoxAttribute(PADDING_TOP, PADDING_LEFT, PADDING_RIGHT, PADDING_BOTTOM);
    private final boolean inherited;
    private final Class<T> dataType;
    private final T defaultValue;
    private final int ordinal;

    public boolean isInherited() {
        return this.inherited;
    }

    public Class<T> getDataType() {
        return this.dataType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String name() {
        try {
            for (Field f : StyleAttribute.class.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.get(null) != this) continue;
                return f.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "?";
    }

    public String toString() {
        return this.name();
    }

    private StyleAttribute(boolean inherited, Class<T> dataType, T defaultValue) {
        this.inherited = inherited;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.ordinal = attributes.size();
        attributes.add(this);
    }

    public static int getNumAttributes() {
        return attributes.size();
    }

    public static StyleAttribute<?> getAttribute(int ordinal) throws IndexOutOfBoundsException {
        return attributes.get(ordinal);
    }

    public static StyleAttribute<?> getAttribute(String name) throws IllegalArgumentException {
        try {
            Field f = StyleAttribute.class.getField(name);
            if (Modifier.isStatic(f.getModifiers()) && f.getType() == StyleAttribute.class) {
                return (StyleAttribute)f.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalArgumentException("No style attribute " + name);
    }
}

