/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.textarea.CSSStyle;
import de.matthiasmann.twl.textarea.Parser;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleSheetKey;
import de.matthiasmann.twl.textarea.StyleSheetResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;

public class StyleSheet
implements StyleSheetResolver {
    static final Object NULL = new Object();
    private final ArrayList<Selector> rules = new ArrayList();
    private final IdentityHashMap<Style, Object> cache = new IdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            this.parse(new InputStreamReader(is, "UTF8"));
        }
        finally {
            is.close();
        }
    }

    public void parse(String style) throws IOException {
        this.parse(new StringReader(style));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Reader r) throws IOException {
        Parser parser = new Parser(r);
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        int what;
        block15: while ((what = parser.yylex()) != 0) {
            Selector selector = null;
            block16: while (true) {
                String element = null;
                String className = null;
                String id = null;
                parser.sawWhitespace = false;
                switch (what) {
                    default: {
                        parser.unexpected();
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        element = parser.yytext();
                    }
                    case 2: {
                        what = parser.yylex();
                    }
                }
                while (!(what != 3 && what != 4 || parser.sawWhitespace)) {
                    parser.expect(1);
                    String text = parser.yytext();
                    if (what == 3) {
                        className = text;
                    } else {
                        id = text;
                    }
                    what = parser.yylex();
                }
                selector = new Selector(element, className, id, selector);
                switch (what) {
                    case 5: {
                        selector.directChild = true;
                        what = parser.yylex();
                        break;
                    }
                    case 6: 
                    case 7: {
                        break block16;
                    }
                }
            }
            selector.directChild = true;
            selectors.add(selector);
            switch (what) {
                default: {
                    parser.unexpected();
                }
                case 7: {
                    CSSStyle style = new CSSStyle();
                    while ((what = parser.yylex()) != 8) {
                        if (what != 1) {
                            parser.unexpected();
                        }
                        String key = parser.yytext();
                        parser.expect(9);
                        what = parser.yylex();
                        if (what != 10 && what != 8) {
                            parser.unexpected();
                        }
                        String value = parser.sb.toString().trim();
                        try {
                            style.parseCSSAttribute(key, value);
                        }
                        catch (IllegalArgumentException ex) {
                            // empty catch block
                        }
                        if (what != 8) continue;
                    }
                    int n = selectors.size();
                    for (int i = 0; i < n; ++i) {
                        selector = (Selector)selectors.get(i);
                        this.rules.add(selector);
                        int score = 0;
                        Selector s = selector;
                        while (s != null) {
                            if (s.directChild) {
                                ++score;
                            }
                            if (s.element != null) {
                                score += 256;
                            }
                            if (s.className != null) {
                                score += 65536;
                            }
                            if (s.id != null) {
                                score += 0x1000000;
                            }
                            s = s.tail;
                        }
                        selector.score = score;
                        selector.style = style;
                    }
                    selectors.clear();
                    continue block15;
                }
                case 6: 
            }
        }
        return;
    }

    @Override
    public void layoutFinished() {
        this.cache.clear();
    }

    @Override
    public void startLayout() {
        this.cache.clear();
    }

    @Override
    public Style resolve(Style style) {
        Object cacheData = this.cache.get(style);
        if (cacheData == null) {
            return this.resolveSlow(style);
        }
        if (cacheData == NULL) {
            return null;
        }
        return (Style)cacheData;
    }

    private Style resolveSlow(Style style) {
        Object[] candidates = new Selector[this.rules.size()];
        int numCandidates = 0;
        int n = this.rules.size();
        for (int i = 0; i < n; ++i) {
            Selector selector = this.rules.get(i);
            if (!this.matches(selector, style)) continue;
            candidates[numCandidates++] = selector;
        }
        if (numCandidates > 1) {
            Arrays.sort(candidates, 0, numCandidates);
        }
        Style result = null;
        boolean copy = true;
        int n2 = numCandidates;
        for (int i = 0; i < n2; ++i) {
            CSSStyle ruleStyle = ((Selector)candidates[i]).style;
            if (result == null) {
                result = ruleStyle;
                continue;
            }
            if (copy) {
                result = new Style(result);
                copy = false;
            }
            result.putAll(ruleStyle);
        }
        this.putIntoCache(style, result);
        return result;
    }

    private void putIntoCache(Style key, Style style) {
        this.cache.put(key, style == null ? NULL : style);
    }

    private boolean matches(Selector selector, Style style) {
        do {
            StyleSheetKey styleSheetKey;
            if ((styleSheetKey = style.getStyleSheetKey()) == null) continue;
            if (selector.matches(styleSheetKey)) {
                selector = selector.tail;
                if (selector != null) continue;
                return true;
            }
            if (!selector.directChild) continue;
            return false;
        } while ((style = style.getParent()) != null);
        return false;
    }

    static class Selector
    extends StyleSheetKey
    implements Comparable<Selector> {
        final Selector tail;
        boolean directChild;
        CSSStyle style;
        int score;

        Selector(String element, String className, String id, Selector tail) {
            super(element, className, id);
            this.tail = tail;
        }

        @Override
        public int compareTo(Selector other) {
            return this.score - other.score;
        }
    }
}

