/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.StateExpression;
import java.util.BitSet;

public final class StateSelectOptimizer {
    private final AnimationState.StateKey[] keys;
    private final byte[] matrix;
    private final AnimationState.StateKey[] programKeys;
    private final short[] programCodes;
    private int programIdx;

    public static StateSelectOptimizer optimize(StateExpression ... expressions) {
        int numExpr = expressions.length;
        if (numExpr == 0) {
            return null;
        }
        BitSet bs = new BitSet();
        for (StateExpression e : expressions) {
            e.getUsedStateKeys(bs);
        }
        int numKeys = bs.cardinality();
        if (numKeys == 0 || numKeys >= 255) {
            return null;
        }
        AnimationState.StateKey[] keys = new AnimationState.StateKey[numKeys];
        int keyIdx = 0;
        int keyID = -1;
        while ((keyID = bs.nextSetBit(keyID + 1)) >= 0) {
            keys[keyIdx] = AnimationState.StateKey.get(keyID);
            ++keyIdx;
        }
        int matrixSize = 1 << numKeys;
        byte[] matrix = new byte[matrixSize];
        AnimationState as = new AnimationState(null, keys[numKeys - 1].getID() + 1);
        block2: for (int matrixIdx = 0; matrixIdx < matrixSize; ++matrixIdx) {
            for (int keyIdx2 = 0; keyIdx2 < numKeys; ++keyIdx2) {
                as.setAnimationState(keys[keyIdx2], (matrixIdx & 1 << keyIdx2) != 0);
            }
            for (int exprIdx = 0; exprIdx < numExpr; ++exprIdx) {
                if (!expressions[exprIdx].evaluate(as)) continue;
                matrix[matrixIdx] = (byte)(exprIdx + 1);
                continue block2;
            }
        }
        StateSelectOptimizer sso = new StateSelectOptimizer(keys, matrix);
        sso.compute(0, 0);
        return sso;
    }

    public AnimationState.StateKey[] getProgramKeys() {
        return this.programKeys;
    }

    public short[] getProgramCodes() {
        return this.programCodes;
    }

    private StateSelectOptimizer(AnimationState.StateKey[] keys, byte[] matrix) {
        this.keys = keys;
        this.matrix = matrix;
        this.programKeys = new AnimationState.StateKey[matrix.length - 1];
        this.programCodes = new short[matrix.length * 2 - 2];
    }

    private int compute(int bits, int mask) {
        if (mask == this.matrix.length - 1) {
            int result = this.matrix[bits] - 1;
            return result | 0x8000;
        }
        int best = -1;
        int bestScore = -1;
        int bestSet0 = 0;
        int bestSet1 = 0;
        int matrixIdxInc = bits == 0 ? 1 : Integer.lowestOneBit(bits);
        for (int keyIdx = 0; keyIdx < this.keys.length; ++keyIdx) {
            int test = 1 << keyIdx;
            if ((mask & test) != 0) continue;
            int set0 = 0;
            int set1 = 0;
            for (int matrixIdx = bits; matrixIdx < this.matrix.length; matrixIdx += matrixIdxInc) {
                if ((matrixIdx & mask) != bits) continue;
                int resultMask = 1 << this.matrix[matrixIdx];
                if ((matrixIdx & test) == 0) {
                    set0 |= resultMask;
                    continue;
                }
                set1 |= resultMask;
            }
            int score = Integer.bitCount(set0 ^ set1);
            if (score <= bestScore) continue;
            bestScore = score;
            bestSet0 = set0;
            bestSet1 = set1;
            best = keyIdx;
        }
        if (best < 0) {
            throw new AssertionError();
        }
        if (bestSet0 == bestSet1 && (bestSet0 & bestSet0 - 1) == 0) {
            int result = Integer.numberOfTrailingZeros(bestSet0) - 1;
            return result | 0x8000;
        }
        int bestMask = 1 << best;
        int idx = this.programIdx;
        this.programIdx += 2;
        this.programKeys[idx >> 1] = this.keys[best];
        this.programCodes[idx + 0] = (short)this.compute(bits | bestMask, mask |= bestMask);
        this.programCodes[idx + 1] = (short)this.compute(bits, mask);
        return idx;
    }
}

