/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DropDownFile;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import java.util.ArrayList;
import java.util.HashSet;

public class ItemRange {
    public int firstID;
    public int firstDamage = -1;
    public int lastID;
    public int lastDamage = -1;
    public byte state = 0;
    public HashSet encompassedhash = new HashSet();
    public ArrayList encompasseditems = new ArrayList();

    public ItemRange(int itemID) {
        this.firstID = itemID;
        this.firstDamage = -1;
        this.lastID = itemID;
        this.lastDamage = -1;
    }

    public ItemRange(int itemID, int damageStart, int damageEnd) {
        this.firstID = itemID;
        this.firstDamage = damageStart;
        this.lastID = itemID;
        this.lastDamage = damageEnd;
    }

    public ItemRange(int itemIDFirst, int itemIDLast) {
        this.firstID = itemIDFirst;
        this.firstDamage = -1;
        this.lastID = itemIDLast;
        this.lastDamage = -1;
    }

    public boolean isItemInRange(int id, int damage) {
        return id >= this.firstID && id <= this.lastID && (this.firstDamage == -1 || damage >= this.firstDamage && damage <= this.lastDamage);
    }

    public String toString() {
        if (this.firstID == this.lastID) {
            if (this.firstDamage == -1) {
                return "[" + this.firstID + "]";
            }
            if (this.firstDamage == this.lastDamage) {
                return "[" + this.firstID + ":" + this.firstDamage + "]";
            }
            return "[" + this.firstID + ":" + this.firstDamage + "-" + this.lastDamage + "]";
        }
        return "[" + this.firstID + "-" + this.lastID + "]";
    }

    public ItemRange(String rangestring) {
        rangestring = rangestring.replace(" ", "");
        rangestring = rangestring.replace("\t", "");
        rangestring = rangestring.substring(1, rangestring.length() - 1);
        String[] damagesplit = rangestring.split(":");
        if (damagesplit.length == 2) {
            String[] rangesplit = damagesplit[1].split("-");
            this.lastID = this.firstID = Integer.parseInt(damagesplit[0]);
            this.firstDamage = Integer.parseInt(rangesplit[0]);
            this.lastDamage = rangesplit.length == 2 ? Integer.parseInt(rangesplit[1]) : this.firstDamage;
        } else {
            String[] rangesplit = damagesplit[0].split("-");
            this.firstID = Integer.parseInt(rangesplit[0]);
            this.lastID = rangesplit.length == 2 ? Integer.parseInt(rangesplit[1]) : this.firstID;
        }
    }

    public void updateState(ItemVisibilityHash vis) {
        boolean allhidden = false;
        boolean allshown = false;
        for (ItemHash item : this.encompasseditems) {
            if (vis.isItemHidden(item)) {
                if (allshown) {
                    this.state = 1;
                    return;
                }
                allhidden = true;
                continue;
            }
            if (allhidden) {
                this.state = 1;
                return;
            }
            allshown = true;
        }
        this.state = allshown ? (byte)2 : (byte)0;
    }

    public void resetHashes() {
        this.encompassedhash.clear();
        this.encompasseditems.clear();
    }

    public boolean addItemIfInRange(int item, int damage, ady compound) {
        ItemHash hash;
        if (this.isItemInRange(item, damage) && this.encompassedhash.add(hash = new ItemHash(item, damage, compound))) {
            this.encompasseditems.add(hash);
            return true;
        }
        return false;
    }

    public void onClick(int itemno, int button, boolean doubleclick) {
        ItemVisibilityHash vis = NEIConfig.vishash;
        ItemHash item = (ItemHash)this.encompasseditems.get(itemno);
        if (NEIUtils.controlKey()) {
            NEIUtils.cheatItem(item.toStack(), button, 0);
            return;
        }
        if (button == 0) {
            if (doubleclick) {
                DropDownFile.dropDownInstance.hideAllItems();
            }
            vis.unhideItem(item);
        } else if (button == 1) {
            vis.hideItem(item);
        }
        DropDownFile.dropDownInstance.updateState();
        NEIUtils.loadItems();
        NEIConfig.vishash.save();
    }

    public void hideAllItems() {
        ItemVisibilityHash vis = NEIConfig.vishash;
        for (ItemHash item : this.encompasseditems) {
            vis.hideItem(item);
        }
    }

    public void showAllItems() {
        ItemVisibilityHash vis = NEIConfig.vishash;
        for (ItemHash item : this.encompasseditems) {
            vis.unhideItem(item);
        }
    }

    public ArrayList toIDList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.firstID;
        while (i <= this.lastID) {
            list.add(i);
            ++i;
        }
        return list;
    }
}

