/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.API;
import codechicken.nei.Button;
import codechicken.nei.Button2ActiveState;
import codechicken.nei.DropDownWidget;
import codechicken.nei.GuiManager;
import codechicken.nei.IHandleInput;
import codechicken.nei.IHandleTooltip;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.Label;
import codechicken.nei.LayoutStyle;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.LayoutStyleTMIOld;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIUtils;
import codechicken.nei.RenameableButton;
import codechicken.nei.SearchField;
import codechicken.nei.TextField;
import codechicken.nei.Widget;
import codechicken.nei.WidgetZOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class LayoutManager {
    public static int mousex;
    public static int mousey;
    private static Widget inputFocused;
    static TreeSet drawWidgets;
    static TreeSet controlWidgets;
    public static GuiManager gui;
    public static ItemPanel itemPanel;
    public static DropDownWidget dropDown;
    public static TextField searchField;
    public static Button options;
    public static Button prev;
    public static Button next;
    public static Label pageLabel;
    public static Button more;
    public static Button less;
    public static ItemQuantityField quantity;
    public static RenameableButton[] stateButtons;
    public static Button[] deleteButtons;
    public static Button delete;
    public static Button2ActiveState creative;
    public static Button rain;
    public static Button magnet;
    public static Button dawn;
    public static Button noon;
    public static Button dusk;
    public static Button midnight;
    public static Button heal;
    public static HashMap layoutStyles;

    static {
        layoutStyles = new HashMap();
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        API.addLayoutStyle(1, new LayoutStyleTMIOld());
        LayoutManager.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean onClick(int mx, int my, int button) {
        try {
            IHandleInput inputhander;
            if (NEIConfig.isHidden()) {
                return false;
            }
            if (!NEIConfig.isEnabled()) {
                return options.contains(mx, my) && options.handleClick(mx, my, button);
            }
            boolean clickhandled = false;
            Iterator iterator = controlWidgets.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (!clickhandled) break;
                    return true;
                }
                Widget widget = (Widget)iterator.next();
                widget.onGuiClick(mx, my);
                if (clickhandled || !widget.contains(mx, my) || !widget.handleClick(mx, my, button)) continue;
                clickhandled = true;
            }
            iterator = NEIController.inputHandlers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(inputhander = (IHandleInput)iterator.next()).mouseClicked(LayoutManager.gui.window, mx, my, button));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean widgetContains(int mx, int my) {
        try {
            Widget widget;
            if (!NEIConfig.isEnabled() || NEIConfig.isHidden()) {
                return false;
            }
            Iterator iterator = controlWidgets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(widget = (Widget)iterator.next()).contains(mx, my));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean keyPress(int keyID, char keyChar) {
        try {
            IHandleInput inputhander;
            if (NEIConfig.isEnabled() && !NEIConfig.isHidden()) {
                if (inputFocused != null) {
                    return inputFocused.handleKeyPress(keyID, keyChar);
                }
                for (Widget widget : controlWidgets) {
                    if (!widget.handleKeyPress(keyID, keyChar)) continue;
                    return true;
                }
            }
            Iterator iterator = NEIController.inputHandlers.iterator();
            do {
                if (iterator.hasNext()) continue;
                if (keyID != NEIConfig.getKeyBinding("hide")) return false;
                NEIConfig.toggleBooleanSetting("options.hidden");
                return true;
            } while (!(inputhander = (IHandleInput)iterator.next()).keyTyped(LayoutManager.gui.window, keyChar, keyID));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
            return false;
        }
    }

    public static void mouseUp(int mx, int my, int button) {
        try {
            if (!NEIConfig.isEnabled() || NEIConfig.isHidden()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mx, my, button);
            }
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    public static aan getStackMouseOver(int mx, int my) {
        block4: {
            if (NEIConfig.isEnabled() && !NEIConfig.isHidden()) break block4;
            return null;
        }
        try {
            for (Widget widget : controlWidgets) {
                aan stack = widget.getStackMouseOver(mx, my);
                if (stack == null) continue;
                return stack;
            }
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
        return null;
    }

    public static void draw(int mx, int my) {
        mousex = mx;
        mousey = my;
        LayoutManager.layout();
        try {
            if (!NEIConfig.isHidden()) {
                if (NEIConfig.isEnabled()) {
                    LayoutManager.drawWidgets(mousex, mousey);
                } else {
                    options.draw(gui, mousex, mousey);
                }
            }
            gui.enable2DRender();
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    private static void drawWidgets(int mx, int my) {
        LayoutManager.getLayoutStyle().drawBackground(gui);
        for (Widget widget : drawWidgets) {
            widget.draw(gui, mx, my);
        }
    }

    public static void showToolTip(int mx, int my) {
        aan stack;
        List tooltip = new LinkedList();
        if (!NEIConfig.isHidden() && NEIConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                tooltip = widget.handleTooltip(mx, my, tooltip);
            }
        }
        if (tooltip.isEmpty() && NEIUtils.getMinecraft().h.ap.k() == null && (stack = LayoutManager.gui.window.getStackMouseOver()) != null) {
            tooltip = NEIUtils.itemDisplayNameMultiline(stack, NEIConfig.showIDs());
        }
        for (IHandleTooltip handler : NEIController.tooltipHandlers) {
            tooltip = handler.handleTooltip(LayoutManager.gui.window, tooltip);
        }
        gui.drawMultilineTip(mx, my, tooltip);
    }

    public static void layout() {
        int windowWidth = LayoutManager.gui.window.q;
        int windowHeight = LayoutManager.gui.window.r;
        int containerWidth = LayoutManager.gui.window.b;
        int containerHeight = LayoutManager.gui.window.c;
        int containerLeft = LayoutManager.gui.window.e;
        int containerTop = LayoutManager.gui.window.f;
        boolean sidesOffScreen = containerLeft - 4 < 76;
        LayoutManager.prev.y = 2;
        LayoutManager.prev.height = 16;
        LayoutManager.prev.width = containerLeft / 3;
        if (sidesOffScreen) {
            LayoutManager.prev.x = -1000;
            LayoutManager.next.x = -1000;
        } else {
            LayoutManager.prev.x = (containerWidth + windowWidth) / 2 + 2;
            LayoutManager.next.x = windowWidth - LayoutManager.prev.width - 2;
        }
        LayoutManager.next.y = LayoutManager.prev.y;
        LayoutManager.next.width = LayoutManager.prev.width;
        LayoutManager.next.height = LayoutManager.prev.height;
        LayoutManager.pageLabel.x = containerLeft * 3 / 2 + containerWidth + 1;
        LayoutManager.pageLabel.y = LayoutManager.prev.y + 5;
        LayoutManager.pageLabel.text = itemPanel.getNumPages() == 0 ? "(0/0)" : "(" + (itemPanel.getPage() + 1) + "/" + itemPanel.getNumPages() + ")";
        LayoutManager.itemPanel.y = LayoutManager.prev.height + LayoutManager.prev.y;
        LayoutManager.more.x = LayoutManager.prev.x;
        LayoutManager.less.x = windowWidth - LayoutManager.less.width - 2;
        LayoutManager.more.y = LayoutManager.less.y = windowHeight - LayoutManager.more.height - 2;
        LayoutManager.quantity.x = LayoutManager.more.x + LayoutManager.more.width + 2;
        LayoutManager.quantity.y = LayoutManager.more.y;
        LayoutManager.quantity.width = LayoutManager.less.x - LayoutManager.quantity.x - 2;
        LayoutManager.quantity.height = LayoutManager.more.height;
        LayoutManager.options.x = sidesOffScreen ? -1000 : (NEIConfig.isEnabled() ? 0 : 6);
        LayoutManager.options.y = NEIConfig.isEnabled() ? windowHeight - 22 : windowHeight - 28;
        LayoutManager.delete.state = 4;
        if (NEIController.deleteMode) {
            LayoutManager.delete.state |= 1;
        } else if (LayoutManager.gui.window instanceof sr) {
            LayoutManager.delete.state |= 2;
        }
        LayoutManager.rain.state = 4;
        if (NEIUtils.isRaining()) {
            LayoutManager.rain.state |= 1;
        } else if (NEIConfig.isPropertyDisabled("rain")) {
            LayoutManager.rain.state |= 2;
        }
        LayoutManager.creative.state = 4;
        if (NEIUtils.getCreativeMode() != 0) {
            LayoutManager.creative.state |= 1;
        }
        if (NEIUtils.getCreativeMode() == 2) {
            LayoutManager.creative.state |= 8;
        }
        LayoutManager.magnet.state = 4 | (NEIConfig.getMagnetMode() ? 1 : 0);
        LayoutManager.dawn.state = NEIConfig.isPropertyDisabled("dawn") ? 2 : 0;
        LayoutManager.noon.state = NEIConfig.isPropertyDisabled("noon") ? 2 : 0;
        LayoutManager.dusk.state = NEIConfig.isPropertyDisabled("dusk") ? 2 : 0;
        LayoutManager.midnight.state = NEIConfig.isPropertyDisabled("midnight") ? 2 : 0;
        LayoutStyle style = LayoutManager.getLayoutStyle();
        style.reset();
        if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
            LayoutManager.layoutButton(delete, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.RAIN)) {
            LayoutManager.layoutButton(rain, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.CREATIVE)) {
            LayoutManager.layoutButton(creative, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.MAGNET)) {
            LayoutManager.layoutButton(magnet, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.TIME)) {
            LayoutManager.layoutButton(dawn, style);
            LayoutManager.layoutButton(noon, style);
            LayoutManager.layoutButton(dusk, style);
            LayoutManager.layoutButton(midnight, style);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.HEAL)) {
            LayoutManager.layoutButton(heal, style);
        }
        if (sidesOffScreen) {
            LayoutManager.heal.x = -1000;
            LayoutManager.midnight.x = -1000;
            LayoutManager.dusk.x = -1000;
            LayoutManager.noon.x = -1000;
            LayoutManager.dawn.x = -1000;
            LayoutManager.magnet.x = -1000;
            LayoutManager.creative.x = -1000;
            LayoutManager.rain.x = -1000;
            LayoutManager.delete.x = -1000;
        }
        if (sidesOffScreen) {
            LayoutManager.itemPanel.x = -1000;
            LayoutManager.itemPanel.width = 5;
        } else {
            LayoutManager.itemPanel.x = (containerWidth + windowWidth) / 2 + 3;
            LayoutManager.itemPanel.width = windowWidth - 3 - LayoutManager.itemPanel.x;
        }
        LayoutManager.itemPanel.height = windowHeight - 15 - LayoutManager.itemPanel.y;
        itemPanel.resize();
        LayoutManager.searchField.y = windowHeight - LayoutManager.searchField.height - 2;
        if (windowHeight - containerHeight <= 40 || sidesOffScreen) {
            LayoutManager.dropDown.x = -1000;
            dropDown.setDropDown(0);
            LayoutManager.searchField.x = -1000;
            searchField.setFocus(false);
        } else {
            LayoutManager.dropDown.x = NEIConfig.getLayoutStyle() == 1 ? 93 : 90;
            LayoutManager.dropDown.width = LayoutManager.prev.x - LayoutManager.dropDown.x - 3;
            LayoutManager.searchField.x = (windowWidth - LayoutManager.searchField.width) / 2;
        }
        int maxWidth = 0;
        int i = 0;
        while (i < 7) {
            LayoutManager.deleteButtons[i].x = -1000;
            ady statelist = NEIConfig.saveCompound.m("statename");
            NEIConfig.saveCompound.a("statename", (gh)statelist);
            String name = statelist.j("" + i);
            if (statelist.b("" + i) == null) {
                name = "" + (i + 1);
                statelist.a("" + i, name);
            }
            LayoutManager.stateButtons[i].label = String.valueOf(NEIConfig.isStateSaved(i) ? "Load " : "Save ") + name;
            int width = gui.getTextWidth(LayoutManager.stateButtons[i].label) + 26;
            if (width + 22 > containerLeft) {
                width = containerLeft - 22;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            if (sidesOffScreen) {
                LayoutManager.stateButtons[i].x = -1000;
                LayoutManager.deleteButtons[i].x = -1000;
            } else {
                LayoutManager.stateButtons[i].x = 0;
                LayoutManager.stateButtons[i].width = maxWidth;
                if (NEIConfig.isStateSaved(i)) {
                    LayoutManager.deleteButtons[i].x = LayoutManager.stateButtons[i].width + 3;
                    LayoutManager.deleteButtons[i].y = LayoutManager.stateButtons[i].y + 2;
                }
            }
            ++i;
        }
    }

    private static void layoutButton(Button button, LayoutStyle style) {
        style.position(button, gui);
    }

    private static void init() {
        itemPanel = new ItemPanel();
        dropDown = new DropDownWidget();
        searchField = new SearchField("search");
        options = new Button("Options", "options");
        prev = new Button("Prev", "prev");
        next = new Button("Next", "next");
        pageLabel = new Label("(0/0)", true);
        more = new Button("+", "more");
        less = new Button("-", "less");
        quantity = new ItemQuantityField("quantity");
        stateButtons = new RenameableButton[7];
        deleteButtons = new Button[7];
        int i = 0;
        while (i < 7) {
            LayoutManager.stateButtons[i] = new RenameableButton("", "state" + i);
            LayoutManager.deleteButtons[i] = new Button("x", "delete" + i);
            ++i;
        }
        delete = new Button("delete");
        creative = new Button2ActiveState("creative");
        rain = new Button("rain");
        magnet = new Button("magnet");
        dawn = new Button("dawn");
        noon = new Button("noon");
        dusk = new Button("dusk");
        midnight = new Button("midnight");
        heal = new Button("heal");
        LayoutManager.delete.state |= 4;
        LayoutManager.creative.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
        LayoutManager.layoutZOrders();
        LayoutManager.setStaticDimensions();
    }

    private static void setStaticDimensions() {
        LayoutManager.options.width = 80;
        LayoutManager.options.height = 22;
        LayoutManager.dropDown.height = 20;
        LayoutManager.searchField.height = 20;
        LayoutManager.searchField.width = 150;
        LayoutManager.less.height = 16;
        LayoutManager.less.width = 16;
        LayoutManager.more.height = 16;
        LayoutManager.more.width = 16;
        int i = 0;
        while (i < 7) {
            LayoutManager.stateButtons[i].x = 0;
            LayoutManager.stateButtons[i].y = 58 + i * 22;
            LayoutManager.stateButtons[i].height = 20;
            LayoutManager.deleteButtons[i].width = 16;
            LayoutManager.deleteButtons[i].height = 16;
            ++i;
        }
    }

    private static void layoutZOrders() {
        LayoutManager.dropDown.z = -5;
    }

    public static void reloadWidgets(GuiManager gui1) {
        gui = gui1;
        LayoutManager.setInputFocused(null);
        drawWidgets = new TreeSet(new WidgetZOrder(false));
        controlWidgets = new TreeSet(new WidgetZOrder(true));
        LayoutManager.addWidget(itemPanel);
        LayoutManager.addWidget(dropDown);
        LayoutManager.addWidget(searchField);
        LayoutManager.addWidget(options);
        LayoutManager.addWidget(prev);
        LayoutManager.addWidget(next);
        LayoutManager.addWidget(pageLabel);
        LayoutManager.addWidget(more);
        LayoutManager.addWidget(less);
        LayoutManager.addWidget(quantity);
        LayoutManager.getLayoutStyle().init();
        LayoutManager.layout();
        if (NEIConfig.isActionPermissable(InterActionMap.ITEM)) {
            int i = 0;
            while (i < 7) {
                LayoutManager.addWidget(deleteButtons[i]);
                LayoutManager.addWidget(stateButtons[i]);
                ++i;
            }
        }
        if (NEIConfig.isActionPermissable(InterActionMap.DELETE)) {
            LayoutManager.addWidget(delete);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.TIME)) {
            LayoutManager.addWidget(dawn);
            LayoutManager.addWidget(noon);
            LayoutManager.addWidget(dusk);
            LayoutManager.addWidget(midnight);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.RAIN)) {
            LayoutManager.addWidget(rain);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.HEAL)) {
            LayoutManager.addWidget(heal);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.MAGNET)) {
            LayoutManager.addWidget(magnet);
        }
        if (NEIConfig.isActionPermissable(InterActionMap.CREATIVE)) {
            LayoutManager.addWidget(creative);
        }
    }

    public static LayoutStyle getLayoutStyle() {
        LayoutStyle style = (LayoutStyle)layoutStyles.get(NEIConfig.getLayoutStyle());
        if (style == null) {
            style = (LayoutStyle)layoutStyles.get(0);
        }
        return style;
    }

    private static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
    }

    public static void tick() {
        try {
            if (!NEIConfig.isEnabled()) {
                return;
            }
            for (Widget widget : controlWidgets) {
                widget.update(gui);
            }
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean onMouseWheel(int i) {
        try {
            Widget widget;
            if (NEIConfig.isHidden()) return false;
            if (!NEIConfig.isEnabled()) {
                return false;
            }
            Iterator iterator = controlWidgets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(widget = (Widget)iterator.next()).onMouseWheel(i, mousex, mousey));
            return true;
        }
        catch (Exception exception) {
            NEIUtils.reportException(exception);
            NEIConfig.setEnabled(false);
        }
        return false;
    }

    public static Widget getInputFocused() {
        return inputFocused;
    }

    public static void setInputFocused(Widget widget) {
        if (inputFocused != null) {
            inputFocused.loseFocus();
        }
        if ((inputFocused = widget) != null) {
            inputFocused.gainFocus();
        }
    }
}

