/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ReflectionManager;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.DropDownFile;
import codechicken.nei.IInfiniteItemHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemInfo;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NEIPacketHandler;
import codechicken.nei.SubSetRangeTag;
import codechicken.nei.UnusedBlock;
import java.awt.Point;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class NEIUtils {
    private static Minecraft mc = NEIUtils.getMinecraft();

    public static Minecraft getMinecraft() {
        if (mc == null) {
            mc = ModLoader.getMinecraftInstance();
        }
        return mc;
    }

    public static void loadItems() {
        try {
            if (ReflectionManager.classExists((String)"net.minecraft.src.PluginHarness")) {
                ReflectionManager.callMethod((Class)ReflectionManager.findClass((String)"net.minecraft.src.PluginHarness"), (String)"reloadPlugins", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
            return;
        }
        ItemVisibilityHash vis = NEIConfig.vishash;
        ArrayList items = NEIController.items;
        ArrayList visibleitems = NEIController.visibleitems;
        items.clear();
        visibleitems.clear();
        DropDownFile.dropDownInstance.resetHashes();
        String matchstring = NEIConfig.getSearchExpression();
        SubSetRangeTag rangematch = null;
        Pattern match = null;
        if (matchstring.startsWith("@") && matchstring.length() > 1) {
            rangematch = DropDownFile.dropDownInstance.getTag(matchstring.substring(1), false);
        } else {
            matchstring = matchstring.replace(".", "");
            matchstring = matchstring.replace("?", ".");
            matchstring = matchstring.replace("*", ".+?");
            matchstring = matchstring.toLowerCase();
            try {
                match = Pattern.compile(matchstring);
            }
            catch (PatternSyntaxException e) {
                match = Pattern.compile("");
                LayoutManager.searchField.setText(matchstring.substring(0, matchstring.length() - 1));
            }
        }
        int itemID = 0;
        while (itemID < yr.e.length) {
            block21: {
                yr item;
                block20: {
                    item = yr.e[itemID];
                    if (item != null) break block20;
                    if (!NEIConfig.getBooleanSetting("ID dump.show empty blockIDs") || itemID == 0 || itemID >= pb.m.length) break block21;
                    items.add(new UnusedBlock(itemID));
                    if (!NEIUtils.nameMatches("UnusedBlock ID: " + itemID, match)) break block21;
                    visibleitems.add(new UnusedBlock(itemID));
                    break block21;
                }
                if (!ItemInfo.isHidden(item.bQ)) {
                    boolean skipDamage0 = false;
                    ArrayList datalist = ItemInfo.getItemCompounds(itemID);
                    if (datalist != null && NEIConfig.isActionPermissable("nbt")) {
                        for (aan stack : datalist) {
                            stack = stack.k();
                            items.add(new ItemPanelStack(stack));
                            DropDownFile.dropDownInstance.addItemIfInRange(itemID, stack.i(), stack.d);
                            if (!vis.isItemHidden(itemID, stack.d) && NEIUtils.nameMatches(NEIUtils.concatenatedDisplayName(stack, NEIConfig.showIDs()), match) && (rangematch == null || rangematch.isItemInRange(itemID, 0)) && NEIConfig.canGetItem(new ItemHash(stack.c, stack.i()))) {
                                visibleitems.add(new ItemPanelStack(stack));
                            }
                            skipDamage0 = true;
                        }
                    }
                    HashSet<String> hashset = new HashSet<String>();
                    ArrayList damageranges = ItemInfo.getItemDamageVariants(item.bQ);
                    for (int[] damagerange : damageranges) {
                        int damage = damagerange[0];
                        while (damage <= damagerange[1]) {
                            aan itemstack = new aan(item, 1, damage);
                            try {
                                String s;
                                int l = item.g(itemstack);
                                String name = NEIUtils.concatenatedDisplayName(itemstack, false);
                                if (!name.equals("Unnamed") && !hashset.contains(s = name + "@" + l)) {
                                    hashset.add(s);
                                    if (damage != 0 || !skipDamage0) {
                                        items.add(new ItemPanelStack(itemstack));
                                        DropDownFile.dropDownInstance.addItemIfInRange(itemID, damage, null);
                                        if (!vis.isItemHidden(itemID, damage) && NEIUtils.nameMatches(NEIUtils.concatenatedDisplayName(itemstack, NEIConfig.showIDs()), match) && (rangematch == null || rangematch.isItemInRange(itemID, damage)) && NEIConfig.canGetItem(new ItemHash(itemID, damage))) {
                                            visibleitems.add(new ItemPanelStack(itemstack));
                                        }
                                    }
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                            ++damage;
                        }
                    }
                }
            }
            ++itemID;
        }
        DropDownFile.dropDownInstance.updateState();
    }

    private static boolean nameMatches(String name, Pattern match) {
        return match == null || match.toString().equals("") || match.matcher(name.toLowerCase()).find();
    }

    public static void reportException(Exception exception) {
        try {
            exception.printStackTrace();
            String s = "nei " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File file = new File(Minecraft.b(), s);
            PrintWriter printwriter = new PrintWriter(new FileWriter(file));
            printwriter.print("[code]NEI Version: " + mod_NotEnoughItems.class.getAnnotation(Packager.class).getVersion() + "\n");
            exception.printStackTrace(printwriter);
            printwriter.println("[/code]");
            printwriter.close();
            NEIUtils.addChatMessage("Error written to " + s);
        }
        catch (Exception exception1) {
            System.out.println("Error during safeReportException:");
            exception1.printStackTrace();
        }
    }

    public static void addChatMessage(String s) {
        if (NEIUtils.mc.w != null) {
            NEIUtils.mc.w.a(s);
        }
    }

    public static List itemDisplayNameMultiline(aan itemstack, boolean showIDs) {
        String mainname;
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.q();
            int rarity = itemstack.s().e;
            if (rarity != 15) {
                namelist.set(0, "\u00a7" + Integer.toHexString(rarity) + (String)namelist.get(0));
            }
        }
        catch (Exception rarity) {
            // empty catch block
        }
        String overridename = ItemInfo.getOverrideName(itemstack.c, itemstack.i());
        if (namelist == null || namelist.size() == 0 || namelist.get(0) == null) {
            namelist = new ArrayList<String>();
            namelist.add(NEIUtils.safeName(overridename));
        }
        if ((mainname = ((String)namelist.get(0)).trim()).length() == 0 || overridename != null) {
            mainname = NEIUtils.safeName(overridename);
            namelist.set(0, mainname);
        }
        if (showIDs && itemstack != null) {
            mainname = mainname + " " + itemstack.c;
            if (itemstack.i() != 0) {
                mainname = mainname + ":" + itemstack.i();
            }
            namelist.set(0, mainname);
        }
        return namelist;
    }

    private static String safeName(String overridename) {
        return overridename == null ? "Unnamed" : overridename;
    }

    public static String itemDisplayNameShort(aan itemstack) {
        List list = NEIUtils.itemDisplayNameMultiline(itemstack, false);
        return (String)list.get(0);
    }

    public static String concatenatedDisplayName(aan itemstack, boolean showIDs) {
        List list = NEIUtils.itemDisplayNameMultiline(itemstack, showIDs);
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                s.append("#");
            }
            s.append(name);
        }
        return s.toString();
    }

    public static aan getValidItem(aan itemstack) {
        if (itemstack.a() != null) {
            return itemstack;
        }
        return new aan(pb.as);
    }

    public static void deleteHeldItem() {
        NEIUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIUtils.getMinecraft().c.a(((gb)NEIUtils.getMinecraft().s).d.f, -999, 0, false, (yw)NEIUtils.getMinecraft().h);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        aan stack;
        aan aan2 = stack = slotNumber == -999 ? NEIUtils.getHeldItem() : NEIUtils.mc.h.ar.b(slotNumber).b();
        if (stack == null) {
            return;
        }
        if (stack.a == 1) {
            NEIUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.k();
            --stack.a;
            NEIUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        if (NEIConfig.isMultiplayer()) {
            NEIPacketHandler.sendDeleteAllItems();
        } else {
            int i = 0;
            while (i < NEIUtils.mc.h.ar.e.size()) {
                NEIUtils.mc.h.ar.a(i, null);
                ++i;
            }
        }
    }

    public static void deleteItemsOfType(aan itemstack, gb guicontainer) {
        int i = 0;
        while (i < guicontainer.d.e.size()) {
            aan itemstack1;
            yu slot = guicontainer.d.b(i);
            if (slot != null && (itemstack1 = slot.b()) != null && itemstack1.c == itemstack.c && itemstack1.i() == itemstack.i()) {
                NEIUtils.setSlotContents(i, null, true);
                slot.d(null);
            }
            ++i;
        }
    }

    public static aan getHeldItem() {
        return NEIUtils.mc.h.ap.k();
    }

    public static void setSlotContents(int slot, aan item, boolean containerInv) {
        if (NEIConfig.isMultiplayer()) {
            NEIPacketHandler.sendSetSlot(slot, item, containerInv);
            if (slot == -999) {
                NEIUtils.mc.h.ap.b(item);
            }
        } else if (slot == -999) {
            NEIUtils.mc.h.ap.b(item);
        } else if (containerInv) {
            NEIUtils.mc.h.ar.a(slot, item);
        } else {
            NEIUtils.mc.h.ap.a(slot, item);
        }
    }

    public static void cheatItem(aan typeStack, int button, int mode) {
        if (!NEIConfig.isActionPermissable("item")) {
            return;
        }
        if (mode == -1 && button == 0 && NEIUtils.shiftKey()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                aan stack;
                if (!handler.canHandleItem(typeStack) || (stack = handler.getInfiniteItem(typeStack)) == null) continue;
                NEIUtils.giveStack(stack, stack.a, true);
                return;
            }
            NEIUtils.cheatItem(typeStack, button, 0);
        } else if (typeStack.a().i()) {
            NEIUtils.giveStack(typeStack, 1);
        } else if (button == 1) {
            NEIUtils.giveStack(typeStack, 1);
        } else if (mode == 1 && typeStack.a < typeStack.c()) {
            NEIUtils.giveStack(typeStack, typeStack.c() - typeStack.a);
        } else {
            int amount = NEIConfig.getItemQuantity();
            if (amount == 0) {
                amount = typeStack.c();
            }
            NEIUtils.giveStack(typeStack, amount);
        }
    }

    public static void giveStack(aan itemstack) {
        NEIUtils.giveStack(itemstack, itemstack.a);
    }

    public static void giveStack(aan itemstack, int i) {
        NEIUtils.giveStack(itemstack, i, false);
    }

    public static void giveStack(aan itemstack, int i, boolean infinite) {
        if (NEIConfig.isMultiplayer()) {
            aan itemstack1 = NEIUtils.copyStack(itemstack, i);
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendSpawnItem(itemstack1, infinite);
            } else {
                NEIUtils.sendCommand(NEIConfig.getStringSetting("command.give"), NEIUtils.mc.h.aA, itemstack1.c, itemstack1.a, itemstack1.i());
            }
        } else if (infinite) {
            NEIUtils.mc.h.ap.a(NEIUtils.copyStack(itemstack, i));
        } else {
            int increment = itemstack.c();
            int given = 0;
            while (given < i) {
                aan itemstack1 = NEIUtils.copyStack(itemstack, Math.min(i - given, increment));
                if (!NEIUtils.mc.h.ap.a(itemstack1)) break;
                given += increment;
            }
        }
    }

    public static aan copyStack(aan itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.a += i;
        return itemstack.a(i);
    }

    public static aan copyStack(aan itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIUtils.copyStack(itemstack, itemstack.a);
    }

    public static void updateUnlimitedItems() {
        aan stack;
        aan itemstack = NEIUtils.getHeldItem();
        if (itemstack != null && itemstack.a > 64) {
            itemstack.a = 1;
        }
        aan[] aitemstack = NEIUtils.mc.h.ap.a;
        int slot = 0;
        while (slot < aitemstack.length) {
            aan itemstack1 = aitemstack[slot];
            if (itemstack1 != null) {
                if (itemstack1.a < 0 || itemstack1.a > 64) {
                    itemstack1.a = 111;
                }
                if (itemstack1.i() > -32000 && itemstack1.i() < -30000) {
                    itemstack1.b(-32000);
                }
            }
            ++slot;
        }
        if (NEIConfig.isMultiplayer() || !NEIConfig.isEnabled()) {
            return;
        }
        LinkedList<ItemHash> infiniteItems = new LinkedList<ItemHash>();
        int slot2 = 0;
        while (slot2 < aitemstack.length) {
            stack = aitemstack[slot2];
            if (stack != null && stack.a == 111) {
                infiniteItems.add(new ItemHash(stack));
            }
            ++slot2;
        }
        slot2 = 0;
        while (slot2 < aitemstack.length) {
            stack = aitemstack[slot2];
            if (stack != null && stack.a != 111 && infiniteItems.contains(new ItemHash(stack))) {
                aitemstack[slot2] = null;
            }
            ++slot2;
        }
    }

    public static boolean areStacksSameType(aan stack1, aan stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.c == stack2.c && stack1.i() == stack2.i();
    }

    public static boolean areStacksSameTypeCrafting(aan stack1, aan stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.i() == stack2.i() || stack1.i() == -1 || stack2.i() == -1 || stack1.a().i());
    }

    public static int compareStacks(aan stack1, aan stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.c != stack2.c) {
            return stack1.c - stack2.c;
        }
        if (stack1.a != stack2.a) {
            return stack1.a - stack2.a;
        }
        return stack1.i() - stack2.i();
    }

    public static boolean areStacksIdentical(aan stack1, aan stack2) {
        return NEIUtils.compareStacks(stack1, stack2) == 0;
    }

    public static boolean isValidItem(aan test) {
        yr item = test.a();
        if (item == null) {
            return false;
        }
        if (ItemInfo.isHidden(item.bQ)) {
            return false;
        }
        HashSet<String> hashset = new HashSet<String>();
        ArrayList damageranges = ItemInfo.getItemDamageVariants(item.bQ);
        for (int[] damagerange : damageranges) {
            int damage = damagerange[0];
            while (damage <= damagerange[1]) {
                String s;
                block12: {
                    String name;
                    int l;
                    block11: {
                        aan itemstack = new aan(item, item.f(), damage);
                        l = item.g(itemstack);
                        name = NEIUtils.concatenatedDisplayName(itemstack, false);
                        if (name != null) break block11;
                        if (damage == test.i()) {
                            return false;
                        }
                    }
                    s = name + "@" + l;
                    if (damage != test.i()) break block12;
                    return !hashset.contains(s);
                }
                try {
                    if (!hashset.contains(s)) {
                        hashset.add(s);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++damage;
            }
        }
        return false;
    }

    public static List getEnchantments(aan itemstack) {
        no nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.p()) != null) {
            int i = 0;
            while (i < nbttaglist.d()) {
                short word0 = ((ady)nbttaglist.a(i)).e("id");
                short word1 = ((ady)nbttaglist.a(i)).e("lvl");
                int[] ai = new int[]{word0, word1};
                arraylist.add(ai);
                ++i;
            }
        }
        return arraylist;
    }

    public static boolean addEnchantment(aan itemstack, int e, int level) {
        if (e < jt.a.length && jt.a[e] != null) {
            itemstack.a(jt.a[e], level);
            return true;
        }
        return false;
    }

    public static void removeEnchantment(aan itemstack, int e) {
        no nbttaglist = itemstack.p();
        if (nbttaglist != null) {
            int i = 0;
            while (i < nbttaglist.d()) {
                short ID = ((ady)nbttaglist.a(i)).e("id");
                if (ID == e) {
                    try {
                        List list = (List)ModLoader.getPrivateValue(no.class, (Object)nbttaglist, (int)0);
                        list.remove(i);
                        if (list.size() == 0) {
                            itemstack.d(null);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public static boolean stackHasEnchantment(aan itemstack, int e) {
        List allenchantments = NEIUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(aan itemstack, int e) {
        List allenchantments = NEIUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List enchantments, jt e) {
        for (int[] ai : enchantments) {
            if (e.a(jt.a[ai[0]])) continue;
            return true;
        }
        return false;
    }

    public static boolean canItemFitInInventory(yw player, aan itemstack) {
        int i = 0;
        while (i < player.ap.a() - 4) {
            if (player.ap.k_(i) == null) {
                return true;
            }
            ++i;
        }
        if (!itemstack.g()) {
            if (itemstack.c() == 1) {
                return false;
            }
            i = 0;
            while (i < player.ap.a()) {
                aan invstack = player.ap.k_(i);
                if (invstack != null && invstack.c == itemstack.c && invstack.d() && invstack.a < invstack.c() && invstack.a < player.ap.d() && (!invstack.f() || invstack.i() == itemstack.i())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int maxStackSize(int item) {
        return yr.e[item].f();
    }

    public static int getCreativeMode() {
        if (NEIConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIUtils.mc.c.h()) {
            return 1;
        }
        return 0;
    }

    public static void cycleCreativeMode() {
        int mode = NEIUtils.getCreativeMode();
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendCycleCreativeMode();
            } else {
                NEIUtils.sendCommand(NEIConfig.getStringSetting("command.creative"), NEIUtils.mc.h.aA, mode ^ 1);
            }
        } else {
            NEIUtils.setCreativeMode((mode + 1) % 3);
        }
    }

    public static void setCreativeMode(int mode) {
        boolean enable;
        NEIConfig.setInvCreative(mode == 2);
        boolean bl = enable = mode != 0;
        if (NEIConfig.isMultiplayer()) {
            ((rk)NEIUtils.mc.c).a(enable);
        } else {
            try {
                Minecraft minecraft = NEIUtils.getMinecraft();
                if (enable) {
                    aff.d((yw)NEIUtils.mc.h);
                    minecraft.c = new aff(minecraft);
                } else {
                    aff.e((yw)NEIUtils.mc.h);
                    minecraft.c = new aes(minecraft);
                }
                ReflectionManager.setField(wq.class, (Object)minecraft.f.B(), (int)16, (Object)(enable ? 1 : 0));
            }
            catch (Exception exception) {
                NEIUtils.reportException(exception);
            }
        }
    }

    public static long getTime() {
        return NEIUtils.getMinecraft().f.B().f();
    }

    public static void setTime(long l) {
        NEIUtils.getMinecraft().f.B().a(l);
    }

    public static void setHourForward(int i) {
        long timethisday = NEIUtils.getTime() / 24000L * 24000L;
        long nexthour = timethisday + 24000L + (long)(i * 1000);
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendSetTime(i);
            } else {
                long l = NEIUtils.getTime() / 24000L * 24000L;
                long l1 = l + 24000L + (long)(i * 1000);
                NEIUtils.setTime(l1);
                NEIUtils.sendCommand(NEIConfig.getStringSetting("command.time"), nexthour);
            }
        } else {
            NEIUtils.setTime(nexthour);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof Integer || args[i] instanceof Long) {
                messageformat.setFormatByArgumentIndex(i, numberformat);
            }
            ++i;
        }
        NEIUtils.mc.h.a(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIUtils.getMinecraft().f.B().o();
    }

    public static void toggleRaining() {
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendToggleRain();
            } else {
                NEIUtils.sendCommand(NEIConfig.getStringSetting("command.rain"), NEIUtils.isRaining() ? 0 : 1);
            }
        } else {
            NEIUtils.getMinecraft().f.B().b(!NEIUtils.isRaining());
        }
    }

    public static void healPlayer() {
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendHeal();
            } else {
                NEIUtils.sendCommand(NEIConfig.getStringSetting("command.heal"), NEIUtils.mc.h.aA);
            }
        } else {
            vq player = NEIUtils.mc.h;
            player.k(20);
            mod_NotEnoughItems.foodStats((yw)player).a(20);
            mod_NotEnoughItems.foodStats((yw)player).b(1.0f);
            player.D();
        }
    }

    public static void toggleMagnetMode() {
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendToggleMagnetMode();
            }
        } else {
            NEIConfig.setMagnetMode(!NEIConfig.getMagnetMode());
        }
    }

    public static ArrayList concatIntegersToRanges(List damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static boolean itemMatchesSearch(aan stack) {
        String matchstring = NEIConfig.getSearchExpression();
        SubSetRangeTag rangematch = null;
        Pattern match = null;
        if (matchstring.startsWith("@") && matchstring.length() > 1) {
            rangematch = DropDownFile.dropDownInstance.getTag(matchstring.substring(1), false);
        } else {
            matchstring = matchstring.replace(".", "");
            matchstring = matchstring.replace("?", ".");
            matchstring = matchstring.replace("*", ".+?");
            matchstring = matchstring.toLowerCase();
            try {
                match = Pattern.compile(matchstring);
            }
            catch (PatternSyntaxException e) {
                match = Pattern.compile("");
                LayoutManager.searchField.setText(matchstring.substring(0, matchstring.length() - 1));
            }
        }
        return NEIUtils.nameMatches(NEIUtils.concatenatedDisplayName(stack, NEIConfig.showIDs()), match) && (rangematch == null || rangematch.isItemInRange(stack.c, 0));
    }

    public static void advanceDisabledTimes() {
        int zone;
        int hour;
        int newhour = hour = (int)(NEIUtils.getTime() % 24000L) / 1000;
        while (NEIConfig.isPropertyDisabled((String)AllowedPropertyMap.idToNameMap.get(zone = newhour / 6))) {
            newhour = (zone + 1) % 4 * 6;
        }
        if (newhour != hour) {
            NEIUtils.setHourForward(newhour);
        }
    }

    public static void dumpIDs() {
        try {
            boolean blocks = NEIConfig.getBooleanSetting("ID dump.blockIDs");
            boolean items = NEIConfig.getBooleanSetting("ID dump.itemIDs");
            boolean unusedblocks = NEIConfig.getBooleanSetting("ID dump.unused blockIDs");
            boolean unuseditems = NEIConfig.getBooleanSetting("ID dump.unused itemIDs");
            String s = "IDMap dump " + new SimpleDateFormat("d-M-y").format(new Date()) + " at " + new SimpleDateFormat("H.m.s.S").format(new Date()) + ".txt";
            File writeTo = new File(Minecraft.b(), s);
            if (!writeTo.exists()) {
                writeTo.createNewFile();
            }
            PrintWriter writer = new PrintWriter(writeTo);
            int i = 1;
            while (i < yr.e.length) {
                String name;
                if (i < pb.m.length && pb.m[i] != null) {
                    if (blocks) {
                        pb block = pb.m[i];
                        name = block.s();
                        if (name == null) {
                            name = block.getClass().getCanonicalName();
                        }
                        writer.println("Block. Name: " + name + ". ID: " + i);
                    }
                } else if (yr.e[i] != null) {
                    if (items) {
                        yr item = yr.e[i];
                        name = item.e();
                        if (name == null) {
                            name = item.getClass().getCanonicalName();
                        }
                        writer.println("Item. Name: " + name + ". ID: " + i);
                    }
                } else if (i < 256) {
                    if (unusedblocks) {
                        writer.println("Block. Unused ID: " + i);
                    }
                } else if (unuseditems) {
                    writer.println("Item. Unused ID: " + i);
                }
                ++i;
            }
            writer.close();
            NEIUtils.addChatMessage("Dumped IDMap to " + s);
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
        }
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static Point getMousePosition() {
        agd scaledresolution = new agd(NEIUtils.mc.A, NEIUtils.mc.d, NEIUtils.mc.e);
        int w = scaledresolution.a();
        int h = scaledresolution.b();
        return new Point(Mouse.getX() * w / NEIUtils.mc.d, h - Mouse.getY() * h / NEIUtils.mc.e - 1);
    }

    public static void setItemQuantity(int i) {
        NEIConfig.setItemQuantity(i);
        LayoutManager.quantity.text = Integer.toString(i);
    }
}

