/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.railcraft;

import codechicken.nei.FurnaceRecipeHandler;
import codechicken.nei.GuiManager;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import railcraft.common.api.crafting.ICokeOvenRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.gui.GuiCokeOven;

public class CokeOvenRecipeHandler
extends FurnaceRecipeHandler {
    public String getRecipeName() {
        return "Coke Oven";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(29, 32, 22, 16), "railcraft.cokeoven", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiCokeOven.class;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("railcraft.cokeoven") && ((Object)((Object)this)).getClass() == CokeOvenRecipeHandler.class) {
            for (ICokeOvenRecipe recipe : RailcraftCraftingManager.getCokeOvenRecipes()) {
                this.arecipes.add(new CachedOvenRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(aan ingred) {
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.getCokeOvenRecipes()) {
            if (!NEIUtils.areStacksSameTypeCrafting((aan)recipe.getInput(), (aan)ingred)) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(aan result) {
        LiquidContainer t = LiquidManager.getLiquidContainer((aan)result);
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.getCokeOvenRecipes()) {
            if ((t == null || !recipe.getLiquidOutput().isLiquidEqual(t.liquid)) && !NEIUtils.areStacksSameType((aan)result, (aan)recipe.getLiquidOutput().asItemStack()) && !NEIUtils.areStacksSameType((aan)result, (aan)recipe.getOutput())) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/railcraft/textures/gui_coke_oven.png";
    }

    public void drawExtras(GuiManager gui, int recipe) {
    }

    public class CachedOvenRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ICokeOvenRecipe oven;
        ArrayList inputs;
        PositionedStack output;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        LiquidStack liquid;

        public CachedOvenRecipe(ICokeOvenRecipe base) {
            super((TemplateRecipeHandler)CokeOvenRecipeHandler.this);
            this.oven = base;
            this.liquid = base.getLiquidOutput().copy();
            PositionedStack input = new PositionedStack((Object)this.oven.getInput(), 11, 32);
            this.output = new PositionedStack((Object)this.oven.getOutput(), 57, 32);
            this.liquidInput = null;
            this.liquidOutput = null;
            aan bucket = new aan(yr.aw);
            for (LiquidContainer cont : LiquidManager.liquidContainers) {
                if (!cont.liquid.isLiquidEqual(this.liquid) || !cont.empty.a(bucket)) continue;
                this.liquidInput = new PositionedStack((Object)bucket, 144, 11);
                this.liquidOutput = new PositionedStack((Object)cont.filled, 144, 46);
                break;
            }
            if (this.liquidOutput == null) {
                this.liquidOutput = new PositionedStack((Object)this.liquid.asItemStack(), 142, 46);
            }
            input.item.a *= 1000 / this.liquid.liquidAmount;
            this.inputs = new ArrayList();
            this.inputs.add(input);
            this.output.item.a *= 1000 / this.liquid.liquidAmount;
            this.liquid.liquidAmount *= 1000 / this.liquid.liquidAmount;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(CokeOvenRecipeHandler.this.cycleticks / 20, this.inputs);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.liquidOutput);
            if (this.liquidInput != null) {
                stacks.add(this.liquidInput);
            }
            return stacks;
        }
    }
}

