/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class PlayerTorchArray {
    static List torchArray = new ArrayList();
    static List torchEntityArray = new ArrayList();
    static int[][] lightdata = new int[32][5];
    static boolean areSettingsLoaded = false;
    static boolean disableAllLights = false;
    static File settingsFile = null;

    static int GetItemBrightnessValue(int ID) {
        if (!areSettingsLoaded) {
            PlayerTorchArray.initializeSettingsFile();
        }
        int i = 0;
        while (lightdata[i][0] != 0) {
            if (lightdata[i][0] == ID) {
                return lightdata[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int GetItemLightRangeValue(int ID) {
        int i = 0;
        while (lightdata[i][0] != 0) {
            if (lightdata[i][0] == ID) {
                return lightdata[i][2];
            }
            ++i;
        }
        return 0;
    }

    static int GetItemDeathAgeTicksValue(int ID) {
        int i = 0;
        while (lightdata[i][0] != 0) {
            if (lightdata[i][0] == ID) {
                return lightdata[i][3];
            }
            ++i;
        }
        return -1;
    }

    static boolean GetItemWorksUnderWaterValue(int ID) {
        int i = 0;
        while (lightdata[i][0] != 0) {
            if (lightdata[i][0] == ID) {
                return lightdata[i][4] != 0;
            }
            ++i;
        }
        return false;
    }

    public static int getBlockTorchBrightness(int retVal, xd worldObj, wl var1, int var2, int var3, int var4) {
        if (var1 == wl.a || !PlayerTorchArray.AreTorchesActive()) {
            return retVal;
        }
        int cached = LightCache.cache.getLightValue(var2, var3, var4);
        if (cached > retVal) {
            return cached;
        }
        int torchLight = Math.round(PlayerTorchArray.getLightBrightness(worldObj, var2, var3, var4));
        if (retVal < torchLight) {
            return torchLight;
        }
        LightCache.cache.setLightValue(var2, var3, var4, retVal);
        return retVal;
    }

    static float getLightBrightness(xd world, int i, int j, int k) {
        float torchLight = 0.0f;
        if (disableAllLights) {
            return torchLight;
        }
        int x = torchArray.size();
        while (--x >= 0) {
            PlayerTorch torchLoopClass = (PlayerTorch)torchArray.get(x);
            float lightBuffer = torchLoopClass.getTorchLight(world, i, j, k);
            if (!(lightBuffer > torchLight)) continue;
            torchLight = lightBuffer;
        }
        return torchLight;
    }

    static void ToggleDynamicLights() {
        disableAllLights = !disableAllLights;
    }

    static boolean AreTorchesActive() {
        if (!disableAllLights) {
            int x = torchArray.size();
            while (--x >= 0) {
                PlayerTorch torchLoopClass = (PlayerTorch)torchArray.get(x);
                if (!torchLoopClass.isTorchActive()) continue;
                return true;
            }
        }
        return false;
    }

    static void AddTorchToArray(PlayerTorch playertorch) {
        torchArray.add(playertorch);
        torchEntityArray.add(playertorch.GetTorchEntity());
    }

    static void RemoveTorchFromArray(xd world, PlayerTorch playertorch) {
        playertorch.setTorchState(world, false);
        torchArray.remove(playertorch);
        torchEntityArray.remove(playertorch.GetTorchEntity());
    }

    static PlayerTorch GetTorchForEntity(nn ent) {
        if (torchEntityArray.contains(ent)) {
            int x = torchArray.size();
            while (--x >= 0) {
                PlayerTorch torchLoopClass = (PlayerTorch)torchArray.get(x);
                if (torchLoopClass.GetTorchEntity() != ent) continue;
                return torchLoopClass;
            }
        }
        return null;
    }

    static void initializeSettingsFile() {
        ModLoader.getMinecraftInstance();
        settingsFile = new File(Minecraft.a((String)"minecraft"), "dynamiclights.settings");
        try {
            if (settingsFile.exists()) {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                int i = 0;
                while ((sCurrentLine = in.readLine()) != null) {
                    if (sCurrentLine.startsWith("//")) continue;
                    if (sCurrentLine.startsWith("ToggleButton")) {
                        String[] splits = sCurrentLine.split(":");
                        mod_dynamiclights.assignToggleButton(splits[1]);
                        continue;
                    }
                    String[] curLine = sCurrentLine.split(":");
                    PlayerTorchArray.lightdata[i][0] = Integer.parseInt(curLine[0]);
                    PlayerTorchArray.lightdata[i][1] = Integer.parseInt(curLine[1]);
                    PlayerTorchArray.lightdata[i][2] = Integer.parseInt(curLine[2]);
                    PlayerTorchArray.lightdata[i][3] = curLine.length > 3 ? Integer.parseInt(curLine[3]) : -1;
                    PlayerTorchArray.lightdata[i][4] = curLine.length > 4 ? Integer.parseInt(curLine[4]) : 1;
                    ++i;
                }
                PlayerTorchArray.lightdata[i][0] = 0;
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        areSettingsLoaded = true;
    }

    public static List getListOfDynamicLights() {
        return torchArray;
    }

    public static PlayerTorch getDynamicLightForEntity(nn entity) {
        return PlayerTorchArray.GetTorchForEntity(entity);
    }

    public static nn getEntityForDynamicLight(PlayerTorch light) {
        return light.GetTorchEntity();
    }

    public static float[] getDynamicLightPosition(PlayerTorch light) {
        float[] pos = new float[]{light.posX, light.posY, light.posZ};
        return pos;
    }

    public static int getItemBrightnessValue(int itemID) {
        return PlayerTorchArray.GetItemBrightnessValue(itemID);
    }

    public static int getItemLightRangeValue(int itemID) {
        return PlayerTorchArray.GetItemLightRangeValue(itemID);
    }

    public static int getItemDeathAgeTicksValue(int itemID) {
        return PlayerTorchArray.GetItemDeathAgeTicksValue(itemID);
    }

    public static boolean getItemWorksUnderWaterValue(int itemID) {
        return PlayerTorchArray.GetItemWorksUnderWaterValue(itemID);
    }

    public static void toggleDynamicLightsOnOff() {
        PlayerTorchArray.ToggleDynamicLights();
    }

    public static boolean getAreAnyLightsActive() {
        return PlayerTorchArray.AreTorchesActive();
    }

    public static void registerDynamicLight(PlayerTorch light) {
        light.FlagTorchAsCustom();
        PlayerTorchArray.AddTorchToArray(light);
    }

    public static void removeDynamicLight(PlayerTorch light) {
        light.UnFlagTorchAsCustom();
        PlayerTorchArray.RemoveTorchFromArray(light.GetTorchEntity().k, light);
    }
}

