/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RandomMobs {
    private static Map textureVariantsMap = new HashMap();
    private static Random random = new Random();

    public static void entityLoaded(nn entity) {
        if (entity.Z != null) {
            return;
        }
        if (!(entity instanceof acq)) {
            return;
        }
        if (entity instanceof yw) {
            return;
        }
        acq el = (acq)entity;
        int randomId = el.persistentId;
        entity.Z = "" + randomId;
    }

    public static void worldChanged(xd oldWorld, xd newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.s();
            for (int e = 0; e < entityList.size(); ++e) {
                nn entity = (nn)entityList.get(e);
                RandomMobs.entityLoaded(entity);
            }
        }
    }

    public static int getTexture(String skinUrl, String texture) {
        if (texture == null) {
            return -1;
        }
        if (skinUrl == null) {
            return -1;
        }
        if (skinUrl.length() <= 1) {
            return -1;
        }
        char ch2 = skinUrl.charAt(0);
        if (ch2 < '0' || ch2 > '9') {
            return -1;
        }
        int num = Math.abs(skinUrl.hashCode());
        String[] texs = (String[])textureVariantsMap.get(texture);
        if (texs == null) {
            texs = RandomMobs.getTextureVariants(texture);
            textureVariantsMap.put(texture, texs);
        }
        if (texs == null || texs.length <= 0) {
            return -1;
        }
        int index = num % texs.length;
        String tex = texs[index];
        return Config.getMinecraft().p.b(tex);
    }

    private static String[] getTextureVariants(String texture) {
        String suffix;
        aaw renderEngine = Config.getMinecraft().p;
        String[] texs = new String[]{texture};
        int pointPos = texture.lastIndexOf(46);
        if (pointPos < 0) {
            return texs;
        }
        String prefix = texture.substring(0, pointPos);
        int countVariants = RandomMobs.getCountTextureVariants(texture, prefix, suffix = texture.substring(pointPos));
        if (countVariants <= 1) {
            return texs;
        }
        texs = new String[countVariants];
        texs[0] = texture;
        for (int i = 1; i < texs.length; ++i) {
            int texNum = i + 1;
            texs[i] = prefix + texNum + suffix;
        }
        Config.dbg("RandomMobs: " + texture + ", variants: " + texs.length);
        return texs;
    }

    private static int getCountTextureVariants(String texture, String prefix, String suffix) {
        aaw renderEngine = Config.getMinecraft().p;
        int maxNum = 1000;
        for (int num = 2; num < maxNum; ++num) {
            String variant = prefix + num + suffix;
            try {
                InputStream in = renderEngine.l.a.a(variant);
                if (in != null) {
                    in.close();
                    continue;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return num - 1;
        }
        return maxNum;
    }

    public static void resetTextures() {
        textureVariantsMap.clear();
    }
}

