/*
 * Decompiled with CFR 0.152.
 */
package myst;

import java.util.Random;

public class symbol_WeatherNormal
extends myst_AgeSymbol {
    @Override
    public void instantiate(myst_IAgeController controller) {
        controller.registerInterface((myst_AgeSymbol)this, new WeatherController());
    }

    @Override
    public String identifier() {
        return "WeatherNorm";
    }

    @Override
    public String displayName() {
        return "Normal Weather";
    }

    @Override
    public myst_AgeSymbol.Category getCategory() {
        return myst_AgeSymbol.Category.Weather;
    }

    private class WeatherController
    implements myst_AgeSymbol.IWeatherController {
        private float rainingStrength;
        private float thunderingStrength;
        private Random random = new Random();
        private int updateLCG = this.random.nextInt();
        private IStorageObject infoObj;

        private WeatherController() {
        }

        @Override
        public void setDataObject(IStorageObject infoObj) {
            this.infoObj = infoObj;
            if (infoObj.getBoolean("raining")) {
                this.rainingStrength = 1.0f;
                if (infoObj.getBoolean("thundering")) {
                    this.thunderingStrength = 1.0f;
                }
            }
        }

        @Override
        public void updateRaining() {
            int var1 = this.infoObj.getInteger("thunder");
            if (var1 <= 0) {
                if (this.infoObj.getBoolean("thundering")) {
                    this.infoObj.setInteger("thunder", this.random.nextInt(12000) + 3600);
                } else {
                    this.infoObj.setInteger("thunder", this.random.nextInt(168000) + 12000);
                }
            } else {
                this.infoObj.setInteger("thunder", --var1);
                if (var1 <= 0) {
                    this.infoObj.setBoolean("thundering", !this.infoObj.getBoolean("thundering"));
                }
            }
            int var2 = this.infoObj.getInteger("rain");
            if (var2 <= 0) {
                if (this.infoObj.getBoolean("raining")) {
                    this.infoObj.setInteger("rain", this.random.nextInt(12000) + 12000);
                } else {
                    this.infoObj.setInteger("rain", this.random.nextInt(168000) + 12000);
                }
            } else {
                this.infoObj.setInteger("rain", --var2);
                if (var2 <= 0) {
                    this.infoObj.setBoolean("raining", !this.infoObj.getBoolean("raining"));
                }
            }
            this.rainingStrength = this.infoObj.getBoolean("raining") ? (float)((double)this.rainingStrength + 0.01) : (float)((double)this.rainingStrength - 0.01);
            if (this.rainingStrength < 0.0f) {
                this.rainingStrength = 0.0f;
            }
            if (this.rainingStrength > 1.0f) {
                this.rainingStrength = 1.0f;
            }
            if (this.infoObj.getBoolean("thundering") && this.thunderingStrength < 1.0f) {
                this.thunderingStrength = (float)((double)this.thunderingStrength + 0.01);
            } else if (this.thunderingStrength > 0.0f) {
                this.thunderingStrength = (float)((double)this.thunderingStrength - 0.01);
            }
            if (this.thunderingStrength < 0.0f) {
                this.thunderingStrength = 0.0f;
            }
            if (this.thunderingStrength > 1.0f) {
                this.thunderingStrength = 1.0f;
            }
        }

        @Override
        public void tick(xd worldObj, ack chunk) {
            int var5 = chunk.g * 16;
            int var6 = chunk.h * 16;
            if (worldObj.G() && worldObj.F() && worldObj.r.nextInt(100000) == 0) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int var8 = this.updateLCG >> 2;
                int var9 = var5 + (var8 & 0xF);
                int var10 = var6 + (var8 >> 8 & 0xF);
                int var11 = worldObj.f(var9, var10);
                if (worldObj.y(var9, var11, var10)) {
                    worldObj.e((nn)new d(worldObj, (double)var9, (double)var11, (double)var10));
                }
            }
        }

        @Override
        public void clear() {
            this.infoObj.setInteger("rain", 0);
            this.infoObj.setBoolean("raining", false);
            this.infoObj.setInteger("thunder", 0);
            this.infoObj.setBoolean("thundering", false);
        }

        @Override
        public void togglePrecipitation() {
            this.infoObj.setInteger("rain", 1);
        }

        @Override
        public float getRainingStrength() {
            return this.rainingStrength;
        }

        @Override
        public float getStormStrength() {
            return this.thunderingStrength;
        }

        @Override
        public float getTemperatureAtHeight(float temp, int y) {
            return temp;
        }

        @Override
        public abn getAlternateBiomeForCoords(abn saved, int par1, int par2) {
            return saved;
        }
    }
}

