/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.plugins.redpower;

import codechicken.nei.API;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IUsageHandler;
import codechicken.nei.ItemRange;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIUtils;
import codechicken.nei.plugins.redpower.AlloyFurnaceRecipeHandler;
import codechicken.nei.plugins.redpower.MicroRecipeHandler;
import eloraam.base.GuiAdvBench;
import eloraam.base.GuiAlloyFurnace;
import eloraam.base.ItemHandsaw;
import eloraam.machine.GuiBlueFurnace;
import java.util.ArrayList;

@Packager(getName="NEI_RedPowerPlugin", getVersion="1.3", getClasses={"codechicken.nei.plugins.redpower"}, getBaseDirectories={"NEI.PluginsClient"})
public class NEIRedPowerConfig
implements IConfigureNEI {
    public static boolean wiring;
    public static boolean logic;
    public static boolean control;
    public static boolean lighting;
    public static boolean world;
    public static boolean machine;
    public static boolean base;
    final int id;
    private ArrayList validmicrotypes;

    public NEIRedPowerConfig() {
        this.id = RedPowerBase.blockMicro.bO;
        this.validmicrotypes = new ArrayList();
    }

    public void loadConfig() {
        this.checkInstalled();
        if (!base) {
            return;
        }
        this.loadDamageRanges();
        this.loadCoverSubSets();
        this.loadSaws();
        this.loadSubSets();
        API.registerRecipeHandler((ICraftingHandler)new AlloyFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AlloyFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MicroRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MicroRecipeHandler());
        API.registerGuiOverlay(GuiAlloyFurnace.class, (String)"alloy");
        API.registerGuiOverlay(GuiAdvBench.class, (String)"crafting", (int)5, (int)12);
        if (machine) {
            weakDependancy_Machine.registerGuiOverlay();
        }
    }

    private void loadSaws() {
        ArrayList<yr> saws = new ArrayList<yr>();
        yr[] yrArray = yr.e;
        int n = yr.e.length;
        int n2 = 0;
        while (n2 < n) {
            yr item = yrArray[n2];
            if (item instanceof ItemHandsaw) {
                saws.add(item);
            }
            ++n2;
        }
        MicroRecipeHandler.saws = new ItemHandsaw[saws.size()];
        int i = 0;
        while (i < saws.size()) {
            MicroRecipeHandler.saws[i] = (ItemHandsaw)saws.get(i);
            ++i;
        }
        API.addSetRange((String)"RedPower.Tools.Saws", (MultiItemRange)new MultiItemRange().add(saws));
        API.addSetRange((String)"Items.Tools.Saws", (MultiItemRange)new MultiItemRange().add(saws));
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("net.minecraft.src." + name);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
    }

    private void checkInstalled() {
        wiring = NEIRedPowerConfig.classExists("RedPowerWiring");
        logic = NEIRedPowerConfig.classExists("RedPowerLogic");
        control = NEIRedPowerConfig.classExists("RedPowerControl");
        lighting = NEIRedPowerConfig.classExists("RedPowerLighting");
        world = NEIRedPowerConfig.classExists("RedPowerWorld");
        machine = NEIRedPowerConfig.classExists("RedPowerMachine");
        base = NEIRedPowerConfig.classExists("RedPowerBase");
    }

    private void loadSubSets() {
        MultiItemRange allitems = new MultiItemRange();
        MultiItemRange allblocks = new MultiItemRange();
        if (wiring) {
            allitems.add(RedPowerBase.itemHandsawDiamond);
            allitems.add(RedPowerBase.itemHandsawIron);
            API.addSetRange((String)"RedPower.Wiring", (MultiItemRange)new MultiItemRange().add((pb)RedPowerBase.blockMicro, 256, 256));
            API.addSetRange((String)"RedPower.Wiring.Insulated Wire", (MultiItemRange)new MultiItemRange().add((pb)RedPowerBase.blockMicro, 512, 527));
            API.addSetRange((String)"RedPower.Wiring.Bundled Cable", (MultiItemRange)new MultiItemRange().add((pb)RedPowerBase.blockMicro, 768, 784));
        }
        if (wiring || machine) {
            MultiItemRange alloys = new MultiItemRange();
            if (wiring) {
                alloys.add((yr)RedPowerBase.itemAlloy, 0, 0);
            }
            if (machine) {
                alloys.add((yr)RedPowerBase.itemAlloy, 1, 2);
            }
            alloys.add((yr)RedPowerBase.itemAlloy, 3, 4);
            if (machine) {
                alloys.add((yr)RedPowerBase.itemAlloy, 5, 5);
            }
            if (wiring) {
                alloys.add((yr)RedPowerBase.itemAlloy, 6, 6);
            }
            if (machine) {
                alloys.add((yr)RedPowerBase.itemAlloy, 7, 7);
            }
            API.addSetRange((String)"RedPower.Alloys", (MultiItemRange)alloys);
            allitems.add(alloys);
            allblocks.add((pb)RedPowerBase.blockMicro);
        }
        if (logic || machine) {
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)new MultiItemRange().add((yr)RedPowerBase.itemScrewdriver));
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)new MultiItemRange().add((yr)RedPowerBase.itemScrewdriver));
            allitems.add((yr)RedPowerBase.itemScrewdriver);
        }
        if (world) {
            weakDependancy_World.loadSubsetsWorld(allitems, allblocks);
        }
        if (lighting) {
            weakDependancy_Lighting.loadSubsetsLighting(allitems, allblocks);
        }
        if (machine) {
            weakDependancy_Machine.loadSubsetsMachine(allitems, allblocks);
        }
        if (logic) {
            weakDependancy_Logic.loadSubsetsLogic(allitems, allblocks);
        }
        if (control) {
            weakDependancy_Control.loadSubsetsControl();
        }
        if (base) {
            MultiItemRange appliances = new MultiItemRange();
            appliances.add((pb)RedPowerBase.blockAppliance, 0, 0);
            appliances.add((pb)RedPowerBase.blockAppliance, 2, 3);
            API.addSetRange((String)"RedPower.Appliances", (MultiItemRange)appliances);
            allblocks.add(appliances);
            API.addSetRange((String)"RedPower.Items", (MultiItemRange)allitems);
            API.addSetRange((String)"RedPower.Blocks", (MultiItemRange)allblocks);
        }
    }

    private void loadDamageRanges() {
        if (!wiring && !machine) {
            return;
        }
        yr item = yr.e[this.id];
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int startrange = -1;
        int i = 0;
        while (i < 32000) {
            aan itemstack = new aan(item, item.f(), i);
            String name = NEIUtils.itemDisplayNameShort((aan)itemstack);
            if (!name.equals("Unnamed") && !name.endsWith("null")) {
                if (startrange == -1) {
                    startrange = i;
                }
            } else if (startrange != -1) {
                ranges.add(new int[]{startrange, i - 1});
                startrange = -1;
            }
            ++i;
        }
        API.setItemDamageVariants((int)RedPowerBase.blockMicro.bO, ranges);
    }

    private void loadCoverSubSets() {
        if (!wiring) {
            return;
        }
        int startrange = -1;
        int i = 0;
        while (i < 256) {
            aan itemstack = new aan(this.id, 1, i);
            String name = NEIUtils.itemDisplayNameShort((aan)itemstack);
            if (!name.equals("Unnamed")) {
                if (startrange == -1) {
                    startrange = i;
                }
            } else if (startrange != -1) {
                this.validmicrotypes.add(new ItemRange(this.id, startrange, i - 1));
                startrange = -1;
            }
            ++i;
        }
        this.registerMicroSet("MicroBlocks.Cover", 0);
        this.registerMicroSet("MicroBlocks.Panel", 16);
        this.registerMicroSet("MicroBlocks.Slab", 17);
        this.registerMicroSet("MicroBlocks.Hollow Cover", 24);
        this.registerMicroSet("MicroBlocks.Hollow Panel", 25);
        this.registerMicroSet("MicroBlocks.Hollow Slab", 26);
        this.registerMicroSet("MicroBlocks.Cover Corner", 18);
        this.registerMicroSet("MicroBlocks.Panel Corner", 19);
        this.registerMicroSet("MicroBlocks.Slab Corner", 20);
        this.registerMicroSet("MicroBlocks.Cover Strip", 21);
        this.registerMicroSet("MicroBlocks.Panel Strip", 22);
        this.registerMicroSet("MicroBlocks.Slab Strip", 23);
        this.registerMicroSet("MicroBlocks.Triple Cover", 27);
        this.registerMicroSet("MicroBlocks.Cover Slab", 28);
        this.registerMicroSet("MicroBlocks.Triple Panel", 29);
        this.registerMicroSet("MicroBlocks.Anticover", 30);
        this.registerMicroSet("MicroBlocks.Hollow Triple Cover", 31);
        this.registerMicroSet("MicroBlocks.Hollow Cover Slab", 32);
        this.registerMicroSet("MicroBlocks.Hollow Triple Panel", 33);
        this.registerMicroSet("MicroBlocks.Hollow Anticover", 34);
        this.registerMicroSet("MicroBlocks.Triple Cover Corner", 35);
        this.registerMicroSet("MicroBlocks.Cover Slab Corner", 36);
        this.registerMicroSet("MicroBlocks.Triple Panel Corner", 37);
        this.registerMicroSet("MicroBlocks.Anticover Corner", 38);
        this.registerMicroSet("MicroBlocks.Triple Cover Strip", 39);
        this.registerMicroSet("MicroBlocks.Cover Slab Strip", 40);
        this.registerMicroSet("MicroBlocks.Triple Panel Strip", 41);
        this.registerMicroSet("MicroBlocks.Anticover Strip", 42);
        this.registerMicroSet("MicroBlocks.Post", 43);
        this.registerMicroSet("MicroBlocks.Pillar", 44);
        this.registerMicroSet("MicroBlocks.Column", 45);
        this.registerMicroSet("Wiring.Jacketed Wire", 64);
        this.registerMicroSet("Wiring.Jacketed Cable", 65);
        this.registerMicroSet("Bluetricity.Jacketed Bluewire", 66);
    }

    private void registerMicroSet(String RPName, int microID) {
        MultiItemRange shiftedmicrotypes = new MultiItemRange();
        for (ItemRange range : this.validmicrotypes) {
            shiftedmicrotypes.add(this.id, range.firstDamage + microID * 256, range.lastDamage + microID * 256);
        }
        API.addSetRange((String)("RedPower." + RPName), (MultiItemRange)shiftedmicrotypes);
        API.getRangeTag((String)("RedPower." + RPName)).setPosition(microID);
    }

    private static class weakDependancy_Control {
        private weakDependancy_Control() {
        }

        public static void loadSubsetsControl() {
            MultiItemRange control = new MultiItemRange();
            control.add((pb)RedPowerControl.blockBackplane);
            control.add((pb)RedPowerControl.blockFlatPeripheral);
            control.add((pb)RedPowerControl.blockPeripheral);
            control.add((yr)RedPowerControl.itemDisk);
            control.add((pb)RedPowerBase.blockMicro, 3072, 3072);
            API.addSetRange((String)"RedPower.Control", (MultiItemRange)control);
        }
    }

    private static class weakDependancy_Lighting {
        private weakDependancy_Lighting() {
        }

        public static void loadSubsetsLighting(MultiItemRange allitems, MultiItemRange allblocks) {
            API.addSetRange((String)"RedPower.Lighting", (MultiItemRange)new MultiItemRange().add((pb)RedPowerLighting.blockLampOff));
            allblocks.add((pb)RedPowerLighting.blockLampOff);
            API.addSetRange((String)"RedPower.Lumar", (MultiItemRange)new MultiItemRange().add((yr)RedPowerBase.itemLumar));
            allitems.add((yr)RedPowerBase.itemLumar);
        }
    }

    private static class weakDependancy_Logic {
        private weakDependancy_Logic() {
        }

        public static void loadSubsetsLogic(MultiItemRange allitems, MultiItemRange allblocks) {
            allblocks.add((pb)RedPowerLogic.blockLogic);
            allitems.add((yr)RedPowerLogic.itemParts);
            MultiItemRange basic = new MultiItemRange();
            MultiItemRange timed = new MultiItemRange();
            MultiItemRange advanced = new MultiItemRange();
            MultiItemRange array = new MultiItemRange();
            MultiItemRange bundled = new MultiItemRange();
            basic.add((pb)RedPowerLogic.blockLogic, 256, 268);
            timed.add((pb)RedPowerLogic.blockLogic, 0, 2);
            timed.add((pb)RedPowerLogic.blockLogic, 768, 768);
            advanced.add((pb)RedPowerLogic.blockLogic, 269, 272);
            array.add((pb)RedPowerLogic.blockLogic, 512, 514);
            bundled.add((pb)RedPowerLogic.blockLogic, 1024, 1024);
            API.addSetRange((String)"RedPower.Logic.Basic", (MultiItemRange)basic);
            API.addSetRange((String)"RedPower.Logic.Timed", (MultiItemRange)timed);
            API.addSetRange((String)"RedPower.Logic.Advanced", (MultiItemRange)advanced);
            API.addSetRange((String)"RedPower.Logic.Array", (MultiItemRange)array);
            API.addSetRange((String)"RedPower.Logic.Bundled", (MultiItemRange)bundled);
            API.addSetRange((String)"RedPower.Logic.Parts", (MultiItemRange)new MultiItemRange().add((yr)RedPowerLogic.itemParts));
        }
    }

    private static class weakDependancy_Machine {
        private weakDependancy_Machine() {
        }

        public static void loadSubsetsMachine(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange itemtransfer = new MultiItemRange();
            MultiItemRange fluidtransfer = new MultiItemRange();
            MultiItemRange tubes = new MultiItemRange();
            MultiItemRange pipes = new MultiItemRange();
            MultiItemRange machineparts = new MultiItemRange();
            itemtransfer.add((pb)RedPowerMachine.blockMachine, 0, 5);
            itemtransfer.add((pb)RedPowerMachine.blockMachine, 8, 10);
            itemtransfer.add((pb)RedPowerMachine.blockMachine, 12, 15);
            itemtransfer.add((pb)RedPowerMachine.blockMachine, 12, 15);
            itemtransfer.add((pb)RedPowerMachine.blockMachinePanel, 2, 2);
            fluidtransfer.add((pb)RedPowerMachine.blockMachinePanel, 1, 1);
            fluidtransfer.add((pb)RedPowerMachine.blockMachinePanel, 3, 3);
            pipes.add((pb)RedPowerBase.blockMicro, 1792, 1792);
            tubes.add((pb)RedPowerBase.blockMicro, 2048, 2048);
            tubes.add((pb)RedPowerBase.blockMicro, 2304, 2304);
            tubes.add((pb)RedPowerBase.blockMicro, 2560, 2560);
            tubes.add((pb)RedPowerBase.blockMicro, 2816, 2816);
            machineparts.add(RedPowerBase.itemDrawplateDiamond);
            machineparts.add(RedPowerBase.itemFineCopper);
            machineparts.add(RedPowerBase.itemFineIron);
            machineparts.add(RedPowerBase.itemCopperCoil);
            machineparts.add(RedPowerBase.itemMotor);
            MultiItemRange bluetricity = new MultiItemRange();
            bluetricity.add((pb)RedPowerBase.blockMicro, 1280, 1280);
            bluetricity.add((pb)RedPowerBase.blockAppliance, 1, 1);
            bluetricity.add((pb)RedPowerBase.blockAppliance, 4, 4);
            bluetricity.add((pb)RedPowerMachine.blockMachine, 5, 8);
            bluetricity.add((pb)RedPowerMachine.blockMachine, 11, 11);
            bluetricity.add((pb)RedPowerMachine.blockMachinePanel, 0, 2);
            bluetricity.add((yr)RedPowerMachine.itemVoltmeter);
            allitems.add((yr)RedPowerMachine.itemVoltmeter);
            bluetricity.add(RedPowerMachine.itemBatteryEmpty);
            allitems.add(RedPowerMachine.itemBatteryEmpty);
            allitems.add(RedPowerMachine.itemBatteryPowered);
            MultiItemRange sonic = new MultiItemRange();
            sonic.add((yr)RedPowerMachine.itemSonicDriver);
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)sonic);
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)sonic);
            allitems.add(sonic);
            bluetricity.add(sonic);
            MultiItemRange frames = new MultiItemRange();
            frames.add((pb)RedPowerMachine.blockMachine, 7, 7);
            frames.add((pb)RedPowerMachine.blockFrame);
            API.addSetRange((String)"RedPower.Machine.Frames", (MultiItemRange)frames);
            API.addSetRange((String)"RedPower.Machine.Item Transfer", (MultiItemRange)itemtransfer);
            API.addSetRange((String)"RedPower.Machine.Liquid Transfer", (MultiItemRange)fluidtransfer);
            API.addSetRange((String)"RedPower.Machine.Tubes", (MultiItemRange)tubes);
            API.addSetRange((String)"RedPower.Machine.Pipes", (MultiItemRange)pipes);
            API.addSetRange((String)"RedPower.Machine.Parts", (MultiItemRange)machineparts);
            API.addSetRange((String)"RedPower.Bluetricity", (MultiItemRange)bluetricity);
            allblocks.add((pb)RedPowerBase.blockAppliance);
            allblocks.add((pb)RedPowerMachine.blockMachinePanel);
            allblocks.add((pb)RedPowerMachine.blockMachine);
            MultiItemRange paintclean = new MultiItemRange();
            paintclean.add(RedPowerWorld.itemBrushDry);
            paintclean.add(RedPowerWorld.itemPaintCanEmpty);
            MultiItemRange brushes = new MultiItemRange();
            MultiItemRange cans = new MultiItemRange();
            brushes.add(RedPowerWorld.itemBrushDry);
            cans.add(RedPowerWorld.itemPaintCanEmpty);
            int i = 0;
            while (i < 16) {
                brushes.add(RedPowerWorld.itemBrushPaint[i]);
                cans.add(RedPowerWorld.itemPaintCanPaint[i]);
                ++i;
            }
            allitems.add(cans);
            allitems.add(brushes);
            API.addSetRange((String)"RedPower.Paint.Base", (MultiItemRange)paintclean);
            API.addSetRange((String)"RedPower.Paint.Cans", (MultiItemRange)cans);
            API.addSetRange((String)"RedPower.Paint.Brushes", (MultiItemRange)brushes);
        }

        public static void registerGuiOverlay() {
            API.registerGuiOverlay(GuiBlueFurnace.class, (String)"smelting", (int)11, (int)29);
        }
    }

    private static class weakDependancy_World {
        private weakDependancy_World() {
        }

        public static void loadSubsetsWorld(MultiItemRange allitems, MultiItemRange allblocks) {
            MultiItemRange worlditems = new MultiItemRange();
            MultiItemRange sickles = new MultiItemRange();
            MultiItemRange picks = new MultiItemRange();
            MultiItemRange shovel = new MultiItemRange();
            MultiItemRange axe = new MultiItemRange();
            MultiItemRange hoe = new MultiItemRange();
            MultiItemRange sword = new MultiItemRange();
            sickles.add((yr)RedPowerWorld.itemSickleWood);
            sickles.add((yr)RedPowerWorld.itemSickleStone);
            sickles.add((yr)RedPowerWorld.itemSickleIron);
            sickles.add((yr)RedPowerWorld.itemSickleDiamond);
            sickles.add((yr)RedPowerWorld.itemSickleGold);
            sickles.add((yr)RedPowerWorld.itemSickleRuby);
            sickles.add((yr)RedPowerWorld.itemSickleEmerald);
            sickles.add((yr)RedPowerWorld.itemSickleSapphire);
            worlditems.add(sickles);
            picks.add((yr)RedPowerWorld.itemPickaxeRuby);
            picks.add((yr)RedPowerWorld.itemPickaxeEmerald);
            picks.add((yr)RedPowerWorld.itemPickaxeSapphire);
            worlditems.add(picks);
            shovel.add((yr)RedPowerWorld.itemShovelRuby);
            shovel.add((yr)RedPowerWorld.itemShovelEmerald);
            shovel.add((yr)RedPowerWorld.itemShovelSapphire);
            worlditems.add(shovel);
            axe.add((yr)RedPowerWorld.itemAxeRuby);
            axe.add((yr)RedPowerWorld.itemAxeEmerald);
            axe.add((yr)RedPowerWorld.itemAxeSapphire);
            worlditems.add(axe);
            sword.add((yr)RedPowerWorld.itemSwordRuby);
            sword.add((yr)RedPowerWorld.itemSwordEmerald);
            sword.add((yr)RedPowerWorld.itemSwordSapphire);
            worlditems.add(sword);
            hoe.add((yr)RedPowerWorld.itemHoeRuby);
            hoe.add((yr)RedPowerWorld.itemHoeEmerald);
            hoe.add((yr)RedPowerWorld.itemHoeSapphire);
            worlditems.add(RedPowerWorld.itemHandsawEmerald);
            worlditems.add(RedPowerWorld.itemHandsawRuby);
            worlditems.add(RedPowerWorld.itemHandsawSapphire);
            worlditems.add(hoe);
            MultiItemRange othertools = new MultiItemRange();
            othertools.add(RedPowerWorld.itemWoolCard);
            othertools.add((yr)RedPowerWorld.itemAthame);
            worlditems.add(othertools);
            API.addToRange((String)"RedPower.Tools.Other", (MultiItemRange)othertools);
            API.addToRange((String)"Items.Tools.Other", (MultiItemRange)othertools);
            API.addSetRange((String)"RedPower.Tools.Sickles", (MultiItemRange)sickles);
            API.addSetRange((String)"Items.Tools.Sickles", (MultiItemRange)sickles);
            API.addSetRange((String)"RedPower.Tools.Pickaxes", (MultiItemRange)picks);
            API.addSetRange((String)"RedPower.Tools.Shovels", (MultiItemRange)shovel);
            API.addSetRange((String)"RedPower.Tools.Axes", (MultiItemRange)axe);
            API.addSetRange((String)"RedPower.Tools.Hoes", (MultiItemRange)hoe);
            API.addSetRange((String)"RedPower.Tools.Swords", (MultiItemRange)sword);
            MultiItemRange worldblocks = new MultiItemRange();
            worldblocks.add((pb)RedPowerWorld.blockPlants);
            worldblocks.add((pb)RedPowerWorld.blockLeaves);
            worldblocks.add((pb)RedPowerWorld.blockLogs);
            worldblocks.add((pb)RedPowerWorld.blockOres);
            worldblocks.add((pb)RedPowerWorld.blockStone);
            worldblocks.add((pb)RedPowerWorld.blockCrops);
            worldblocks.add((pb)RedPowerWorld.blockStorage);
            worlditems.add((yr)RedPowerBase.itemResource);
            worlditems.add((yr)RedPowerWorld.itemSeeds);
            worlditems.add(RedPowerBase.itemDyeIndigo);
            allblocks.add(worldblocks);
            allitems.add(worlditems);
            API.addSetRange((String)"RedPower.World.Blocks", (MultiItemRange)worldblocks);
            API.addSetRange((String)"RedPower.World.Items", (MultiItemRange)worlditems);
        }
    }
}

