/*
 * Decompiled with CFR 0.152.
 */
package wecui.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import wecui.InitializationFactory;
import wecui.WorldEditCUI;
import wecui.config.Configuration;
import wecui.obfuscation.Obfuscation;
import wecui.render.LineColor;

public class CUIConfiguration
implements InitializationFactory {
    protected WorldEditCUI controller;
    protected boolean debugMode = false;
    protected String cuboidGridColor = "#CC3333";
    protected String cuboidEdgeColor = "#CC4C4C";
    protected String cuboidFirstPointColor = "#33CC33";
    protected String cuboidSecondPointColor = "#3333CC";
    protected String polyGridColor = "#CC3333";
    protected String polyEdgeColor = "#CC4C4C";
    protected String polyPointColor = "#33CCCC";
    protected String ellipsoidGridColor = "#CC4C4C";
    protected String ellipsoidPointColor = "#CCCC33";
    protected String cylinderGridColor = "#CC3333";
    protected String cylinderEdgeColor = "#CC4C4C";
    protected String cylinderPointColor = "#CC33CC";
    protected String updateFile = "https://raw.github.com/yetanotherx/WorldEditCUI/master/updates.yml";
    protected Configuration config = null;

    public CUIConfiguration(WorldEditCUI controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        InputStream input;
        File file = new File(Obfuscation.getWorldEditCUIDir(), "Configuration.yml");
        file.getParentFile().mkdirs();
        if (!file.exists() && (input = mod_WorldEditCUI.class.getResourceAsStream("/Configuration.yml")) != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(file);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        this.config = new Configuration(file);
        this.config.load();
        this.debugMode = this.config.getBoolean("debug", this.debugMode);
        this.cuboidGridColor = this.parseColor(this.config.getString("colors.cuboidGrid"), this.cuboidGridColor);
        this.cuboidEdgeColor = this.parseColor(this.config.getString("colors.cuboidEdge"), this.cuboidEdgeColor);
        this.cuboidFirstPointColor = this.parseColor(this.config.getString("colors.cuboidFirstPoint"), this.cuboidFirstPointColor);
        this.cuboidSecondPointColor = this.parseColor(this.config.getString("colors.cuboidSecondPoint"), this.cuboidSecondPointColor);
        this.polyGridColor = this.parseColor(this.config.getString("colors.polyGrid"), this.polyGridColor);
        this.polyEdgeColor = this.parseColor(this.config.getString("colors.polyEdge"), this.polyEdgeColor);
        this.polyPointColor = this.parseColor(this.config.getString("colors.polyPoint"), this.polyPointColor);
        this.ellipsoidGridColor = this.parseColor(this.config.getString("colors.ellipsoidGrid"), this.ellipsoidGridColor);
        this.ellipsoidPointColor = this.parseColor(this.config.getString("colors.ellipsoidPoint"), this.ellipsoidPointColor);
        this.cylinderGridColor = this.parseColor(this.config.getString("colors.cylinderGrid"), this.cylinderGridColor);
        this.cylinderEdgeColor = this.parseColor(this.config.getString("colors.cylinderEdge"), this.cylinderEdgeColor);
        this.cylinderPointColor = this.parseColor(this.config.getString("colors.cylinderPoint"), this.cylinderPointColor);
        LineColor.CUBOIDBOX.setColor(this.cuboidEdgeColor);
        LineColor.CUBOIDGRID.setColor(this.cuboidGridColor);
        LineColor.CUBOIDPOINT1.setColor(this.cuboidFirstPointColor);
        LineColor.CUBOIDPOINT2.setColor(this.cuboidSecondPointColor);
        LineColor.POLYGRID.setColor(this.polyGridColor);
        LineColor.POLYBOX.setColor(this.polyEdgeColor);
        LineColor.POLYPOINT.setColor(this.polyPointColor);
        LineColor.ELLIPSOIDGRID.setColor(this.ellipsoidGridColor);
        LineColor.ELLIPSOIDCENTER.setColor(this.ellipsoidPointColor);
        LineColor.CYLINDERGRID.setColor(this.cylinderGridColor);
        LineColor.CYLINDERBOX.setColor(this.cylinderEdgeColor);
        LineColor.CYLINDERCENTER.setColor(this.cylinderPointColor);
        this.updateFile = this.config.getString("updateFile", this.updateFile);
    }

    protected String parseColor(String color, String def) {
        if (color == null) {
            return def;
        }
        if (!color.startsWith("#")) {
            return def;
        }
        if (color.length() != 7) {
            return def;
        }
        String r = color.substring(1, 3);
        String g = color.substring(3, 5);
        String b = color.substring(5, 7);
        try {
            int rI = Integer.parseInt(r, 16);
            int gI = Integer.parseInt(g, 16);
            int bI = Integer.parseInt(b, 16);
            return color;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public String getUpdateFile() {
        return this.updateFile;
    }
}

