/*
 * Decompiled with CFR 0.152.
 */
package wecui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationNode {
    protected Map<String, Object> root;

    public ConfigurationNode(Map<String, Object> root) {
        this.root = root;
    }

    public Object getProperty(String path) {
        if (!path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                return null;
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                return o;
            }
            try {
                node = (Map)o;
                continue;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }

    public void setProperty(String path, Object value) {
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            HashMap o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.put((String)parts[i], (Object)value);
                return;
            }
            if (o == null || !(o instanceof Map)) {
                o = new HashMap();
                node.put(parts[i], o);
            }
            node = o;
        }
    }

    public String getString(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public String getString(String path, String def) {
        String o = this.getString(path);
        if (o == null) {
            return def;
        }
        return o;
    }

    public int getInt(String path, int def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        if (o == null) {
            return def;
        }
        return o;
    }

    public double getDouble(String path, double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        if (o == null) {
            return def;
        }
        return o;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        if (o == null) {
            return def;
        }
        return o;
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return new ArrayList<String>(this.root.keySet());
        }
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return new ArrayList<String>(((Map)o).keySet());
        }
        return null;
    }

    public List<Object> getList(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationNode.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = ConfigurationNode.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = ConfigurationNode.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path, List<ConfigurationNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<ConfigurationNode> list = new ArrayList<ConfigurationNode>();
        for (Object o : raw) {
            if (!(o instanceof Map)) continue;
            list.add(new ConfigurationNode((Map)o));
        }
        return list;
    }

    public ConfigurationNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public Map<String, ConfigurationNode> getNodes(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            HashMap<String, ConfigurationNode> nodes = new HashMap<String, ConfigurationNode>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), new ConfigurationNode((Map)entry.getValue()));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        return null;
    }

    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        return null;
    }

    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        for (int i = 0; i < parts.length; ++i) {
            Object o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.remove(parts[i]);
                return;
            }
            node = (Map)o;
        }
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }

    public void setRoot(Map<String, Object> root) {
        this.root = root;
    }
}

