/*
 * Decompiled with CFR 0.152.
 */
package wecui.event.cui;

import wecui.event.cui.CUIBaseEvent;
import wecui.event.cui.CUICylinderEvent;
import wecui.event.cui.CUIEllipsoidEvent;
import wecui.event.cui.CUIMinMaxEvent;
import wecui.event.cui.CUIPoint2DEvent;
import wecui.event.cui.CUIPointEvent;
import wecui.event.cui.CUISelectionEvent;
import wecui.event.cui.CUIUpdateEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CUIEventType {
    SELECTION(CUISelectionEvent.class, "s", 1),
    POINT(CUIPointEvent.class, "p", 5, 6),
    POINT2D(CUIPoint2DEvent.class, "p2", 4, 5),
    ELLIPSOID(CUIEllipsoidEvent.class, "e", 4),
    CYLINDER(CUICylinderEvent.class, "cyl", 5),
    MINMAX(CUIMinMaxEvent.class, "mm", 2),
    UPDATE(CUIUpdateEvent.class, "u", 1);

    private final Class<? extends CUIBaseEvent> eventClass;
    private final String key;
    private final int min;
    private final int max;

    private CUIEventType(Class<? extends CUIBaseEvent> eventClass, String key, int min, int max) {
        this.eventClass = eventClass;
        this.key = key;
        this.min = min;
        this.max = max;
    }

    private CUIEventType(Class<? extends CUIBaseEvent> eventClass, String key, int paramCount) {
        this.eventClass = eventClass;
        this.key = key;
        this.min = paramCount;
        this.max = paramCount;
    }

    public Class<? extends CUIBaseEvent> getEventClass() {
        return this.eventClass;
    }

    public String getKey() {
        return this.key;
    }

    public int getMaxParameters() {
        return this.max;
    }

    public int getMinParameters() {
        return this.min;
    }

    public static CUIEventType getTypeFromKey(String key) {
        for (CUIEventType value : CUIEventType.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        return null;
    }
}

