/*
 * Decompiled with CFR 0.152.
 */
package wecui.fevents;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import wecui.fevents.Event;
import wecui.fevents.Listener;
import wecui.fevents.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerList<TEvent extends Event<TEvent>> {
    public Listener<TEvent>[][] handlers;
    public int[] handlerids;
    private final EnumMap<Order, ArrayList<Listener<TEvent>>> handlerslots = new EnumMap(Order.class);
    private boolean baked = false;
    private static ArrayList<HandlerList> alllists = new ArrayList();

    public static void bakeall() {
        for (HandlerList h : alllists) {
            h.bake();
        }
    }

    public HandlerList() {
        for (Order o : Order.values()) {
            this.handlerslots.put(o, new ArrayList());
        }
        alllists.add(this);
    }

    public void register(Listener<TEvent> listener, Order order) {
        if (this.handlerslots.get((Object)order).contains(listener)) {
            throw new IllegalStateException("This listener is already registered to order " + order.toString());
        }
        this.baked = false;
        this.handlerslots.get((Object)order).add(listener);
    }

    public void unregister(Listener<TEvent> listener) {
        for (Order o : Order.values()) {
            this.unregister(listener, o);
        }
    }

    public void unregister(Listener<TEvent> listener, Order order) {
        if (this.handlerslots.get((Object)order).contains(listener)) {
            this.baked = false;
            this.handlerslots.get((Object)order).remove(listener);
        }
    }

    void bake() {
        if (this.baked) {
            return;
        }
        ArrayList<Listener[]> handlerslist = new ArrayList<Listener[]>();
        ArrayList<Integer> handleridslist = new ArrayList<Integer>();
        for (Map.Entry<Order, ArrayList<Listener<TEvent>>> entry : this.handlerslots.entrySet()) {
            Order orderslot = entry.getKey();
            ArrayList<Listener<TEvent>> list = entry.getValue();
            int ord = orderslot.getIndex();
            handlerslist.add(list.toArray(new Listener[list.size()]));
            handleridslist.add(ord);
        }
        this.handlers = (Listener[][])handlerslist.toArray((T[])new Listener[handlerslist.size()][]);
        this.handlerids = new int[handleridslist.size()];
        for (int i = 0; i < handleridslist.size(); ++i) {
            this.handlerids[i] = (Integer)handleridslist.get(i);
        }
        this.baked = true;
    }
}

