/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.points;

import wecui.render.LineColor;
import wecui.render.shapes.Render3DBox;
import wecui.util.Vector3;

public class PointCube {
    protected Vector3 point;
    protected LineColor color = LineColor.CUBOIDPOINT1;

    public PointCube(Vector3 point) {
        this.point = point;
    }

    public PointCube(int x, int y, int z) {
        this.point = new Vector3(x, y, z);
    }

    public PointCube(double x, double y, double z) {
        this.point = new Vector3(x, y, z);
    }

    public void render() {
        double off = 0.03f;
        Vector3 minVec = new Vector3(off, off, off);
        Vector3 maxVec = new Vector3(off + 1.0, off + 1.0, off + 1.0);
        new Render3DBox(this.color, this.point.subtract(minVec), this.point.add(maxVec)).render();
    }

    public Vector3 getPoint() {
        return this.point;
    }

    public void setPoint(Vector3 point) {
        this.point = point;
    }

    public LineColor getColor() {
        return this.color;
    }

    public void setColor(LineColor color) {
        this.color = color;
    }
}

