/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.region;

import wecui.WorldEditCUI;
import wecui.render.LineColor;
import wecui.render.points.PointCube;
import wecui.render.region.BaseRegion;
import wecui.render.region.RegionType;
import wecui.render.shapes.Render3DBox;
import wecui.render.shapes.Render3DGrid;
import wecui.util.Vector3m;

public class CuboidRegion
extends BaseRegion {
    protected PointCube firstPoint;
    protected PointCube secondPoint;

    public CuboidRegion(WorldEditCUI controller) {
        super(controller);
    }

    public void render() {
        if (this.firstPoint != null && this.secondPoint != null) {
            this.firstPoint.render();
            this.secondPoint.render();
            Vector3m[] bounds = this.calcBounds();
            new Render3DBox(LineColor.CUBOIDBOX, bounds[0], bounds[1]).render();
            new Render3DGrid(LineColor.CUBOIDGRID, bounds[0], bounds[1]).render();
        } else if (this.firstPoint != null) {
            this.firstPoint.render();
        } else if (this.secondPoint != null) {
            this.secondPoint.render();
        }
    }

    public void setCuboidPoint(int id, int x, int y, int z) {
        if (id == 0) {
            this.firstPoint = new PointCube(x, y, z);
            this.firstPoint.setColor(LineColor.CUBOIDPOINT1);
        } else if (id == 1) {
            this.secondPoint = new PointCube(x, y, z);
            this.secondPoint.setColor(LineColor.CUBOIDPOINT2);
        }
    }

    protected Vector3m[] calcBounds() {
        float off = 0.02f;
        float off1 = 1.0f + off;
        Vector3m[] out = new Vector3m[]{new Vector3m((Double)Double.MAX_VALUE, (Double)Double.MAX_VALUE, (Double)Double.MAX_VALUE), new Vector3m(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308)};
        for (PointCube point : new PointCube[]{this.firstPoint, this.secondPoint}) {
            if (point.getPoint().getX() + off1 > out[1].getX()) {
                out[1].setX(point.getPoint().getX() + off1);
            }
            if (point.getPoint().getX() - off < out[0].getX()) {
                out[0].setX(point.getPoint().getX() - off);
            }
            if (point.getPoint().getY() + off1 > out[1].getY()) {
                out[1].setY(point.getPoint().getY() + off1);
            }
            if (point.getPoint().getY() - off < out[0].getY()) {
                out[0].setY(point.getPoint().getY() - off);
            }
            if (point.getPoint().getZ() + off1 > out[1].getZ()) {
                out[1].setZ(point.getPoint().getZ() + off1);
            }
            if (!(point.getPoint().getZ() - off < out[0].getZ())) continue;
            out[0].setZ(point.getPoint().getZ() - off);
        }
        return out;
    }

    public RegionType getType() {
        return RegionType.CUBOID;
    }
}

