/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.region;

import wecui.WorldEditCUI;
import wecui.render.LineColor;
import wecui.render.points.PointCube;
import wecui.render.region.BaseRegion;
import wecui.render.region.RegionType;
import wecui.render.shapes.RenderCylinderBox;
import wecui.render.shapes.RenderCylinderCircles;
import wecui.render.shapes.RenderCylinderGrid;

public class CylinderRegion
extends BaseRegion {
    protected PointCube center;
    protected double radX = 0.0;
    protected double radZ = 0.0;
    protected int minY = 0;
    protected int maxY = 0;

    public CylinderRegion(WorldEditCUI controller) {
        super(controller);
    }

    public void render() {
        if (this.center != null) {
            this.center.render();
            int tMin = this.minY;
            int tMax = this.maxY;
            if (this.minY == 0 || this.maxY == 0) {
                tMin = (int)this.center.getPoint().getY();
                tMax = (int)this.center.getPoint().getY();
            }
            new RenderCylinderCircles(LineColor.CYLINDERGRID, this.center, this.radX, this.radZ, tMin, tMax).render();
            new RenderCylinderGrid(LineColor.CYLINDERGRID, this.center, this.radX, this.radZ, tMin, tMax).render();
            new RenderCylinderBox(LineColor.CYLINDERBOX, this.center, this.radX, this.radZ, tMin, tMax).render();
        }
    }

    public void setCylinderCenter(int x, int y, int z) {
        this.center = new PointCube(x, y, z);
        this.center.setColor(LineColor.CYLINDERCENTER);
    }

    public void setCylinderRadius(double x, double z) {
        this.radX = x;
        this.radZ = z;
    }

    public void setMinMax(int min, int max) {
        this.minY = min;
        this.maxY = max;
    }

    public RegionType getType() {
        return RegionType.CYLINDER;
    }
}

