/*
 * Decompiled with CFR 0.152.
 */
package wecui.render.shapes;

import java.util.List;
import wecui.obfuscation.RenderObfuscation;
import wecui.render.LineColor;
import wecui.render.LineInfo;
import wecui.render.points.PointRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Render2DBox {
    protected RenderObfuscation obf = RenderObfuscation.getInstance();
    protected LineColor color;
    protected List<PointRectangle> points;
    protected int min;
    protected int max;

    public Render2DBox(LineColor color, List<PointRectangle> points, int min, int max) {
        this.color = color;
        this.points = points;
        this.min = min;
        this.max = max;
    }

    public void render() {
        double off = 0.03;
        for (LineInfo tempColor : this.color.getColors()) {
            tempColor.prepareRender();
            this.obf.startDrawing(1);
            tempColor.prepareColor();
            for (PointRectangle point : this.points) {
                if (point == null) continue;
                this.obf.addVertex((double)point.getPoint().getX() + 0.5, (double)this.min + off, (double)point.getPoint().getY() + 0.5);
                this.obf.addVertex((double)point.getPoint().getX() + 0.5, (double)(this.max + 1) + off, (double)point.getPoint().getY() + 0.5);
            }
            this.obf.finishDrawing();
        }
    }
}

