/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.jnbt;

import java.util.Collections;
import java.util.List;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.jnbt.Tag;

public final class ListTag
extends Tag {
    private final Class<? extends com.sk89q.jnbt.Tag> type;
    private final List<com.sk89q.jnbt.Tag> value;

    public ListTag(String name, Class<? extends com.sk89q.jnbt.Tag> type, List<? extends com.sk89q.jnbt.Tag> value) {
        super(name);
        this.type = type;
        this.value = Collections.unmodifiableList(value);
    }

    public Class<? extends com.sk89q.jnbt.Tag> getType() {
        return this.type;
    }

    @Override
    public List<com.sk89q.jnbt.Tag> getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_List" + append + ": " + this.value.size() + " entries of type " + NBTUtils.getTypeName(this.type) + "\r\n{\r\n");
        for (Tag tag : this.value) {
            bldr.append("   " + tag.toString().replaceAll("\r\n", "\r\n   ") + "\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }
}

