/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.ByteTag;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.ListTag;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.jnbt.ShortTag;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseItemStack;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;

public abstract class ContainerBlock
extends BaseBlock
implements TileEntityBlock {
    private BaseItemStack[] items;

    public ContainerBlock(int type, int inventorySize) {
        super(type);
        this.items = new BaseItemStack[inventorySize];
    }

    public ContainerBlock(int type, int data, int inventorySize) {
        super(type, data);
        this.items = new BaseItemStack[inventorySize];
    }

    public BaseItemStack[] getItems() {
        return this.items;
    }

    public void setItems(BaseItemStack[] items) {
        this.items = items;
    }

    public Map<String, Tag> serializeItem(BaseItemStack item) {
        HashMap<String, Tag> data = new HashMap<String, Tag>();
        data.put("id", (Tag)new ShortTag("id", (short)item.getType()));
        data.put("Damage", (Tag)new ShortTag("Damage", item.getDamage()));
        data.put("Count", (Tag)new ByteTag("Count", (byte)item.getAmount()));
        if (item.getEnchantments().size() > 0) {
            ArrayList<CompoundTag> enchantmentList = new ArrayList<CompoundTag>();
            for (Map.Entry<Integer, Integer> entry : item.getEnchantments().entrySet()) {
                HashMap<String, Tag> enchantment = new HashMap<String, Tag>();
                enchantment.put("id", (Tag)new ShortTag("id", entry.getKey().shortValue()));
                enchantment.put("lvl", (Tag)new ShortTag("lvl", entry.getValue().shortValue()));
                enchantmentList.add(new CompoundTag(null, enchantment));
            }
            HashMap<String, Tag> auxData = new HashMap<String, Tag>();
            auxData.put("ench", (Tag)new ListTag("ench", CompoundTag.class, enchantmentList));
            data.put("tag", (Tag)new CompoundTag("tag", auxData));
        }
        return data;
    }

    public BaseItemStack deserializeItem(Map<String, Tag> data) throws DataException {
        short id = NBTUtils.getChildTag(data, "id", ShortTag.class).getValue();
        short damage = NBTUtils.getChildTag(data, "Damage", ShortTag.class).getValue();
        byte count = NBTUtils.getChildTag(data, "Count", ByteTag.class).getValue();
        BaseItemStack stack = new BaseItemStack(id, count, damage);
        if (data.containsKey("tag")) {
            Object auxData = NBTUtils.getChildTag(data, "tag", CompoundTag.class).getValue();
            ListTag ench = (ListTag)auxData.get("ench");
            Iterator i$ = ench.getValue().iterator();
            while (i$.hasNext()) {
                wecui.vendor.com.sk89q.jnbt.Tag e = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
                Object vars = ((CompoundTag)e).getValue();
                short enchId = NBTUtils.getChildTag((Map<String, Tag>)vars, "id", ShortTag.class).getValue();
                short enchLevel = NBTUtils.getChildTag((Map<String, Tag>)vars, "lvl", ShortTag.class).getValue();
                stack.getEnchantments().put(Integer.valueOf(enchId), Integer.valueOf(enchLevel));
            }
        }
        return stack;
    }

    public BaseItemStack[] deserializeInventory(List<com.sk89q.jnbt.CompoundTag> items) throws DataException {
        BaseItemStack[] stacks = new BaseItemStack[items.size()];
        for (CompoundTag compoundTag : items) {
            Object item = compoundTag.getValue();
            BaseItemStack stack = this.deserializeItem((Map<String, Tag>)item);
            byte slot = NBTUtils.getChildTag((Map<String, Tag>)item, "Slot", ByteTag.class).getValue();
            if (slot < 0 || slot >= stacks.length) continue;
            stacks[slot] = stack;
        }
        return stacks;
    }

    public List<com.sk89q.jnbt.CompoundTag> serializeInventory(BaseItemStack[] items) {
        ArrayList<com.sk89q.jnbt.CompoundTag> tags = new ArrayList<com.sk89q.jnbt.CompoundTag>();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            Map<String, Tag> tagData = this.serializeItem(items[i]);
            tagData.put("Slot", (Tag)new ByteTag("Slot", (byte)i));
            tags.add((com.sk89q.jnbt.CompoundTag)new CompoundTag("", tagData));
        }
        return tags;
    }
}

