/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockWorldVector;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Location;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitWorld;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitExpOrb;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitItem;

public class BukkitUtil {
    private static final Map<World, com.sk89q.worldedit.LocalWorld> wlw = new HashMap<World, com.sk89q.worldedit.LocalWorld>();
    public static final double EQUALS_PRECISION = 1.0E-4;

    private BukkitUtil() {
    }

    public static LocalWorld getLocalWorld(World w) {
        LocalWorld lw = (LocalWorld)wlw.get(w);
        if (lw == null) {
            lw = new BukkitWorld(w);
            wlw.put(w, (com.sk89q.worldedit.LocalWorld)lw);
        }
        return lw;
    }

    public static BlockVector toVector(Block block) {
        return new BlockVector(block.getX(), block.getY(), block.getZ());
    }

    public static BlockVector toVector(BlockFace face) {
        return new BlockVector(face.getModX(), face.getModY(), face.getModZ());
    }

    public static BlockWorldVector toWorldVector(Block block) {
        return new BlockWorldVector(BukkitUtil.getLocalWorld(block.getWorld()), block.getX(), block.getY(), block.getZ());
    }

    public static Vector toVector(org.bukkit.Location loc) {
        return new Vector(loc.getX(), loc.getY(), loc.getZ());
    }

    public static Location toLocation(org.bukkit.Location loc) {
        return new Location(BukkitUtil.getLocalWorld(loc.getWorld()), new Vector(loc.getX(), loc.getY(), loc.getZ()), loc.getYaw(), loc.getPitch());
    }

    public static Vector toVector(org.bukkit.util.Vector vector) {
        return new Vector(vector.getX(), vector.getY(), vector.getZ());
    }

    public static org.bukkit.Location toLocation(WorldVector pt) {
        return new org.bukkit.Location(BukkitUtil.toWorld(pt), pt.getX(), pt.getY(), pt.getZ());
    }

    public static org.bukkit.Location toLocation(World world, Vector pt) {
        return new org.bukkit.Location(world, pt.getX(), pt.getY(), pt.getZ());
    }

    public static org.bukkit.Location center(org.bukkit.Location loc) {
        return new org.bukkit.Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY() + 0.5, (double)loc.getBlockZ() + 0.5, loc.getPitch(), loc.getYaw());
    }

    public static Player matchSinglePlayer(Server server, String name) {
        List players = server.matchPlayer(name);
        if (players.size() == 0) {
            return null;
        }
        return (Player)players.get(0);
    }

    public static Block toBlock(BlockWorldVector pt) {
        return BukkitUtil.toWorld(pt).getBlockAt(BukkitUtil.toLocation(pt));
    }

    public static World toWorld(WorldVector pt) {
        return ((BukkitWorld)pt.getWorld()).getWorld();
    }

    public static boolean equals(org.bukkit.Location a, org.bukkit.Location b) {
        if (Math.abs(a.getX() - b.getX()) > 1.0E-4) {
            return false;
        }
        if (Math.abs(a.getY() - b.getY()) > 1.0E-4) {
            return false;
        }
        return !(Math.abs(a.getZ() - b.getZ()) > 1.0E-4);
    }

    public static org.bukkit.Location toLocation(Location teleportLocation) {
        Vector pt = teleportLocation.getPosition();
        return new org.bukkit.Location(BukkitUtil.toWorld(teleportLocation.getWorld()), pt.getX(), pt.getY(), pt.getZ(), teleportLocation.getYaw(), teleportLocation.getPitch());
    }

    public static World toWorld(LocalWorld world) {
        return ((BukkitWorld)world).getWorld();
    }

    public static BukkitEntity toLocalEntity(Entity e) {
        switch (e.getType()) {
            case EXPERIENCE_ORB: {
                return new BukkitExpOrb(BukkitUtil.toLocation(e.getLocation()), e.getUniqueId(), ((ExperienceOrb)e).getExperience());
            }
            case DROPPED_ITEM: {
                return new BukkitItem(BukkitUtil.toLocation(e.getLocation()), ((Item)e).getItemStack(), e.getUniqueId());
            }
        }
        return new BukkitEntity(BukkitUtil.toLocation(e.getLocation()), e.getType(), e.getUniqueId());
    }
}

