/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.expression.runtime;

import com.sk89q.worldedit.expression.runtime.Functions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import wecui.vendor.com.sk89q.worldedit.expression.Expression;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.EvaluationException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Function;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.LValue;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.LValueFunction;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;

public final class Functions {
    private static final Map<String, List<Functions.Overload>> functions = new HashMap<String, List<Functions.Overload>>();
    private static final Map<Integer, double[]> gmegabuf;
    private static final Random random;

    public static final Function getFunction(int position, String name, RValue ... args) throws NoSuchMethodException {
        Method getter = Functions.getMethod(name, false, args);
        try {
            Method setter = Functions.getMethod(name, true, args);
            return new LValueFunction(position, getter, setter, args);
        }
        catch (NoSuchMethodException e) {
            return new Function(position, getter, args);
        }
    }

    private static Method getMethod(String name, boolean isSetter, RValue ... args) throws NoSuchMethodException {
        List<Functions.Overload> overloads = functions.get(name);
        if (overloads != null) {
            for (Overload overload : overloads) {
                if (!overload.matches(isSetter, args)) continue;
                return overload.method;
            }
        }
        throw new NoSuchMethodException();
    }

    public static void addFunction(Method method) throws IllegalArgumentException {
        String methodName = method.getName();
        Overload overload = new Overload(method);
        List<Functions.Overload> overloads = functions.get(methodName);
        if (overloads == null) {
            overloads = new ArrayList<Functions.Overload>();
            functions.put(methodName, overloads);
        }
        overloads.add((Functions.Overload)overload);
    }

    public static final double sin(RValue x) throws EvaluationException {
        return Math.sin(x.getValue());
    }

    public static final double cos(RValue x) throws EvaluationException {
        return Math.cos(x.getValue());
    }

    public static final double tan(RValue x) throws EvaluationException {
        return Math.tan(x.getValue());
    }

    public static final double asin(RValue x) throws EvaluationException {
        return Math.asin(x.getValue());
    }

    public static final double acos(RValue x) throws EvaluationException {
        return Math.acos(x.getValue());
    }

    public static final double atan(RValue x) throws EvaluationException {
        return Math.atan(x.getValue());
    }

    public static final double atan2(RValue y, RValue x) throws EvaluationException {
        return Math.atan2(y.getValue(), x.getValue());
    }

    public static final double sinh(RValue x) throws EvaluationException {
        return Math.sinh(x.getValue());
    }

    public static final double cosh(RValue x) throws EvaluationException {
        return Math.cosh(x.getValue());
    }

    public static final double tanh(RValue x) throws EvaluationException {
        return Math.tanh(x.getValue());
    }

    public static final double sqrt(RValue x) throws EvaluationException {
        return Math.sqrt(x.getValue());
    }

    public static final double cbrt(RValue x) throws EvaluationException {
        return Math.cbrt(x.getValue());
    }

    public static final double abs(RValue x) throws EvaluationException {
        return Math.abs(x.getValue());
    }

    public static final double min(RValue a, RValue b) throws EvaluationException {
        return Math.min(a.getValue(), b.getValue());
    }

    public static final double min(RValue a, RValue b, RValue c) throws EvaluationException {
        return Math.min(a.getValue(), Math.min(b.getValue(), c.getValue()));
    }

    public static final double max(RValue a, RValue b) throws EvaluationException {
        return Math.max(a.getValue(), b.getValue());
    }

    public static final double max(RValue a, RValue b, RValue c) throws EvaluationException {
        return Math.max(a.getValue(), Math.max(b.getValue(), c.getValue()));
    }

    public static final double ceil(RValue x) throws EvaluationException {
        return Math.ceil(x.getValue());
    }

    public static final double floor(RValue x) throws EvaluationException {
        return Math.floor(x.getValue());
    }

    public static final double rint(RValue x) throws EvaluationException {
        return Math.rint(x.getValue());
    }

    public static final double round(RValue x) throws EvaluationException {
        return Math.round(x.getValue());
    }

    public static final double exp(RValue x) throws EvaluationException {
        return Math.exp(x.getValue());
    }

    public static final double ln(RValue x) throws EvaluationException {
        return Math.log(x.getValue());
    }

    public static final double log(RValue x) throws EvaluationException {
        return Math.log(x.getValue());
    }

    public static final double log10(RValue x) throws EvaluationException {
        return Math.log10(x.getValue());
    }

    public static final double rotate(LValue x, LValue y, RValue angle) throws EvaluationException {
        double f = angle.getValue();
        double cosF = Math.cos(f);
        double sinF = Math.sin(f);
        double xOld = x.getValue();
        double yOld = y.getValue();
        x.assign(xOld * cosF - yOld * sinF);
        y.assign(xOld * sinF + yOld * cosF);
        return 0.0;
    }

    public static final double swap(LValue x, LValue y) throws EvaluationException {
        double tmp = x.getValue();
        x.assign(y.getValue());
        y.assign(tmp);
        return 0.0;
    }

    private static double[] getSubBuffer(Map<Integer, double[]> megabuf, Integer key) {
        double[] ret = megabuf.get(key);
        if (ret == null) {
            ret = new double[1024];
            megabuf.put(key, ret);
        }
        return ret;
    }

    @Function.Dynamic
    public static final double gmegabuf(RValue index) throws EvaluationException {
        int intIndex = (int)index.getValue();
        return Functions.getSubBuffer(gmegabuf, intIndex & 0xFFFFFC00)[intIndex & 0x3FF];
    }

    @Function.Dynamic
    public static final double gmegabuf(RValue index, double value) throws EvaluationException {
        int intIndex = (int)index.getValue();
        double d = value;
        Functions.getSubBuffer(Functions.gmegabuf, (Integer)Integer.valueOf((int)(intIndex & 0xFFFFFC00)))[intIndex & 0x3FF] = d;
        return d;
    }

    @Function.Dynamic
    public static final double megabuf(RValue index) throws EvaluationException {
        int intIndex = (int)index.getValue();
        return Functions.getSubBuffer(Expression.getInstance().getMegabuf(), intIndex & 0xFFFFFC00)[intIndex & 0x3FF];
    }

    @Function.Dynamic
    public static final double megabuf(RValue index, double value) throws EvaluationException {
        int intIndex = (int)index.getValue();
        double d = value;
        Functions.getSubBuffer(Expression.getInstance().getMegabuf(), (Integer)Integer.valueOf((int)(intIndex & 0xFFFFFC00)))[intIndex & 0x3FF] = d;
        return d;
    }

    @Function.Dynamic
    public static final double random() {
        return random.nextDouble();
    }

    @Function.Dynamic
    public static final double randint(RValue max) throws EvaluationException {
        return random.nextInt((int)Math.floor(max.getValue()));
    }

    static {
        for (Method method : Functions.class.getMethods()) {
            try {
                Functions.addFunction(method);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        gmegabuf = new HashMap<Integer, double[]>();
        random = new Random();
    }

    private static class Overload {
        private final Method method;
        private final int mask;
        private final boolean isSetter;

        public Overload(Method method) throws IllegalArgumentException {
            Class<?>[] parameters;
            this.method = method;
            boolean isSetter = false;
            int accum = 0;
            for (Class<?> parameter : parameters = method.getParameterTypes()) {
                if (isSetter) {
                    throw new IllegalArgumentException("Method takes arguments that can't be cast to RValue.");
                }
                if (Double.TYPE.equals(parameter)) {
                    isSetter = true;
                    continue;
                }
                if (!RValue.class.isAssignableFrom(parameter)) {
                    throw new IllegalArgumentException("Method takes arguments that can't be cast to RValue.");
                }
                accum <<= 2;
                if (LValue.class.isAssignableFrom(parameter)) {
                    accum |= 3;
                    continue;
                }
                accum |= 1;
            }
            this.mask = accum;
            this.isSetter = isSetter;
        }

        public boolean matches(boolean isSetter, RValue ... args) {
            if (this.isSetter != isSetter) {
                return false;
            }
            int accum = 0;
            for (RValue argument : args) {
                accum <<= 2;
                if (argument instanceof LValue) {
                    accum |= 3;
                    continue;
                }
                accum |= 1;
            }
            return (accum & this.mask) == this.mask;
        }
    }
}

