/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.patterns;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.patterns.BlockChance;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;

public class RandomFillPattern
implements Pattern {
    private static final Random random = new Random();
    private List<com.sk89q.worldedit.patterns.BlockChance> blocks;

    public RandomFillPattern(List<com.sk89q.worldedit.patterns.BlockChance> blocks) {
        double max = 0.0;
        for (BlockChance blockChance : blocks) {
            max += blockChance.getChance();
        }
        ArrayList<com.sk89q.worldedit.patterns.BlockChance> finalBlocks = new ArrayList<com.sk89q.worldedit.patterns.BlockChance>();
        double d = 0.0;
        for (BlockChance blockChance : blocks) {
            double v = blockChance.getChance() / max;
            finalBlocks.add((com.sk89q.worldedit.patterns.BlockChance)new BlockChance(blockChance.getBlock(), d += v));
        }
        this.blocks = finalBlocks;
    }

    @Override
    public BaseBlock next(Vector pos) {
        double r = random.nextDouble();
        for (BlockChance blockChance : this.blocks) {
            if (!(r <= blockChance.getChance())) continue;
            return blockChance.getBlock();
        }
        throw new RuntimeException("ProportionalFillPattern");
    }

    @Override
    public BaseBlock next(int x, int y, int z) {
        return this.next(null);
    }
}

