/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.schematic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.CuboidClipboard;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.ChestBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.DispenserBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.FurnaceBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.schematic.MCEditSchematicFormat;

public abstract class SchematicFormat {
    private static final Map<String, com.sk89q.worldedit.schematic.SchematicFormat> SCHEMATIC_FORMATS = new HashMap<String, com.sk89q.worldedit.schematic.SchematicFormat>();
    public static final SchematicFormat MCEDIT = new MCEditSchematicFormat();
    private final String name;
    private final String[] lookupNames;

    public static Set<com.sk89q.worldedit.schematic.SchematicFormat> getFormats() {
        return Collections.unmodifiableSet(new HashSet<com.sk89q.worldedit.schematic.SchematicFormat>(SCHEMATIC_FORMATS.values()));
    }

    public static SchematicFormat getFormat(String lookupName) {
        return (SchematicFormat)SCHEMATIC_FORMATS.get(lookupName.toLowerCase());
    }

    public static SchematicFormat getFormat(File file) {
        if (!file.isFile()) {
            return null;
        }
        for (SchematicFormat schematicFormat : SCHEMATIC_FORMATS.values()) {
            if (!schematicFormat.isOfFormat(file)) continue;
            return schematicFormat;
        }
        return null;
    }

    protected SchematicFormat(String name, String ... lookupNames) {
        this.name = name;
        ArrayList<String> registeredLookupNames = new ArrayList<String>(lookupNames.length);
        for (int i = 0; i < lookupNames.length; ++i) {
            if (i != 0 && SCHEMATIC_FORMATS.containsKey(lookupNames[i].toLowerCase())) continue;
            SCHEMATIC_FORMATS.put(lookupNames[i].toLowerCase(), (com.sk89q.worldedit.schematic.SchematicFormat)this);
            registeredLookupNames.add(lookupNames[i].toLowerCase());
        }
        this.lookupNames = registeredLookupNames.toArray(new String[registeredLookupNames.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String[] getLookupNames() {
        return this.lookupNames;
    }

    public BaseBlock getBlockForId(int id, short data) {
        BaseBlock block;
        switch (id) {
            case 63: 
            case 68: {
                block = new SignBlock(id, data);
                break;
            }
            case 54: {
                block = new ChestBlock(data);
                break;
            }
            case 61: 
            case 62: {
                block = new FurnaceBlock(id, data);
                break;
            }
            case 23: {
                block = new DispenserBlock(data);
                break;
            }
            case 52: {
                block = new MobSpawnerBlock(id);
                break;
            }
            case 25: {
                block = new NoteBlock(data);
                break;
            }
            default: {
                block = new BaseBlock(id, data);
            }
        }
        return block;
    }

    public abstract CuboidClipboard load(File var1) throws IOException, DataException;

    public abstract void save(CuboidClipboard var1, File var2) throws IOException, DataException;

    public abstract boolean isOfFormat(File var1);
}

