/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.snapshots;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.FileLegacyChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.FileMcRegionChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.TrueZipLegacyChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.TrueZipMcRegionChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.ZippedLegacyChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.ZippedMcRegionChunkStore;
import wecui.vendor.com.sk89q.worldedit.snapshots.SnapshotRepository;

public class Snapshot
implements Comparable<com.sk89q.worldedit.snapshots.Snapshot> {
    protected static Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    protected File file;
    protected String name;
    protected Calendar date;

    public Snapshot(SnapshotRepository repo, String snapshot) {
        this.file = new File(repo.getDirectory(), snapshot);
        this.name = snapshot;
    }

    public ChunkStore getChunkStore() throws IOException, DataException {
        ChunkStore chunkStore = this._getChunkStore();
        logger.info("WorldEdit: Using " + chunkStore.getClass().getCanonicalName() + " for loading snapshot '" + this.file.getAbsolutePath() + "'");
        return chunkStore;
    }

    public ChunkStore _getChunkStore() throws IOException, DataException {
        if (this.file.getName().toLowerCase().endsWith(".zip")) {
            try {
                TrueZipMcRegionChunkStore chunkStore = new TrueZipMcRegionChunkStore(this.file);
                if (!((ChunkStore)chunkStore).isValid()) {
                    return new TrueZipLegacyChunkStore(this.file);
                }
                return chunkStore;
            }
            catch (NoClassDefFoundError e) {
                ZippedMcRegionChunkStore chunkStore = new ZippedMcRegionChunkStore(this.file);
                if (!((ChunkStore)chunkStore).isValid()) {
                    return new ZippedLegacyChunkStore(this.file);
                }
                return chunkStore;
            }
        }
        if (this.file.getName().toLowerCase().endsWith(".tar.bz2") || this.file.getName().toLowerCase().endsWith(".tar.gz") || this.file.getName().toLowerCase().endsWith(".tar")) {
            try {
                TrueZipMcRegionChunkStore chunkStore = new TrueZipMcRegionChunkStore(this.file);
                if (!((ChunkStore)chunkStore).isValid()) {
                    return new TrueZipLegacyChunkStore(this.file);
                }
                return chunkStore;
            }
            catch (NoClassDefFoundError e) {
                throw new DataException("TrueZIP is required for .tar support");
            }
        }
        FileMcRegionChunkStore chunkStore = new FileMcRegionChunkStore(this.file);
        if (!((ChunkStore)chunkStore).isValid()) {
            return new FileLegacyChunkStore(this.file);
        }
        return chunkStore;
    }

    public boolean containsWorld(String worldname) {
        try {
            if (this.file.getName().toLowerCase().endsWith(".zip")) {
                ZipFile entry = new ZipFile(this.file);
                return entry.getEntry(worldname) != null || entry.getEntry(worldname + "/level.dat") != null;
            }
            if (this.file.getName().toLowerCase().endsWith(".tar.bz2") || this.file.getName().toLowerCase().endsWith(".tar.gz") || this.file.getName().toLowerCase().endsWith(".tar")) {
                try {
                    de.schlichtherle.util.zip.ZipFile entry = new de.schlichtherle.util.zip.ZipFile(this.file);
                    return entry.getEntry(worldname) != null;
                }
                catch (NoClassDefFoundError e) {
                    throw new DataException("TrueZIP is required for .tar support");
                }
            }
            return this.file.getName().equalsIgnoreCase(worldname);
        }
        catch (IOException ex) {
            logger.info("Could not load snapshot: " + this.file.getPath());
        }
        catch (DataException dataException) {
            // empty catch block
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    @Override
    public int compareTo(Snapshot o) {
        if (o.date == null || this.date == null) {
            int i = this.name.indexOf("/");
            int j = o.name.indexOf("/");
            return this.name.substring(i > 0 ? 0 : i).compareTo(o.name.substring(j > 0 ? 0 : j));
        }
        return this.date.compareTo(o.date);
    }

    public boolean equals(Object o) {
        if (o instanceof Snapshot) {
            return this.file.equals(((Snapshot)o).file);
        }
        return false;
    }
}

