/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.spout.selections;

import com.sk89q.worldedit.BlockVector2D;
import java.util.Collections;
import java.util.List;
import org.spout.api.geo.World;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.regions.Polygonal2DRegion;
import wecui.vendor.com.sk89q.worldedit.regions.Polygonal2DRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.RegionSelector;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutUtil;
import wecui.vendor.com.sk89q.worldedit.spout.selections.RegionSelection;

public class Polygonal2DSelection
extends RegionSelection {
    protected Polygonal2DRegion poly2d;

    public Polygonal2DSelection(World world, RegionSelector sel, Polygonal2DRegion region) {
        super(world, sel, region);
        this.poly2d = region;
    }

    public Polygonal2DSelection(World world, List<BlockVector2D> points, int minY, int maxY) {
        super(world);
        LocalWorld lWorld = SpoutUtil.getLocalWorld(world);
        minY = Math.min(Math.max(0, minY), world.getHeight());
        maxY = Math.min(Math.max(0, maxY), world.getHeight());
        Polygonal2DRegionSelector sel = new Polygonal2DRegionSelector(lWorld, points, minY, maxY);
        this.poly2d = sel.getIncompleteRegion();
        this.setRegionSelector(sel);
        this.setRegion(this.poly2d);
    }

    public List<BlockVector2D> getNativePoints() {
        return Collections.unmodifiableList(this.poly2d.getPoints());
    }
}

