/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.BlockType;
import wecui.vendor.com.sk89q.worldedit.tools.DoubleActionBlockTool;

public class BlockReplacer
implements DoubleActionBlockTool {
    private BaseBlock targetBlock;

    public BlockReplacer(BaseBlock targetBlock) {
        this.targetBlock = targetBlock;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.replacer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        BlockBag bag = session.getBlockBag(player);
        LocalWorld world = clicked.getWorld();
        EditSession editSession = new EditSession(world, -1, bag);
        try {
            editSession.setBlock((Vector)clicked, this.targetBlock);
        }
        catch (MaxChangedBlocksException e) {
        }
        finally {
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
        }
        return true;
    }

    @Override
    public boolean actSecondary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        this.targetBlock = new EditSession(world, -1).getBlock(clicked);
        BlockType type = BlockType.fromID(this.targetBlock.getType());
        if (type != null) {
            player.print("Replacer tool switched to: " + type.getName());
        }
        return true;
    }
}

