/*
 * Decompiled with CFR 0.152.
 */
import forge.MinecraftForge;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class mod_3DItems
extends BaseMod {
    public static boolean renderIn3D = true;
    public static float itemThickness = 1.0f;
    public Properties prop = new Properties();
    public static boolean optifineInstalled = false;
    public static boolean mcpatcherInstalled = false;
    public static boolean useCountInstalled = false;

    public mod_3DItems() {
        this.loadConfig();
    }

    public String getVersion() {
        return "1.3";
    }

    public void load() {
        MinecraftForge.versionDetect((String)"3DItems", (int)3, (int)3, (int)8);
        System.out.println(this.checkOptifineInstallation());
        System.out.println(this.checkMCPatcherInstallation());
        System.out.println(this.checkUseCountInstallation());
        System.out.println("[3DItems] Icon width: " + ItemRenderer3D.getTextureWidth());
    }

    public String checkOptifineInstallation() {
        try {
            Class.forName("Config", false, ((Object)((Object)this)).getClass().getClassLoader());
            Class.forName("GuiAnimationSettingsOF", false, ((Object)((Object)this)).getClass().getClassLoader());
            Class.forName("GuiQualitySettingsOF", false, ((Object)((Object)this)).getClass().getClassLoader());
            Class.forName("GuiPerformanceSettingsOF", false, ((Object)((Object)this)).getClass().getClassLoader());
            optifineInstalled = true;
            return "[3DItems] Optifine detected!";
        }
        catch (ClassNotFoundException e) {
            optifineInstalled = false;
            return "[3DItems] Optifine not installed!";
        }
    }

    public String checkMCPatcherInstallation() {
        try {
            Class.forName("com.pclewis.mcpatcher.MCPatcherUtils", false, ((Object)((Object)this)).getClass().getClassLoader());
            Class.forName("com.pclewis.mcpatcher.mod.TileSize", false, ((Object)((Object)this)).getClass().getClassLoader());
            mcpatcherInstalled = true;
            return "[3DItems] MCPatcher detected!";
        }
        catch (ClassNotFoundException e) {
            mcpatcherInstalled = false;
            return "[3DItems] MCPatcher not installed!";
        }
    }

    public String checkUseCountInstallation() {
        try {
            Class.forName("mod_UseCount", false, ((Object)((Object)this)).getClass().getClassLoader());
            useCountInstalled = true;
            return "[3DItems] UseCount mod detected!";
        }
        catch (ClassNotFoundException e) {
            useCountInstalled = false;
            return "[3DItems] UseCount mod not installed!";
        }
    }

    public static Class loadClass(String name) {
        try {
            Class<?> cl = Class.forName(name, false, mod_3DItems.class.getClassLoader());
            return cl;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void bindCorrectTexture(aan items) {
        aaw re = ModLoader.getMinecraftInstance().p;
        re.b(re.b(items.a().getTextureFile()));
    }

    public void loadConfig() {
        String fileName = "/config/3DItemsConfig.cfg";
        try {
            File file = new File(Minecraft.b() + fileName);
            boolean flag = file.createNewFile();
            if (flag) {
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                this.prop.setProperty("render3DItems", Boolean.toString(true));
                this.prop.setProperty("item-thickness", Float.toString(1.0f));
                this.prop.store(fileoutputstream, "3DItems Config");
                fileoutputstream.close();
            }
            this.prop.load(new FileInputStream(Minecraft.b() + fileName));
            renderIn3D = Boolean.parseBoolean(this.prop.getProperty("render3DItems"));
            itemThickness = Float.parseFloat(this.prop.getProperty("item-thickness"));
        }
        catch (IOException ioexception) {
            System.out.println("Unable to load " + fileName);
        }
        catch (NullPointerException e) {
            System.out.println("Corruted config! Delete it!");
        }
    }
}

