/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IMutation;
import forestry.apiculture.ItemBeeGE;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.Proxy;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;

public class GuiApiaristInventory
extends GuiForestry {
    private io inventory;
    private int startX;
    private int startY;
    private IBee bee;
    private IApiaristTracker breedingTracker;
    private aan[] iconStacks = new aan[256];

    public GuiApiaristInventory(yw player, ContainerForestry container, io inventory) {
        super("/gfx/forestry/gui/apiaristinventory.png", container, inventory, 5, 25);
        this.inventory = inventory;
        this.xSize = 196;
        this.ySize = 202;
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE).addCreativeItems(beeList, false);
        Iterator i$ = beeList.iterator();
        while (i$.hasNext()) {
            aan beeStack;
            this.iconStacks[BeeManager.beeInterface.getBee((aan)beeStack).getMeta()] = beeStack = (aan)i$.next();
        }
        this.breedingTracker = BeeManager.breedingManager.getApiaristTracker(player.k);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        int tex = this.p.p.b(this.textureFile);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.p.p.b(tex);
        this.b(this.startX, this.startY, 0, 0, this.xSize, this.ySize);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.u.b(header, this.startX + 95 + this.getCenteredOffset(header, 98), this.startY + 10, this.fontColor.get("gui.title"));
        if (this.bee == null) {
            this.displayBreedingStatistics(this.startX + 8, this.startY + 8);
        }
        if (this.bee != null) {
            tf.c();
            this.displaySpeciesInformation(true, this.bee.getGenome().getPrimaryAsBee(), this.iconStacks[this.bee.getMeta()], this.startX + 8, this.startY + 8);
            if (this.bee.getMeta() != this.bee.getGenome().getSecondary().getId()) {
                this.displaySpeciesInformation(this.bee.isAnalyzed(), this.bee.getGenome().getSecondaryAsBee(), this.iconStacks[this.bee.getGenome().getSecondaryAsBee().getId()], this.startX + 8, this.startY + 58);
            }
        }
    }

    @Override
    public void e() {
        super.e();
        if (this.p.h == null) {
            return;
        }
        if (this.inventorySlots instanceof ContainerItemInventory) {
            ((ContainerItemInventory)this.inventorySlots).purgeBag((yw)this.p.h);
        }
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (this.inventory instanceof ItemInventory) {
            ItemInventory inv = (ItemInventory)this.inventory;
            if (inv.isItemInventory) {
                inv.onGuiSaved((yw)this.p.h);
            }
        }
    }

    @Override
    public void c() {
        super.c();
        this.startX = (this.q - this.xSize) / 2;
        this.startY = (this.r - this.ySize) / 2;
        this.s.add(new abp(1, this.startX + 99, this.startY + 7, 10, 12, "<"));
        this.s.add(new abp(2, this.startX + 179, this.startY + 7, 10, 12, ">"));
    }

    protected void a(abp guibutton) {
        super.a(guibutton);
        if (guibutton.f == 1 && this.pageCurrent > 0) {
            this.flipPage(this.pageCurrent - 1);
        } else if (guibutton.f == 2 && this.pageCurrent < this.pageMax - 1) {
            this.flipPage(this.pageCurrent + 1);
        }
    }

    @Override
    protected void b(int i, int j, int k) {
        super.b(i, j, k);
        yu slot = this.getSlotAtPosition(i, j);
        if (slot == null) {
            this.resetAnalyzer();
            return;
        }
        if (!slot.c()) {
            this.resetAnalyzer();
            return;
        }
        aan itemstack = slot.b();
        if (!BeeManager.beeInterface.isBee(itemstack)) {
            this.resetAnalyzer();
            return;
        }
        this.updateAnalyzer(itemstack);
    }

    private void resetAnalyzer() {
        this.bee = null;
    }

    private void updateAnalyzer(aan itemstack) {
        ady nbttagcompound = itemstack.o();
        if (nbttagcompound == null) {
            return;
        }
        this.bee = new Bee(nbttagcompound);
    }

    private void displayBreedingStatistics(int x, int y) {
        this.u.b(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + BeeManager.beeSpeciesCount, x + 2, y + 4, this.fontColor.get("gui.screen"));
        this.u.b(StringUtil.localize("gui.queens") + ": " + this.breedingTracker.getQueenCount(), x + 2, y + 20, this.fontColor.get("gui.screen"));
        this.u.b(StringUtil.localize("gui.princesses") + ": " + this.breedingTracker.getPrincessCount(), x + 2, y + 36, this.fontColor.get("gui.screen"));
        this.u.b(StringUtil.localize("gui.drones") + ": " + this.breedingTracker.getDroneCount(), x + 2, y + 52, this.fontColor.get("gui.screen"));
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleBeeSpecies species, aan iconStack, int x, int y) {
        if (!analyzed) {
            this.u.b(StringUtil.localize("gui.unknown"), x + 2, y + 4, this.fontColor.get("gui.screen"));
            return;
        }
        this.u.b(species.getName(), x + 2, y + 4, this.fontColor.get("gui.screen"));
        itemRenderer.a(this.u, this.p.p, iconStack, x + 69, y + 1);
        itemRenderer.b(this.u, this.p.p, iconStack, x + 69, y + 1);
        int i = 0;
        for (IMutation combination : BeeTemplates.getCombinations(species)) {
            int column;
            int line;
            if (combination.isSecret()) continue;
            if (i > 4) {
                line = y + 36;
                column = x + (i - 5) * 18;
            } else {
                line = y + 18;
                column = x + i * 18;
            }
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column, line);
            } else {
                this.drawUnknownIcon(combination, column, line);
            }
            ++i;
        }
    }

    private void drawMutationIcon(IMutation combination, IAlleleBeeSpecies species, int x, int y) {
        itemRenderer.a(this.u, this.p.p, this.iconStacks[combination.getPartner(species).getId()], x, y);
        itemRenderer.b(this.u, this.p.p, this.iconStacks[combination.getPartner(species).getId()], x, y);
        int line = 48;
        int column = 0;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(x, y, column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x, int y) {
        int chance = mutation.getBaseChance();
        int line = 0;
        int column = 0;
        if (chance >= 20) {
            line = 16;
            column = 228;
        } else if (chance >= 15) {
            line = 16;
            column = 212;
        } else if (chance >= 12) {
            line = 16;
            column = 196;
        } else if (chance >= 10) {
            line = 0;
            column = 228;
        } else if (chance >= 5) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.p.p.b(this.p.p.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(x, y, column, line, 16, 16);
    }
}

