/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.MutationReqRes;
import forestry.core.utils.Vect;
import java.lang.reflect.Field;

public class MutationEMC
extends MutationReqRes {
    int emcRequired = 0;
    Class condenserClass;
    Field emcField;

    public MutationEMC(IAllele allele0, IAllele allele1, IAllele[] template, int chance, aan blockRequired, Class condenserClass, Field emcField, int emcRequired) {
        super(allele0, allele1, template, chance, blockRequired);
        this.condenserClass = condenserClass;
        this.emcField = emcField;
        this.emcRequired = emcRequired;
    }

    @Override
    public int getChance(xd world, int biomeid, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        Vect[] possibleTargets;
        int chance = super.getChance(world, biomeid, x, y, z, allele0, allele1, genome0, genome1);
        if (chance <= 0) {
            return 0;
        }
        if (this.emcRequired <= 0) {
            return chance;
        }
        for (Vect target : possibleTargets = new Vect[]{new Vect(x + 1, y, z), new Vect(x - 1, y, z), new Vect(x, y, z + 1), new Vect(x, y, z - 1)}) {
            kw entity;
            if (!world.j(target.x, target.y, target.z) || (entity = world.b(target.x, target.y, target.z)) == null) continue;
            if (!this.condenserClass.isInstance(entity)) {
                ModLoader.getLogger().warning("Did not find a relay at " + target.ToString());
                continue;
            }
            int emc = 0;
            try {
                emc = this.emcField.getInt(entity);
            }
            catch (Exception ex) {
                ModLoader.getLogger().warning("Failed to fetch EMC information.");
            }
            if (emc < this.emcRequired * 80) continue;
            boolean removedEMC = false;
            try {
                this.emcField.set(entity, emc - this.emcRequired * 80);
                removedEMC = true;
            }
            catch (Exception ex) {
                ModLoader.getLogger().warning("Failed to set EMC information.");
            }
            if (!removedEMC) continue;
            return chance;
        }
        return 0;
    }
}

