/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.genetics.Allele;
import forestry.core.genetics.Chromosome;
import java.util.ArrayList;

public class TreeTemplates {
    public static ArrayList speciesTemplates = new ArrayList();
    public static ArrayList treeTemplates = new ArrayList();

    public static IAllele[] getDefaultTemplate() {
        IAllele[] alleles = new IAllele[EnumTreeChromosome.values().length];
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeOak;
        alleles[EnumTreeChromosome.GROWTH.ordinal()] = Allele.growthLightlevel;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightMax10;
        alleles[EnumTreeChromosome.SAPLINGS.ordinal()] = Allele.saplingsDefault;
        alleles[EnumTreeChromosome.YIELD.ordinal()] = Allele.yieldDefault;
        alleles[EnumTreeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = Allele.toleranceNone;
        alleles[EnumTreeChromosome.HUMIDITY_TOLERANCE.ordinal()] = Allele.toleranceNone;
        alleles[EnumTreeChromosome.TERRITORY.ordinal()] = Allele.territoryDefault;
        alleles[EnumTreeChromosome.EFFECT.ordinal()] = Allele.leavesNone;
        return alleles;
    }

    public static IAllele[] getOakTemplate() {
        return TreeTemplates.getDefaultTemplate();
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] template) {
        Chromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        Chromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    public static ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(TreeTemplates.templateAsChromosomes(template));
    }

    public static ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(TreeTemplates.templateAsChromosomes(templateActive, templateInactive));
    }

    static {
        speciesTemplates.add(TreeTemplates.getOakTemplate());
        for (IAllele[] template : speciesTemplates) {
            treeTemplates.add(new Tree(TreeTemplates.templateAsGenome(template)));
        }
    }
}

